/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.libdata.http.utils;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import anet.channel.util.Utils;
import com.kangxin.common.byh.inter.HeaderTokenCeptor;
import com.kangxin.common.util.AppManager;
import com.kangxin.common.util.LoadingUtil;
import com.kangxin.doctor.libdata.http.bean.RequestNetBean;
import com.kangxin.doctor.libdata.http.callback.DownloadCallback;
import com.kangxin.doctor.libdata.http.callback.RequestNetCallBack;
import com.kangxin.doctor.libdata.http.utils.RequestNetUtils;
import com.kangxin.util.common.LogUtils;
import com.kangxin.util.common.byh.JSONUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpUtils {
    public static OkHttpClient mClient;
    private static OkHttpUtils okHttpUtils;
    private static RequestNetUtils requestNetUtils;

    public OkHttpUtils() {
        requestNetUtils = new RequestNetUtils();
        mClient = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).retryOnConnectionFailure(true).addInterceptor((Interceptor)new HeaderTokenCeptor(Utils.getAppContext())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized OkHttpUtils getInstance() {
        if (okHttpUtils != null) return okHttpUtils;
        Class<OkHttpUtils> clazz = OkHttpUtils.class;
        synchronized (OkHttpUtils.class) {
            if (okHttpUtils != null) return okHttpUtils;
            okHttpUtils = new OkHttpUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return okHttpUtils;
        }
    }

    public void netRequest(String url, Object object, RequestNetCallBack requestNetCallBack) {
        RequestNetBean requestNetBean = new RequestNetBean(object);
        final Activity activity = AppManager.getAppManager().currentActivity();
        if (activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    LoadingUtil.showLoadingDialog((Activity)activity);
                }
            });
        }
        String parm = JSONUtils.objectToJson((Object)requestNetBean);
        requestNetUtils.requestNet(true, url, parm, requestNetCallBack);
    }

    public void netRequestNoDialog(String url, Object object, RequestNetCallBack requestNetCallBack) {
        RequestNetBean requestNetBean = new RequestNetBean(object);
        String parm = JSONUtils.objectToJson((Object)requestNetBean);
        requestNetUtils.requestNet(false, url, parm, requestNetCallBack);
    }

    public void downLoadFile(Context context, String fileUrl, final String destFileDir, final DownloadCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)fileUrl) || !fileUrl.contains("/")) {
            return;
        }
        String fileName = fileUrl.substring(fileUrl.lastIndexOf("/"));
        final File file = new File(destFileDir, fileName);
        if (file.exists()) {
            callBack.onSucc(destFileDir);
            return;
        }
        Request request = new Request.Builder().url(fileUrl).build();
        Call call = mClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callBack.onFail(e, destFileDir);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                InputStream is = null;
                byte[] buf = new byte[2048];
                int len = -1;
                FileOutputStream fos = null;
                try {
                    long total = response.body().contentLength();
                    long current = 0L;
                    is = response.body().byteStream();
                    fos = new FileOutputStream(file);
                    while ((len = is.read(buf)) != -1) {
                        current += (long)len;
                        fos.write(buf, 0, len);
                    }
                    fos.flush();
                    callBack.onSucc(destFileDir);
                }
                catch (IOException e) {
                    callBack.onFail(e, destFileDir);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e) {
                        LogUtils.d((Object)("\u5173\u95ed\u4e0b\u8f7d\u6d41\u5931\u8d25\uff1a" + e));
                    }
                }
            }
        });
    }
}

