/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.libdata.http.utils;

import android.text.TextUtils;
import android.util.Log;
import anet.channel.util.Utils;
import com.kangxin.common.byh.inter.HeaderTokenCeptor;
import com.kangxin.common.http.entity.NetResponseMessage;
import com.kangxin.common.util.LoadingUtil;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.libdata.R;
import com.kangxin.doctor.libdata.http.api.Api;
import com.kangxin.doctor.libdata.http.callback.RequestNetCallBack;
import com.kangxin.doctor.libdata.http.interceptor.HeadInterceptor;
import com.kangxin.doctor.libdata.http.utils.ConstantUtil;
import com.kangxin.util.common.byh.DeviceUtil;
import com.kangxin.util.common.byh.JSONUtils;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RequestNetUtils {
    private static final String TAG = "RequestNetUtils";
    private static OkHttpClient mClient;
    private final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final String SUCC_CODE = "200";
    private final String ACCOUNT_CHECK_FAILECODE = "404";
    private final String LOGIN_FAILE = "401";

    public RequestNetUtils() {
        mClient = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).retryOnConnectionFailure(true).addInterceptor((Interceptor)new HeadInterceptor()).addInterceptor((Interceptor)new HeaderTokenCeptor(Utils.getAppContext())).build();
    }

    private String getCharIfEmpty(String param) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            return "";
        }
        return param;
    }

    public void requestNet(final boolean isDismiss, final String url, String parm, final RequestNetCallBack callBack) {
        Log.i((String)TAG, (String)("OkHttp\u8bf7\u6c42\u63a5\u53e3->" + url + "\u53c2\u6570->" + parm));
        if (TextUtils.isEmpty((CharSequence)url)) {
            Log.i((String)TAG, (String)"\u7f51\u7edc\u8bf7\u6c42\u53ca\u6570\u636e\u5904\u7406\u5f02\u5e38\u4fe1\u606f:\u8bf7\u6c42\u94fe\u63a5\u4e3a\u7a7a");
            return;
        }
        RequestBody requestBody = RequestBody.create((MediaType)this.JSON, (String)parm);
        if (TextUtils.equals((CharSequence)url, (CharSequence)Api.netRequestSecurityLogin)) {
            ConstantUtil.clearSession();
        }
        Request request = new Request.Builder().addHeader("Cookie", this.getCharIfEmpty(ConstantUtil.getSession())).url(url).post(requestBody).build();
        final Call call = mClient.newCall(request);
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<NetResponseMessage>(){

            public void subscribe(ObservableEmitter<NetResponseMessage> e) throws Exception {
                Response response = call.execute();
                if (!response.isSuccessful()) {
                    e.onError((Throwable)new Exception());
                    return;
                }
                try {
                    String responseMessage = response.body().string();
                    Log.i((String)RequestNetUtils.TAG, (String)("OkHttp\u54cd\u5e94\u63a5\u53e3->" + url + "\u8fd4\u56de\u503c->" + responseMessage));
                    if (TextUtils.equals((CharSequence)url, (CharSequence)Api.netRequestSecurityLogin)) {
                        String session = response.headers().get("Set-Cookie");
                        ConstantUtil.setSession(session);
                    }
                    NetResponseMessage netResponseMessage = (NetResponseMessage)JSONUtils.jsonToBean((String)responseMessage, NetResponseMessage.class);
                    e.onNext((Object)netResponseMessage);
                }
                catch (Exception exception) {
                    e.onError((Throwable)exception);
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<NetResponseMessage>(){

            public void accept(NetResponseMessage netResponseMessage) throws Exception {
                if (isDismiss) {
                    LoadingUtil.clossLoadingActivity();
                }
                switch (netResponseMessage.getResultCode()) {
                    case "200": {
                        if (callBack == null) break;
                        callBack.onSucc(netResponseMessage);
                        break;
                    }
                    default: {
                        if (callBack == null) break;
                        callBack.onFail(netResponseMessage);
                    }
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                if (isDismiss) {
                    LoadingUtil.clossLoadingActivity();
                }
                Log.i((String)RequestNetUtils.TAG, (String)"\u7f51\u7edc\u8bf7\u6c42\u53ca\u6570\u636e\u5904\u7406\u5f02\u5e38\u4fe1\u606f\u4e0b\u65b9\u6253\u5370");
                throwable.printStackTrace();
                NetResponseMessage failMessage = new NetResponseMessage("-1");
                if (DeviceUtil.isNetworkConnected()) {
                    failMessage.setMessage(StringsUtils.getString((int)R.string.commbyh_shujujiazaishibai_qingshaohouzhongshi));
                } else {
                    failMessage.setMessage(StringsUtils.getString((int)R.string.commbyh_wangluolianjiecuowu));
                }
                if (callBack != null) {
                    callBack.onFail(failMessage);
                }
            }
        });
    }
}

