/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.libdata.http.utils;

import android.content.SharedPreferences;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.kangxin.util.common.byh.AppUtil;
import com.kangxin.util.common.byh.JSONUtils;
import java.lang.reflect.Type;
import java.util.Set;

public enum SpUtils {
    CACHE("userparams"),
    LASTING("LastingInfo");

    private SharedPreferences mSp;
    private SharedPreferences.Editor mEditor;

    private SpUtils(String fileName) {
        this.mSp = AppUtil.getContext().getSharedPreferences(fileName, 0);
        this.mEditor = this.mSp.edit();
    }

    public void putBoolean(String key, boolean value) {
        this.mEditor.putBoolean(key, value).commit();
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.mSp.getBoolean(key, defValue);
    }

    public void putInt(String key, int value) {
        this.mEditor.putInt(key, value).commit();
    }

    public int getInt(String key, int defValue) {
        return this.mSp.getInt(key, defValue);
    }

    public void putLong(String key, long value) {
        this.mEditor.putLong(key, value).commit();
    }

    public long getLong(String key, long defValue) {
        return this.mSp.getLong(key, defValue);
    }

    public void putFloat(String key, float value) {
        this.mEditor.putFloat(key, value).commit();
    }

    public float getFloat(String key, float defValue) {
        return this.mSp.getFloat(key, defValue);
    }

    public void putString(String key, String value) {
        this.mEditor.putString(key, value).commit();
    }

    public String getString(String key, String defValue) {
        return this.mSp.getString(key, defValue);
    }

    public void putStringSet(String key, Set<String> set) {
        this.mEditor.putStringSet(key, set).commit();
    }

    public Set<String> getStringSet(String key, Set<String> defSet) {
        return this.mSp.getStringSet(key, defSet);
    }

    public void putObject(String key, Object object) {
        this.putString(key, object == null ? "" : this.getGson().toJson(object));
    }

    public <T> T getObject(String key, Type typeOfT) {
        try {
            return (T)this.getGson().fromJson(this.getString(key, ""), typeOfT);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    public void remove(String key) {
        if (this.mSp.contains(key)) {
            this.mEditor.remove(key).commit();
        }
    }

    public void clear() {
        this.mEditor.clear().commit();
    }

    private Gson getGson() {
        return JSONUtils.getGsonInstance();
    }
}

