/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.libdata.http.utils;

import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.libdata.R;
import com.kangxin.doctor.libdata.http.bean.HospitalInfoBean;
import com.kangxin.doctor.libdata.http.bean.LoginDataBean;
import com.kangxin.doctor.libdata.http.bean.ServiceSetInfoBean;
import com.kangxin.doctor.libdata.http.bean.UserAccountInfo;
import com.kangxin.doctor.libdata.http.bean.UserInfoBean;
import com.kangxin.doctor.libdata.http.callback.ReceiveStatusInterface;
import com.kangxin.doctor.libdata.http.help.RequestHeaderBeanHelpter;
import com.kangxin.doctor.libdata.http.utils.SpUtils;
import com.kangxin.util.common.byh.JSONUtils;
import java.util.ArrayList;

public class UserInfoUtils {
    public static void saveUserInfo(LoginDataBean loginDataBean) {
        UserInfoUtils.saveUserStatus(loginDataBean.getStatus());
        UserInfoUtils.saveRegisterTime(loginDataBean.getRegisterTime());
        UserInfoUtils.saveUserType(loginDataBean.getUserType());
        UserInfoUtils.saveToken(loginDataBean.getToken());
        RequestHeaderBeanHelpter.updateToken(loginDataBean.getToken());
        UserInfoUtils.saveUserTeamUuid(loginDataBean.getTeamUuid());
        UserInfoUtils.saveUserInfo(loginDataBean.getUserInfo());
        UserInfoUtils.saveIsInviteRegister(loginDataBean.getIsInvite());
    }

    public static void saveIsInviteRegister(int isInvite) {
        SpUtils.CACHE.putBoolean("isInvite", isInvite == 1);
    }

    public static boolean isInviteRegister() {
        return SpUtils.CACHE.getBoolean("isInvite", false);
    }

    public static UserInfoBean getUserInfo() {
        UserInfoBean bean = null;
        String userinfo = SpUtils.CACHE.getString("UserInfoBean", "");
        if (!TextUtils.isEmpty((CharSequence)userinfo)) {
            bean = (UserInfoBean)JSONUtils.jsonToBean((String)userinfo, UserInfoBean.class);
        }
        return bean;
    }

    public static void saveUserInfo(UserInfoBean infoBean) {
        String str = "";
        if (infoBean != null) {
            str = JSONUtils.objectToJson((Object)infoBean);
        }
        SpUtils.CACHE.putString("UserInfoBean", str);
    }

    public static void setUserAccountInfo(UserAccountInfo accountInfo) {
        if (accountInfo != null) {
            UserInfoUtils.saveUserType(accountInfo.getUserType());
            UserInfoUtils.saveUserStatus(accountInfo.getStatus());
            UserInfoUtils.saveRegisterTime(accountInfo.getRegisterTime());
            UserInfoUtils.saveUserTeamUuid(accountInfo.getTeamUuid());
            UserInfoUtils.saveUserIdCard(accountInfo.getIdCardNo());
        }
    }

    private static void saveUserIdCard(String idCardNo) {
        SpUtils.CACHE.putString("idCardNo", idCardNo);
    }

    public static String getUserIdCard() {
        return SpUtils.CACHE.getString("idCardNo", "");
    }

    public static String getToken() {
        return SpUtils.CACHE.getString("token", "");
    }

    public static void saveToken(String mtoken) {
        SpUtils.CACHE.putString("token", mtoken);
    }

    public static void saveRegisterTime(long registerTime) {
        SpUtils.CACHE.putLong("RegisterTime", registerTime);
    }

    public static long getRegisterTime() {
        return SpUtils.CACHE.getLong("RegisterTime", 0L);
    }

    public static void saveUserType(int mStatus) {
        SpUtils.CACHE.putInt("currentUserType", mStatus);
    }

    public static int getUserType() {
        return SpUtils.CACHE.getInt("currentUserType", 3);
    }

    public static void saveUserStatus(int mStatus) {
        SpUtils.CACHE.putInt("userstatus", mStatus);
    }

    public static int getUserStatus() {
        return SpUtils.CACHE.getInt("userstatus", -1);
    }

    public static void saveUserTeamUuid(String doctorTeamUuid) {
        SpUtils.CACHE.putString("doctorTeamUuid", doctorTeamUuid);
    }

    public static String getUserTeamUuid() {
        return SpUtils.CACHE.getString("doctorTeamUuid", "");
    }

    public static void setUserProfile(String s) {
        UserInfoBean userInfo = UserInfoUtils.getUserInfo();
        if (userInfo != null) {
            userInfo.setProfile(s);
        }
        UserInfoUtils.saveUserInfo(userInfo);
    }

    public static boolean isCertified() {
        boolean flag = false;
        switch (UserInfoUtils.getUserStatus()) {
            case -1: {
                flag = false;
                break;
            }
            case -2: {
                flag = false;
                break;
            }
            case 1: {
                flag = true;
                break;
            }
            case -3: {
                flag = false;
            }
        }
        return flag;
    }

    public static void isReceiveStatus(ReceiveStatusInterface receiveStatusInterface, boolean showMessage) {
        if (UserInfoUtils.getUserType() == 2 || UserInfoUtils.getUserType() == 3 && UserInfoUtils.isCertified()) {
            receiveStatusInterface.receiveStatus();
        }
    }

    public static boolean isReceiveStatus(Context context, boolean showMessage) {
        if (UserInfoUtils.getUserType() == 2 || UserInfoUtils.getUserType() == 3 && UserInfoUtils.isCertified()) {
            return true;
        }
        if (showMessage) {
            Toast.makeText((Context)context, (CharSequence)StringsUtils.getString((int)R.string.commbyh_renzhengtongguozhihou_caikejinxingcaozuo), (int)0).show();
        }
        return false;
    }

    public static boolean isSpecialist() {
        return UserInfoUtils.getUserType() == 2;
    }

    public static String getUserName() {
        if (UserInfoUtils.getUserInfo() != null) {
            return UserInfoUtils.getUserInfo().getDisplayName();
        }
        return "";
    }

    public static String getHeadImage() {
        if (UserInfoUtils.getUserInfo() != null) {
            return UserInfoUtils.getUserInfo().getHeadImageUrl();
        }
        return "";
    }

    public static int getUserId() {
        if (UserInfoUtils.getUserInfo() != null) {
            return UserInfoUtils.getUserInfo().getId();
        }
        return -1;
    }

    public static String getQrUrl() {
        if (UserInfoUtils.getUserInfo() != null) {
            return UserInfoUtils.getUserInfo().getQrUrl();
        }
        return "";
    }

    public static ServiceSetInfoBean getServiceInfo(ArrayList<ServiceSetInfoBean> servicelist, int serviceType) {
        ServiceSetInfoBean tempBean = null;
        if (servicelist != null) {
            for (ServiceSetInfoBean bean : servicelist) {
                if (bean.getServiceType() != serviceType) continue;
                tempBean = bean;
            }
        }
        return tempBean;
    }

    public static HospitalInfoBean getHospitalInfo() {
        HospitalInfoBean bean = new HospitalInfoBean();
        if (UserInfoUtils.getUserInfo() != null && UserInfoUtils.getUserInfo().getHospitalInfo() != null) {
            bean = UserInfoUtils.getUserInfo().getHospitalInfo();
        }
        return bean;
    }

    public static void setSpeciality(String s) {
        UserInfoBean userInfo = UserInfoUtils.getUserInfo();
        if (userInfo != null) {
            userInfo.setSpeciality(s);
        }
        UserInfoUtils.saveUserInfo(userInfo);
    }
}

