/*
 * Decompiled with CFR 0.152.
 */
package com.yhaoo;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AntiHijackingUtil {
    public static final String TAG = "AntiHijackingUtil";

    public static boolean checkActivity(Context context) {
        int sdkVersion;
        PackageManager pm = context.getPackageManager();
        List listAppcations = pm.getInstalledApplications(8192);
        Collections.sort(listAppcations, new ApplicationInfo.DisplayNameComparator(pm));
        ArrayList<String> safePackages = new ArrayList<String>();
        for (ApplicationInfo app : listAppcations) {
            if ((app.flags & 1) == 0) continue;
            safePackages.add(app.packageName);
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        try {
            sdkVersion = Integer.valueOf(Build.VERSION.SDK);
        }
        catch (NumberFormatException e) {
            sdkVersion = 0;
        }
        String runningActivityPackageName = sdkVersion >= 21 ? AntiHijackingUtil.getCurrentPkgName(context) : ((ActivityManager.RunningTaskInfo)activityManager.getRunningTasks((int)1).get((int)0)).topActivity.getPackageName();
        if (runningActivityPackageName != null) {
            if (runningActivityPackageName.equals(context.getPackageName())) {
                return true;
            }
            for (String safePack : safePackages) {
                if (!safePack.equals(runningActivityPackageName)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getCurrentPkgName(Context context) {
        ActivityManager.RunningAppProcessInfo currentInfo = null;
        Field field = null;
        int START_TASK_TO_FRONT = 2;
        String pkgName = null;
        try {
            field = ActivityManager.RunningAppProcessInfo.class.getDeclaredField("processState");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List appList = am.getRunningAppProcesses();
        for (int i = 0; i < appList.size(); ++i) {
            ActivityManager.RunningAppProcessInfo app = (ActivityManager.RunningAppProcessInfo)appList.get(i);
            if (app.importance != 100) continue;
            Integer state = null;
            try {
                state = field.getInt(app);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (state == null || state != START_TASK_TO_FRONT) continue;
            currentInfo = app;
            break;
        }
        if (currentInfo != null) {
            pkgName = currentInfo.processName;
        }
        return pkgName;
    }

    public static boolean isHome(Context context) {
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        List rti = mActivityManager.getRunningTasks(1);
        return AntiHijackingUtil.getHomes(context).contains(((ActivityManager.RunningTaskInfo)rti.get((int)0)).topActivity.getPackageName());
    }

    private static List<String> getHomes(Context context) {
        ArrayList<String> names = new ArrayList<String>();
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        List resolveInfo = packageManager.queryIntentActivities(intent, 65536);
        for (ResolveInfo ri : resolveInfo) {
            names.add(ri.activityInfo.packageName);
        }
        return names;
    }

    public static boolean isReflectScreen(Context context) {
        KeyguardManager mKeyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        return mKeyguardManager.inKeyguardRestrictedInputMode();
    }
}

