/*
 * Decompiled with CFR 0.152.
 */
package com.yhaoo;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import com.alibaba.android.arouter.launcher.ARouter;
import com.kangxin.common.byh.service.IExitAppProvider;
import com.kangxin.common.byh.service.IExitAppService;
import com.kangxin.doctor.libdata.R;
import com.kangxin.doctor.worktable.dialog.CenterHintDialogSpe;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class SignCheckUtil {
    private Context context;
    private String cer = null;
    private String type = "SHA1";
    public static final String SHA1 = "SHA1";
    private String sha1RealCer = "";
    private String md5RealCer = "0232ECB81686E5FD38DA298542C464D9";
    private static final String TAG = "sign";
    private IExitAppProvider mExitAppProvider = (IExitAppProvider)ARouter.getInstance().build("/AppRouter/exit/app/ExitAppProvider").navigation();
    private IExitAppService mExitAppServiceProvider = (IExitAppService)ARouter.getInstance().build("/VerloginRouter/exitapp/ExitAppServiceImpl").navigation();

    public SignCheckUtil() {
    }

    public SignCheckUtil(Context context, String type) {
        this.context = context;
        this.type = type;
    }

    public String getCertificateSHA1Fingerprint() {
        String hexString = "";
        PackageManager pm = this.context.getPackageManager();
        String packageName = this.context.getPackageName();
        Signature[] signatures = null;
        try {
            PackageInfo packageInfo;
            if (Build.VERSION.SDK_INT > 28) {
                packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0x8000000);
                SigningInfo signingInfo = packageInfo.signingInfo;
                signatures = signingInfo.getApkContentsSigners();
            } else {
                packageInfo = pm.getPackageInfo(packageName, 64);
                signatures = packageInfo.signatures;
            }
            byte[] cert = signatures[0].toByteArray();
            ByteArrayInputStream input = new ByteArrayInputStream(cert);
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            X509Certificate c = null;
            c = (X509Certificate)cf.generateCertificate(input);
            MessageDigest md = MessageDigest.getInstance(this.type);
            byte[] publicKey = md.digest(c.getEncoded());
            hexString = this.byte2HexFormatted(publicKey);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hexString.trim();
    }

    private String byte2HexFormatted(byte[] arr) {
        StringBuilder str = new StringBuilder(arr.length * 2);
        for (int i = 0; i < arr.length; ++i) {
            String h = Integer.toHexString(arr[i]);
            int l = h.length();
            if (l == 1) {
                h = "0" + h;
            }
            if (l > 2) {
                h = h.substring(l - 2, l);
            }
            str.append(h.toUpperCase());
            if (i >= arr.length - 1) continue;
            str.append(':');
        }
        return str.toString();
    }

    public boolean check() {
        if (this.sha1RealCer != null || this.md5RealCer != null) {
            this.cer = this.getCertificateSHA1Fingerprint();
            StringBuilder stringBuilder = new StringBuilder();
            if (!TextUtils.isEmpty((CharSequence)this.cer)) {
                String[] split = this.cer.split(":");
                for (int i = 0; i < split.length; ++i) {
                    stringBuilder.append(split[i]);
                }
            }
            this.cer = stringBuilder.toString();
            if (TextUtils.equals((CharSequence)this.type, (CharSequence)SHA1) && this.cer.equalsIgnoreCase(this.sha1RealCer) || TextUtils.equals((CharSequence)this.type, (CharSequence)"MD5") && this.cer.equalsIgnoreCase(this.md5RealCer)) {
                return true;
            }
        }
        return false;
    }

    public void show(final Context context) {
        if (!this.check()) {
            CenterHintDialogSpe centerHintDialogSpe = new CenterHintDialogSpe(context).setMessage(context.getString(R.string.text_sign)).setTitle(context.getString(R.string.text_sign_content)).setRightText(context.getString(R.string.text_sign_quit)).setShowCancel(false).setTouchOutCancel(false).bindRightClick(new View.OnClickListener(){

                public void onClick(View v) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        SignCheckUtil.this.mExitAppProvider.registerExitAppReceiver();
                        SignCheckUtil.this.mExitAppProvider.sendExitAppReceiver();
                    } else {
                        Intent intent = new Intent("com.kangxin.doctor.worktable.exitapp");
                        context.sendBroadcast(intent);
                    }
                }
            });
            centerHintDialogSpe.setCanceledOnTouchOutside(false);
            centerHintDialogSpe.setCancelable(false);
            centerHintDialogSpe.show();
        }
    }

    public static boolean CheckRootPathSU() {
        File file = null;
        String[] k = new String[]{"/system/bin/", "/system/xbin/", "/system/sbin/", "/sbin/", "/vendor/bin/"};
        try {
            for (String s : k) {
                file = new File(s + "su");
                if (null == file || !file.exists()) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public void root(final Context context) {
        if (SignCheckUtil.CheckRootPathSU() || this.CheckRootPathWhichSU()) {
            CenterHintDialogSpe centerHintDialogSpe = new CenterHintDialogSpe(context).setMessage(context.getString(R.string.text_root_sign)).setTitle(context.getString(R.string.text_root_sign_content)).setRightText(context.getString(R.string.text_sign_quit)).setShowCancel(false).setTouchOutCancel(false).bindRightClick(new View.OnClickListener(){

                public void onClick(View v) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        SignCheckUtil.this.mExitAppProvider.registerExitAppReceiver();
                        SignCheckUtil.this.mExitAppProvider.sendExitAppReceiver();
                    } else {
                        Intent intent = new Intent("com.kangxin.doctor.worktable.exitapp");
                        context.sendBroadcast(intent);
                    }
                }
            });
            centerHintDialogSpe.setCanceledOnTouchOutside(false);
            centerHintDialogSpe.setCancelable(false);
            centerHintDialogSpe.show();
        }
    }

    public boolean CheckRootPathWhichSU() {
        String[] cmd = new String[]{"/system/xbin/which", "su"};
        ArrayList<String> strings = this.executeCommand(cmd);
        return strings != null && strings.size() > 0;
    }

    private ArrayList<String> executeCommand(String[] shellCmd) {
        String line = null;
        ArrayList<String> full = new ArrayList<String>();
        Process localProcess = null;
        try {
            localProcess = Runtime.getRuntime().exec(shellCmd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (localProcess == null) {
            return full;
        }
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(localProcess.getOutputStream()));
            BufferedReader read = new BufferedReader(new InputStreamReader(localProcess.getInputStream()));
            while ((line = read.readLine()) != null) {
                full.add(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return full;
    }
}

