/*
 * Decompiled with CFR 0.152.
 */
package com.yhaoo.floatwindow;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.RequiresApi;
import com.yhaoo.EventModel;
import com.yhaoo.floatwindow.PermissionListener;
import com.yhaoo.floatwindow.PermissionUtil;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class FloatActivity
extends Activity {
    private static List<PermissionListener> mPermissionListenerList;
    private static PermissionListener mPermissionListener;
    int KEY_PRE = 756232212;

    private static void onSuccessListener(PermissionListener permissionListener) {
        if (permissionListener != null) {
            permissionListener.onSuccess();
        }
    }

    private static void onFailListener(PermissionListener permissionListener) {
        if (permissionListener != null) {
            permissionListener.onFail();
        }
    }

    static synchronized void request(Context context, PermissionListener permissionListener) {
        if (PermissionUtil.hasPermission(context)) {
            FloatActivity.onSuccessListener(permissionListener);
            return;
        }
        if (mPermissionListenerList == null) {
            mPermissionListenerList = new ArrayList<PermissionListener>();
            mPermissionListener = new PermissionListener(){

                @Override
                public void onSuccess() {
                    for (PermissionListener listener : mPermissionListenerList) {
                        FloatActivity.onSuccessListener(listener);
                    }
                    mPermissionListenerList.clear();
                }

                @Override
                public void onFail() {
                    for (PermissionListener listener : mPermissionListenerList) {
                        FloatActivity.onFailListener(listener);
                    }
                    mPermissionListenerList.clear();
                }
            };
            Intent intent = new Intent(context, FloatActivity.class);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
        mPermissionListenerList.add(permissionListener);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestAlertWindowPermission();
        }
    }

    @RequiresApi(api=23)
    private void requestAlertWindowPermission() {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivityForResult(intent, this.KEY_PRE);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.KEY_PRE == requestCode) {
            if (PermissionUtil.hasPermissionOnActivityResult((Context)this)) {
                FloatActivity.onSuccessListener(mPermissionListener);
                EventModel eventModel = new EventModel();
                eventModel.setWhta(3333);
                eventModel.setMsg("3333");
                EventBus.getDefault().post((Object)eventModel);
            } else {
                FloatActivity.onFailListener(mPermissionListener);
                EventModel eventModel = new EventModel();
                eventModel.setWhta(3332);
                eventModel.setMsg("3332");
                EventBus.getDefault().post((Object)eventModel);
            }
        }
        this.finish();
    }
}

