/*
 * Decompiled with CFR 0.152.
 */
package com.yhaoo.floatwindow;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.yhaoo.floatwindow.FloatLifecycle;
import com.yhaoo.floatwindow.LogUtil;
import com.yhaoo.floatwindow.PermissionListener;
import com.yhaoo.floatwindow.PermissionUtil;
import com.yhaoo.floatwindow.ResumedListener;
import com.yhaoo.floatwindow.Rom;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

class Miui {
    private static final String miui = "ro.miui.ui.version.name";
    private static final String miui5 = "V5";
    private static final String miui6 = "V6";
    private static final String miui7 = "V7";
    private static final String miui8 = "V8";
    private static final String miui9 = "V9";
    private static List<PermissionListener> mPermissionListenerList;
    private static PermissionListener mPermissionListener;

    Miui() {
    }

    static boolean rom() {
        LogUtil.d(" Miui  : " + Miui.getProp());
        return Build.MANUFACTURER.equals("Xiaomi");
    }

    private static String getProp() {
        return Rom.getProp(miui);
    }

    static void req(Context context, PermissionListener permissionListener) {
        if (PermissionUtil.hasPermission(context)) {
            permissionListener.onSuccess();
            return;
        }
        if (mPermissionListenerList == null) {
            mPermissionListenerList = new ArrayList<PermissionListener>();
            mPermissionListener = new PermissionListener(){

                @Override
                public void onSuccess() {
                    for (PermissionListener listener : mPermissionListenerList) {
                        listener.onSuccess();
                    }
                    mPermissionListenerList.clear();
                }

                @Override
                public void onFail() {
                    for (PermissionListener listener : mPermissionListenerList) {
                        listener.onFail();
                    }
                    mPermissionListenerList.clear();
                }
            };
            Miui.req_(context);
        }
        mPermissionListenerList.add(permissionListener);
    }

    private static void req_(final Context context) {
        switch (Miui.getProp()) {
            case "V5": {
                Miui.reqForMiui5(context);
                break;
            }
            case "V6": 
            case "V7": {
                Miui.reqForMiui67(context);
                break;
            }
            case "V8": 
            case "V9": {
                Miui.reqForMiui89(context);
            }
        }
        FloatLifecycle.setResumedListener(new ResumedListener(){

            @Override
            public void onResumed() {
                if (PermissionUtil.hasPermission(context)) {
                    mPermissionListener.onSuccess();
                } else {
                    mPermissionListener.onFail();
                }
            }
        });
    }

    private static void reqForMiui5(Context context) {
        String packageName = context.getPackageName();
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)packageName, null);
        intent.setData(uri);
        intent.setFlags(0x10000000);
        if (Rom.isIntentAvailable(intent, context)) {
            context.startActivity(intent);
        } else {
            LogUtil.e("intent is not available!");
        }
    }

    private static void reqForMiui67(Context context) {
        Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
        intent.putExtra("extra_pkgname", context.getPackageName());
        intent.setFlags(0x10000000);
        if (Rom.isIntentAvailable(intent, context)) {
            context.startActivity(intent);
        } else {
            LogUtil.e("intent is not available!");
        }
    }

    private static void reqForMiui89(Context context) {
        Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
        intent.putExtra("extra_pkgname", context.getPackageName());
        intent.setFlags(0x10000000);
        if (Rom.isIntentAvailable(intent, context)) {
            context.startActivity(intent);
        } else {
            intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
            intent.setPackage("com.miui.securitycenter");
            intent.putExtra("extra_pkgname", context.getPackageName());
            intent.setFlags(0x10000000);
            if (Rom.isIntentAvailable(intent, context)) {
                context.startActivity(intent);
            } else {
                LogUtil.e("intent is not available!");
            }
        }
    }

    private static void addViewToWindow(WindowManager wm, View view, WindowManager.LayoutParams params) {
        Miui.setMiUI_International(true);
        wm.addView(view, (ViewGroup.LayoutParams)params);
        Miui.setMiUI_International(false);
    }

    private static void setMiUI_International(boolean flag) {
        try {
            Class<?> BuildForMi = Class.forName("miui.os.Build");
            Field isInternational = BuildForMi.getDeclaredField("IS_INTERNATIONAL_BUILD");
            isInternational.setAccessible(true);
            isInternational.setBoolean(null, flag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

