/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.mns;

import android.content.Context;
import com.alibaba.sdk.android.common.ClientConfiguration;
import com.alibaba.sdk.android.common.ClientException;
import com.alibaba.sdk.android.common.ServiceException;
import com.alibaba.sdk.android.common.auth.CredentialProvider;
import com.alibaba.sdk.android.mns.MNS;
import com.alibaba.sdk.android.mns.callback.MNSCompletedCallback;
import com.alibaba.sdk.android.mns.internal.MNSAsyncTask;
import com.alibaba.sdk.android.mns.internal.MNSInternalRequestOperation;
import com.alibaba.sdk.android.mns.model.request.ChangeMessageVisibilityRequest;
import com.alibaba.sdk.android.mns.model.request.CreateQueueRequest;
import com.alibaba.sdk.android.mns.model.request.DeleteMessageRequest;
import com.alibaba.sdk.android.mns.model.request.DeleteQueueRequest;
import com.alibaba.sdk.android.mns.model.request.GetQueueAttributesRequest;
import com.alibaba.sdk.android.mns.model.request.ListQueueRequest;
import com.alibaba.sdk.android.mns.model.request.PeekMessageRequest;
import com.alibaba.sdk.android.mns.model.request.ReceiveMessageRequest;
import com.alibaba.sdk.android.mns.model.request.SendMessageRequest;
import com.alibaba.sdk.android.mns.model.request.SetQueueAttributesRequest;
import com.alibaba.sdk.android.mns.model.result.ChangeMessageVisibilityResult;
import com.alibaba.sdk.android.mns.model.result.CreateQueueResult;
import com.alibaba.sdk.android.mns.model.result.DeleteMessageResult;
import com.alibaba.sdk.android.mns.model.result.DeleteQueueResult;
import com.alibaba.sdk.android.mns.model.result.GetQueueAttributesResult;
import com.alibaba.sdk.android.mns.model.result.ListQueueResult;
import com.alibaba.sdk.android.mns.model.result.PeekMessageResult;
import com.alibaba.sdk.android.mns.model.result.ReceiveMessageResult;
import com.alibaba.sdk.android.mns.model.result.SendMessageResult;
import com.alibaba.sdk.android.mns.model.result.SetQueueAttributesResult;
import java.net.URI;
import java.net.URISyntaxException;

public class MNSClient
implements MNS {
    private URI endpointURI;
    private CredentialProvider credentialProvider;
    private MNSInternalRequestOperation internalRequestOperation;
    private ClientConfiguration conf;

    public MNSClient(Context context, String endpoint, CredentialProvider credentialProvider) {
        this(context, endpoint, credentialProvider, null);
    }

    public MNSClient(Context context, String endpoint, CredentialProvider credentialProvider, ClientConfiguration conf) {
        try {
            endpoint = endpoint.trim();
            if (!endpoint.startsWith("http")) {
                endpoint = "http://" + endpoint;
            }
            this.endpointURI = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Endpoint must be a string like 'http://mns.cn-****.aliyuncs.com'!");
        }
        if (credentialProvider == null) {
            throw new IllegalArgumentException("CredentialProvider can't be null.");
        }
        this.credentialProvider = credentialProvider;
        this.conf = conf == null ? ClientConfiguration.getDefaultConf() : conf;
        this.internalRequestOperation = new MNSInternalRequestOperation(context, this.endpointURI, credentialProvider, this.conf);
    }

    @Override
    public MNSAsyncTask<CreateQueueResult> asyncCreateQueue(CreateQueueRequest request, MNSCompletedCallback<CreateQueueRequest, CreateQueueResult> completedCallback) {
        return this.internalRequestOperation.createQueue(request, completedCallback);
    }

    @Override
    public CreateQueueResult createQueue(CreateQueueRequest request) throws ClientException, ServiceException {
        return this.internalRequestOperation.createQueue(request, null).getResult();
    }

    @Override
    public MNSAsyncTask<DeleteQueueResult> asyncDeleteQueue(DeleteQueueRequest request, MNSCompletedCallback<DeleteQueueRequest, DeleteQueueResult> completedCallback) {
        return this.internalRequestOperation.deleteQueue(request, completedCallback);
    }

    @Override
    public DeleteQueueResult deleteQueue(DeleteQueueRequest request) throws ClientException, ServiceException {
        return this.internalRequestOperation.deleteQueue(request, null).getResult();
    }

    @Override
    public MNSAsyncTask<SetQueueAttributesResult> asyncSetQueueAttributes(SetQueueAttributesRequest request, MNSCompletedCallback<SetQueueAttributesRequest, SetQueueAttributesResult> completedCallback) {
        return this.internalRequestOperation.setQueueAttr(request, completedCallback);
    }

    @Override
    public SetQueueAttributesResult setQueueAttributes(SetQueueAttributesRequest request) throws ClientException, ServiceException {
        return this.internalRequestOperation.setQueueAttr(request, null).getResult();
    }

    @Override
    public MNSAsyncTask<GetQueueAttributesResult> asyncGetQueueAttributes(GetQueueAttributesRequest request, MNSCompletedCallback<GetQueueAttributesRequest, GetQueueAttributesResult> completedCallback) {
        return this.internalRequestOperation.getQueueAttr(request, completedCallback);
    }

    @Override
    public GetQueueAttributesResult getQueueAttributes(GetQueueAttributesRequest request) throws ClientException, ServiceException {
        return this.internalRequestOperation.getQueueAttr(request, null).getResult();
    }

    @Override
    public MNSAsyncTask<ListQueueResult> asyncListQueue(ListQueueRequest request, MNSCompletedCallback<ListQueueRequest, ListQueueResult> completedCallback) {
        return this.internalRequestOperation.listQueue(request, completedCallback);
    }

    @Override
    public ListQueueResult listQueue(ListQueueRequest request) throws ClientException, ServiceException {
        return this.internalRequestOperation.listQueue(request, null).getResult();
    }

    @Override
    public MNSAsyncTask<SendMessageResult> asyncSendMessage(SendMessageRequest request, MNSCompletedCallback<SendMessageRequest, SendMessageResult> completedCallback) {
        return this.internalRequestOperation.sendMessage(request, completedCallback);
    }

    @Override
    public SendMessageResult sendMessage(SendMessageRequest request) throws ClientException, ServiceException {
        return this.internalRequestOperation.sendMessage(request, null).getResult();
    }

    @Override
    public MNSAsyncTask<ReceiveMessageResult> asyncReceiveMessage(ReceiveMessageRequest request, MNSCompletedCallback<ReceiveMessageRequest, ReceiveMessageResult> completedCallback) {
        return this.internalRequestOperation.receiveMessage(request, completedCallback);
    }

    @Override
    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest request) throws ClientException, ServiceException {
        return this.internalRequestOperation.receiveMessage(request, null).getResult();
    }

    @Override
    public MNSAsyncTask<DeleteMessageResult> asyncDeleteMessage(DeleteMessageRequest request, MNSCompletedCallback<DeleteMessageRequest, DeleteMessageResult> completedCallback) {
        return this.internalRequestOperation.deleteMessage(request, completedCallback);
    }

    @Override
    public DeleteMessageResult deleteMessage(DeleteMessageRequest request) throws ClientException, ServiceException {
        return this.internalRequestOperation.deleteMessage(request, null).getResult();
    }

    @Override
    public MNSAsyncTask<PeekMessageResult> asyncPeekMessage(PeekMessageRequest request, MNSCompletedCallback<PeekMessageRequest, PeekMessageResult> completedCallback) {
        return this.internalRequestOperation.peekMessage(request, completedCallback);
    }

    @Override
    public PeekMessageResult peekMessage(PeekMessageRequest request) throws ClientException, ServiceException {
        return this.internalRequestOperation.peekMessage(request, null).getResult();
    }

    @Override
    public MNSAsyncTask<ChangeMessageVisibilityResult> asyncChangeMessageVisibility(ChangeMessageVisibilityRequest request, MNSCompletedCallback<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> completedCallback) {
        return this.internalRequestOperation.changeMessageVisibility(request, completedCallback);
    }

    @Override
    public ChangeMessageVisibilityResult changeMessageVisibility(ChangeMessageVisibilityRequest request) throws ClientException, ServiceException {
        return this.internalRequestOperation.changeMessageVisibility(request, null).getResult();
    }
}

