/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.mns.internal;

import com.alibaba.sdk.android.common.ClientException;
import com.alibaba.sdk.android.common.ServiceException;
import com.alibaba.sdk.android.mns.model.MNSResult;
import com.alibaba.sdk.android.mns.network.ExecutionContext;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class MNSAsyncTask<T extends MNSResult> {
    private Future<T> future;
    private ExecutionContext context;
    private volatile boolean canceled;

    public void cancel() {
        this.canceled = true;
        if (this.context != null) {
            this.context.getCancellationHandler().cancel();
        }
    }

    public boolean isCompleted() {
        return this.future.isDone();
    }

    public T getResult() throws ClientException, ServiceException {
        try {
            MNSResult result = (MNSResult)this.future.get();
            return (T)result;
        }
        catch (InterruptedException e) {
            throw new ClientException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClientException) {
                throw (ClientException)cause;
            }
            if (cause instanceof ServiceException) {
                throw (ServiceException)cause;
            }
            cause.printStackTrace();
            throw new ClientException("Unexpected exception!" + cause.getMessage());
        }
    }

    public static MNSAsyncTask wrapRequestTask(Future future, ExecutionContext context) {
        MNSAsyncTask asynTask = new MNSAsyncTask();
        asynTask.future = future;
        asynTask.context = context;
        return asynTask;
    }

    public void waitUntilFinished() {
        try {
            this.future.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

