/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.mns.internal;

import android.content.Context;
import android.net.Proxy;
import android.os.Build;
import com.alibaba.sdk.android.common.ClientConfiguration;
import com.alibaba.sdk.android.common.HttpMethod;
import com.alibaba.sdk.android.common.auth.CredentialProvider;
import com.alibaba.sdk.android.common.utils.DateUtil;
import com.alibaba.sdk.android.mns.callback.MNSCompletedCallback;
import com.alibaba.sdk.android.mns.common.MNSConstants;
import com.alibaba.sdk.android.mns.internal.MNSAsyncTask;
import com.alibaba.sdk.android.mns.internal.RequestMessage;
import com.alibaba.sdk.android.mns.internal.ResponseParsers;
import com.alibaba.sdk.android.mns.model.request.ChangeMessageVisibilityRequest;
import com.alibaba.sdk.android.mns.model.request.CreateQueueRequest;
import com.alibaba.sdk.android.mns.model.request.DeleteMessageRequest;
import com.alibaba.sdk.android.mns.model.request.DeleteQueueRequest;
import com.alibaba.sdk.android.mns.model.request.GetQueueAttributesRequest;
import com.alibaba.sdk.android.mns.model.request.ListQueueRequest;
import com.alibaba.sdk.android.mns.model.request.PeekMessageRequest;
import com.alibaba.sdk.android.mns.model.request.ReceiveMessageRequest;
import com.alibaba.sdk.android.mns.model.request.SendMessageRequest;
import com.alibaba.sdk.android.mns.model.request.SetQueueAttributesRequest;
import com.alibaba.sdk.android.mns.model.result.ChangeMessageVisibilityResult;
import com.alibaba.sdk.android.mns.model.result.CreateQueueResult;
import com.alibaba.sdk.android.mns.model.result.DeleteMessageResult;
import com.alibaba.sdk.android.mns.model.result.DeleteQueueResult;
import com.alibaba.sdk.android.mns.model.result.GetQueueAttributesResult;
import com.alibaba.sdk.android.mns.model.result.ListQueueResult;
import com.alibaba.sdk.android.mns.model.result.PeekMessageResult;
import com.alibaba.sdk.android.mns.model.result.ReceiveMessageResult;
import com.alibaba.sdk.android.mns.model.result.SendMessageResult;
import com.alibaba.sdk.android.mns.model.result.SetQueueAttributesResult;
import com.alibaba.sdk.android.mns.model.serialize.MessageSerializer;
import com.alibaba.sdk.android.mns.model.serialize.QueueMetaSerializer;
import com.alibaba.sdk.android.mns.network.ExecutionContext;
import com.alibaba.sdk.android.mns.network.MNSRequestTask;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public class MNSInternalRequestOperation {
    private volatile URI endpoint;
    private OkHttpClient innerClient;
    private Context applicationContext;
    private CredentialProvider credentialProvider;
    private int maxRetryCount = 2;
    private ClientConfiguration conf;
    private static ExecutorService executorService = Executors.newFixedThreadPool(5);

    private MNSInternalRequestOperation() {
    }

    public MNSInternalRequestOperation(Context context, final URI endpoint, CredentialProvider credentialProvider, ClientConfiguration conf) {
        this.applicationContext = context;
        this.endpoint = endpoint;
        this.credentialProvider = credentialProvider;
        this.conf = conf;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().followRedirects(false).followSslRedirects(false).retryOnConnectionFailure(false).cache(null).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return HttpsURLConnection.getDefaultHostnameVerifier().verify(endpoint.getHost(), session);
            }
        });
        if (conf != null) {
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(conf.getMaxConcurrentRequest());
            builder.connectTimeout((long)conf.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)conf.getSocketTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)conf.getSocketTimeout(), TimeUnit.MILLISECONDS).dispatcher(dispatcher);
            this.maxRetryCount = conf.getMaxErrorRetry();
        }
        this.innerClient = builder.build();
    }

    public MNSAsyncTask<CreateQueueResult> createQueue(CreateQueueRequest request, MNSCompletedCallback<CreateQueueRequest, CreateQueueResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(requestMessage.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setQueueName(request.getQueueName());
        requestMessage.setType(MNSConstants.MNSType.QUEUE);
        QueueMetaSerializer serializer = new QueueMetaSerializer();
        try {
            String str = serializer.serialize(request.getQueueMeta(), "utf-8");
            requestMessage.setContent(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        this.addRequiredHeader(requestMessage);
        ExecutionContext<CreateQueueRequest> executionContext = new ExecutionContext<CreateQueueRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.CreateQueueResponseParser parser = new ResponseParsers.CreateQueueResponseParser();
        MNSRequestTask callable = new MNSRequestTask(requestMessage, parser, executionContext);
        return MNSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public MNSAsyncTask<DeleteQueueResult> deleteQueue(DeleteQueueRequest request, MNSCompletedCallback<DeleteQueueRequest, DeleteQueueResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(requestMessage.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setQueueName(request.getQueueName());
        requestMessage.setType(MNSConstants.MNSType.QUEUE);
        this.addRequiredHeader(requestMessage);
        ExecutionContext<DeleteQueueRequest> executionContext = new ExecutionContext<DeleteQueueRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteQueueResponseParser parser = new ResponseParsers.DeleteQueueResponseParser();
        MNSRequestTask callable = new MNSRequestTask(requestMessage, parser, executionContext);
        return MNSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public MNSAsyncTask<SetQueueAttributesResult> setQueueAttr(SetQueueAttributesRequest request, MNSCompletedCallback<SetQueueAttributesRequest, SetQueueAttributesResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(requestMessage.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setQueueName(request.getQueueName());
        requestMessage.getParameters().put("metaoverride", "true");
        requestMessage.setType(MNSConstants.MNSType.QUEUE);
        QueueMetaSerializer serializer = new QueueMetaSerializer();
        try {
            String str = serializer.serialize(request.getQueueMeta(), "utf-8");
            requestMessage.setContent(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        this.addRequiredHeader(requestMessage);
        ExecutionContext<SetQueueAttributesRequest> executionContext = new ExecutionContext<SetQueueAttributesRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.CreateQueueResponseParser parser = new ResponseParsers.CreateQueueResponseParser();
        MNSRequestTask callable = new MNSRequestTask(requestMessage, parser, executionContext);
        return MNSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public MNSAsyncTask<GetQueueAttributesResult> getQueueAttr(GetQueueAttributesRequest request, MNSCompletedCallback<GetQueueAttributesRequest, GetQueueAttributesResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(requestMessage.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setQueueName(request.getQueueName());
        requestMessage.setType(MNSConstants.MNSType.QUEUE);
        this.addRequiredHeader(requestMessage);
        ExecutionContext<GetQueueAttributesRequest> executionContext = new ExecutionContext<GetQueueAttributesRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetQueueAttributesResponseParser parser = new ResponseParsers.GetQueueAttributesResponseParser();
        MNSRequestTask callable = new MNSRequestTask(requestMessage, parser, executionContext);
        return MNSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public MNSAsyncTask<ListQueueResult> listQueue(ListQueueRequest request, MNSCompletedCallback<ListQueueRequest, ListQueueResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(requestMessage.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setType(MNSConstants.MNSType.QUEUE);
        if (!request.getPrefix().isEmpty()) {
            requestMessage.getHeaders().put("x-mns-", request.getPrefix());
        }
        if (!request.getMarker().isEmpty()) {
            requestMessage.getHeaders().put("x-mns-marker", request.getMarker());
        }
        requestMessage.getHeaders().put("x-mns-ret-number", request.getRetNum().toString());
        this.addRequiredHeader(requestMessage);
        ExecutionContext<ListQueueRequest> executionContext = new ExecutionContext<ListQueueRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ListQueueResponseParser parser = new ResponseParsers.ListQueueResponseParser();
        MNSRequestTask callable = new MNSRequestTask(requestMessage, parser, executionContext);
        return MNSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public MNSAsyncTask<SendMessageResult> sendMessage(SendMessageRequest request, MNSCompletedCallback<SendMessageRequest, SendMessageResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(requestMessage.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setQueueName(request.getQueueName());
        requestMessage.setType(MNSConstants.MNSType.MESSAGE);
        MessageSerializer serializer = new MessageSerializer();
        try {
            String str = serializer.serialize(request.getMessage(), "utf-8");
            requestMessage.setContent(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        this.addRequiredHeader(requestMessage);
        ExecutionContext<SendMessageRequest> executionContext = new ExecutionContext<SendMessageRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.SendMessageResponseParser parser = new ResponseParsers.SendMessageResponseParser();
        MNSRequestTask callable = new MNSRequestTask(requestMessage, parser, executionContext);
        return MNSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public MNSAsyncTask<ReceiveMessageResult> receiveMessage(ReceiveMessageRequest request, MNSCompletedCallback<ReceiveMessageRequest, ReceiveMessageResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(requestMessage.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setQueueName(request.getQueueName());
        requestMessage.setType(MNSConstants.MNSType.MESSAGE);
        this.addRequiredHeader(requestMessage);
        ExecutionContext<ReceiveMessageRequest> executionContext = new ExecutionContext<ReceiveMessageRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ReceiveMessageParser parser = new ResponseParsers.ReceiveMessageParser();
        MNSRequestTask callable = new MNSRequestTask(requestMessage, parser, executionContext);
        return MNSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public MNSAsyncTask<DeleteMessageResult> deleteMessage(DeleteMessageRequest request, MNSCompletedCallback<DeleteMessageRequest, DeleteMessageResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(requestMessage.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setQueueName(request.getQueueName());
        requestMessage.setType(MNSConstants.MNSType.MESSAGE);
        requestMessage.getParameters().put("ReceiptHandle", request.getReceiptHandle());
        this.addRequiredHeader(requestMessage);
        ExecutionContext<DeleteMessageRequest> executionContext = new ExecutionContext<DeleteMessageRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteMessageParser parser = new ResponseParsers.DeleteMessageParser();
        MNSRequestTask callable = new MNSRequestTask(requestMessage, parser, executionContext);
        return MNSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public MNSAsyncTask<PeekMessageResult> peekMessage(PeekMessageRequest request, MNSCompletedCallback<PeekMessageRequest, PeekMessageResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(requestMessage.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setQueueName(request.getQueueName());
        requestMessage.setType(MNSConstants.MNSType.MESSAGE);
        requestMessage.getParameters().put("peekonly", "true");
        this.addRequiredHeader(requestMessage);
        ExecutionContext<PeekMessageRequest> executionContext = new ExecutionContext<PeekMessageRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.PeekMessageParser parser = new ResponseParsers.PeekMessageParser();
        MNSRequestTask callable = new MNSRequestTask(requestMessage, parser, executionContext);
        return MNSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public MNSAsyncTask<ChangeMessageVisibilityResult> changeMessageVisibility(ChangeMessageVisibilityRequest request, MNSCompletedCallback<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(requestMessage.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setQueueName(request.getQueueName());
        requestMessage.setType(MNSConstants.MNSType.MESSAGE);
        requestMessage.getParameters().put("ReceiptHandle", request.getReceiptHandle());
        requestMessage.getParameters().put("VisibilityTimeout", request.getVisibleTime().toString());
        this.addRequiredHeader(requestMessage);
        ExecutionContext<ChangeMessageVisibilityRequest> executionContext = new ExecutionContext<ChangeMessageVisibilityRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ChangeMessageVisibilityParser parser = new ResponseParsers.ChangeMessageVisibilityParser();
        MNSRequestTask callable = new MNSRequestTask(requestMessage, parser, executionContext);
        return MNSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    private boolean checkIfHttpdnsAwailable() {
        if (this.applicationContext == null) {
            return false;
        }
        boolean IS_ICS_OR_LATER = Build.VERSION.SDK_INT >= 14;
        String proxyHost = IS_ICS_OR_LATER ? System.getProperty("http.proxyHost") : Proxy.getHost((Context)this.applicationContext);
        return proxyHost == null;
    }

    public OkHttpClient getInnerClient() {
        return this.innerClient;
    }

    private void addRequiredHeader(RequestMessage message) {
        Map<String, String> header = message.getHeaders();
        if (header.get("Date") == null) {
            header.put("Date", DateUtil.currentFixedSkewedTimeInRFC822Format());
        }
        if (header.get("Content-Type") == null) {
            header.put("Content-Type", "text/xml;charset=UTF-8");
        }
        header.put("x-mns-version", "2015-06-06");
        message.setCredentialProvider(this.credentialProvider);
    }

    public void setCredentialProvider(CredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }
}

