/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.mns.internal;

import com.alibaba.sdk.android.common.HttpMethod;
import com.alibaba.sdk.android.common.auth.CredentialProvider;
import com.alibaba.sdk.android.common.utils.HttpdnsMini;
import com.alibaba.sdk.android.mns.common.MNSConstants;
import com.alibaba.sdk.android.mns.common.MNSLog;
import com.alibaba.sdk.android.mns.common.MNSUtils;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class RequestMessage {
    private URI endpoint;
    private String queueName;
    private HttpMethod method;
    private boolean isAuthorizationRequired = true;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private String content;
    private long contentLength;
    private String resourcePath;
    private MNSConstants.MNSType type;
    private CredentialProvider credentialProvider;
    private boolean isHttpdnsEnable = true;

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public CredentialProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    public void setCredentialProvider(CredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isHttpdnsEnable() {
        return this.isHttpdnsEnable;
    }

    public void setIsHttpdnsEnable(boolean isHttpdnsEnable) {
        this.isHttpdnsEnable = isHttpdnsEnable;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        if (headers != null) {
            this.headers = headers;
        }
    }

    public void addHeaders(Map<String, String> headers) {
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    public boolean isAuthorizationRequired() {
        return this.isAuthorizationRequired;
    }

    public void setIsAuthorizationRequired(boolean isAuthorizationRequired) {
        this.isAuthorizationRequired = isAuthorizationRequired;
    }

    public String buildCanonicalURL() {
        MNSUtils.assertTrue(this.endpoint != null, "Endpoint haven't been set!");
        String scheme = this.endpoint.getScheme();
        String originHost = this.endpoint.getHost();
        String urlHost = null;
        if (this.isHttpdnsEnable) {
            urlHost = HttpdnsMini.getInstance().getIpByHostAsync(originHost);
        } else {
            MNSLog.logD("[buildCannonicalURL] - proxy exist, disable httpdns");
        }
        if (urlHost == null) {
            urlHost = originHost;
        }
        String headerHost = originHost;
        this.headers.put("Host", headerHost);
        String baseURL = scheme + "://" + urlHost;
        switch (this.type) {
            case QUEUE: {
                if (this.queueName != null) {
                    baseURL = baseURL + "/queues/" + this.queueName;
                    this.resourcePath = "/queues/" + this.queueName;
                    break;
                }
                baseURL = baseURL + "/queues";
                this.resourcePath = "/queues";
                break;
            }
            case MESSAGE: {
                baseURL = baseURL + "/queues/" + this.queueName + "/messages";
                this.resourcePath = "/queues/" + this.queueName + "/messages";
                break;
            }
        }
        String queryString = MNSUtils.paramToQueryString(this.parameters, "utf-8");
        if (MNSUtils.isEmptyString(queryString)) {
            return baseURL;
        }
        this.resourcePath = this.resourcePath + "?" + queryString;
        return baseURL + "?" + queryString;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) throws IOException {
        this.content = content;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setType(MNSConstants.MNSType type) {
        this.type = type;
    }

    public MNSConstants.MNSType getType() {
        return this.type;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }
}

