/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.mns.internal;

import com.alibaba.sdk.android.common.ServiceException;
import com.alibaba.sdk.android.mns.internal.ResponseParser;
import com.alibaba.sdk.android.mns.model.PagingListResult;
import com.alibaba.sdk.android.mns.model.deserialize.ChangeVisibilityDeserializer;
import com.alibaba.sdk.android.mns.model.deserialize.ErrorMessageListDeserializer;
import com.alibaba.sdk.android.mns.model.deserialize.MessageDeserializer;
import com.alibaba.sdk.android.mns.model.deserialize.QueueArrayDeserializer;
import com.alibaba.sdk.android.mns.model.deserialize.QueueMetaDeserializer;
import com.alibaba.sdk.android.mns.model.result.ChangeMessageVisibilityResult;
import com.alibaba.sdk.android.mns.model.result.CreateQueueResult;
import com.alibaba.sdk.android.mns.model.result.DeleteMessageResult;
import com.alibaba.sdk.android.mns.model.result.DeleteQueueResult;
import com.alibaba.sdk.android.mns.model.result.GetQueueAttributesResult;
import com.alibaba.sdk.android.mns.model.result.ListQueueResult;
import com.alibaba.sdk.android.mns.model.result.PeekMessageResult;
import com.alibaba.sdk.android.mns.model.result.ReceiveMessageResult;
import com.alibaba.sdk.android.mns.model.result.SendMessageResult;
import com.alibaba.sdk.android.mns.model.result.SetQueueAttributesResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Response;

public class ResponseParsers {
    public static Map<String, String> parseResponseHeader(Response response) {
        HashMap<String, String> result = new HashMap<String, String>();
        Headers headers = response.headers();
        for (int i = 0; i < headers.size(); ++i) {
            result.put(headers.name(i), headers.value(i));
        }
        return result;
    }

    public static void safeCloseResponse(Response response) {
        try {
            response.body().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ServiceException parseResponseErrorXML(Response response) throws IOException {
        try {
            ErrorMessageListDeserializer deserializer = new ErrorMessageListDeserializer();
            ServiceException serviceException = deserializer.deserialize(response);
            return serviceException;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            ResponseParsers.safeCloseResponse(response);
        }
    }

    public static final class PeekMessageParser
    implements ResponseParser<PeekMessageResult> {
        @Override
        public PeekMessageResult parse(Response response) throws IOException {
            try {
                PeekMessageResult result = new PeekMessageResult();
                result.setRequestId(response.header("x-mns-request-id"));
                result.setStatusCode(response.code());
                result.setResponseHeader(ResponseParsers.parseResponseHeader(response));
                MessageDeserializer deserializer = new MessageDeserializer();
                result.setMessage(deserializer.deserialize(response));
                PeekMessageResult peekMessageResult = result;
                return peekMessageResult;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                ResponseParsers.safeCloseResponse(response);
            }
        }
    }

    public static final class ChangeMessageVisibilityParser
    implements ResponseParser<ChangeMessageVisibilityResult> {
        @Override
        public ChangeMessageVisibilityResult parse(Response response) throws IOException {
            try {
                ChangeMessageVisibilityResult result = new ChangeMessageVisibilityResult();
                result.setRequestId(response.header("x-mns-request-id"));
                result.setStatusCode(response.code());
                result.setResponseHeader(ResponseParsers.parseResponseHeader(response));
                ChangeVisibilityDeserializer deserializer = new ChangeVisibilityDeserializer();
                result.setChangeVisibleResponse(deserializer.deserialize(response));
                ChangeMessageVisibilityResult changeMessageVisibilityResult = result;
                return changeMessageVisibilityResult;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                ResponseParsers.safeCloseResponse(response);
            }
        }
    }

    public static final class DeleteMessageParser
    implements ResponseParser<DeleteMessageResult> {
        @Override
        public DeleteMessageResult parse(Response response) throws IOException {
            try {
                DeleteMessageResult result = new DeleteMessageResult();
                result.setRequestId(response.header("x-mns-request-id"));
                result.setStatusCode(response.code());
                result.setResponseHeader(ResponseParsers.parseResponseHeader(response));
                DeleteMessageResult deleteMessageResult = result;
                return deleteMessageResult;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                ResponseParsers.safeCloseResponse(response);
            }
        }
    }

    public static final class ReceiveMessageParser
    implements ResponseParser<ReceiveMessageResult> {
        @Override
        public ReceiveMessageResult parse(Response response) throws IOException {
            try {
                ReceiveMessageResult result = new ReceiveMessageResult();
                result.setRequestId(response.header("x-mns-request-id"));
                result.setStatusCode(response.code());
                result.setResponseHeader(ResponseParsers.parseResponseHeader(response));
                MessageDeserializer deserializer = new MessageDeserializer();
                result.setMessage(deserializer.deserialize(response));
                ReceiveMessageResult receiveMessageResult = result;
                return receiveMessageResult;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                ResponseParsers.safeCloseResponse(response);
            }
        }
    }

    public static final class SendMessageResponseParser
    implements ResponseParser<SendMessageResult> {
        @Override
        public SendMessageResult parse(Response response) throws IOException {
            try {
                SendMessageResult result = new SendMessageResult();
                result.setRequestId(response.header("x-mns-request-id"));
                result.setStatusCode(response.code());
                result.setResponseHeader(ResponseParsers.parseResponseHeader(response));
                MessageDeserializer deserializer = new MessageDeserializer();
                result.setMessageResponse(deserializer.deserialize(response));
                SendMessageResult sendMessageResult = result;
                return sendMessageResult;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                ResponseParsers.safeCloseResponse(response);
            }
        }
    }

    public static final class ListQueueResponseParser
    implements ResponseParser<ListQueueResult> {
        @Override
        public ListQueueResult parse(Response response) throws IOException {
            try {
                ListQueueResult result = new ListQueueResult();
                result.setRequestId(response.header("x-mns-request-id"));
                result.setStatusCode(response.code());
                result.setResponseHeader(ResponseParsers.parseResponseHeader(response));
                QueueArrayDeserializer deserializer = new QueueArrayDeserializer();
                result.setQueueLists((PagingListResult<String>)deserializer.deserialize(response));
                ListQueueResult listQueueResult = result;
                return listQueueResult;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                ResponseParsers.safeCloseResponse(response);
            }
        }
    }

    public static final class GetQueueAttributesResponseParser
    implements ResponseParser<GetQueueAttributesResult> {
        @Override
        public GetQueueAttributesResult parse(Response response) throws IOException {
            try {
                GetQueueAttributesResult result = new GetQueueAttributesResult();
                result.setRequestId(response.header("x-mns-request-id"));
                result.setStatusCode(response.code());
                result.setResponseHeader(ResponseParsers.parseResponseHeader(response));
                QueueMetaDeserializer deserializer = new QueueMetaDeserializer();
                result.setQueueMeta(deserializer.deserialize(response));
                GetQueueAttributesResult getQueueAttributesResult = result;
                return getQueueAttributesResult;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                ResponseParsers.safeCloseResponse(response);
            }
        }
    }

    public static final class SetQueueAttributesResponseParser
    implements ResponseParser<SetQueueAttributesResult> {
        @Override
        public SetQueueAttributesResult parse(Response response) throws IOException {
            try {
                SetQueueAttributesResult result = new SetQueueAttributesResult();
                result.setRequestId(response.header("x-mns-request-id"));
                result.setStatusCode(response.code());
                result.setResponseHeader(ResponseParsers.parseResponseHeader(response));
                SetQueueAttributesResult setQueueAttributesResult = result;
                return setQueueAttributesResult;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                ResponseParsers.safeCloseResponse(response);
            }
        }
    }

    public static final class DeleteQueueResponseParser
    implements ResponseParser<DeleteQueueResult> {
        @Override
        public DeleteQueueResult parse(Response response) throws IOException {
            try {
                DeleteQueueResult result = new DeleteQueueResult();
                result.setRequestId(response.header("x-mns-request-id"));
                result.setStatusCode(response.code());
                result.setResponseHeader(ResponseParsers.parseResponseHeader(response));
                DeleteQueueResult deleteQueueResult = result;
                return deleteQueueResult;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                ResponseParsers.safeCloseResponse(response);
            }
        }
    }

    public static final class CreateQueueResponseParser
    implements ResponseParser<CreateQueueResult> {
        @Override
        public CreateQueueResult parse(Response response) throws IOException {
            try {
                CreateQueueResult result = new CreateQueueResult();
                result.setRequestId(response.header("x-mns-request-id"));
                result.setStatusCode(response.code());
                result.setResponseHeader(ResponseParsers.parseResponseHeader(response));
                result.setQueueLocation(result.getResponseHeader().get("Location"));
                CreateQueueResult createQueueResult = result;
                return createQueueResult;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                ResponseParsers.safeCloseResponse(response);
            }
        }
    }
}

