/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.mns.model.deserialize;

import com.alibaba.sdk.android.common.ServiceException;
import com.alibaba.sdk.android.mns.model.deserialize.XMLDeserializer;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import okhttp3.Response;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ErrorMessageListDeserializer
extends XMLDeserializer<ServiceException> {
    @Override
    public ServiceException deserialize(Response response) throws Exception {
        int statusCode = response.code();
        String requestId = response.header("x-mns-request-id");
        String code = null;
        String message = null;
        String hostId = null;
        String errorMessage = null;
        try {
            String rootName;
            errorMessage = response.body().string();
            DocumentBuilder builder = this.getDocumentBuilder();
            InputSource is = new InputSource(new StringReader(errorMessage));
            Document doc = builder.parse(is);
            Element root = doc.getDocumentElement();
            if (root != null && (rootName = root.getNodeName()).equals("Error")) {
                code = this.safeGetElementContent(root, "Code", "");
                message = this.safeGetElementContent(root, "Message", "");
                requestId = this.safeGetElementContent(root, "RequestId", "");
                hostId = this.safeGetElementContent(root, "HostId", "");
                return new ServiceException(statusCode, message, code, requestId, hostId, errorMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ServiceException(statusCode, message, code, requestId, hostId, errorMessage);
    }
}

