/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.mns.model.deserialize;

import com.alibaba.sdk.android.mns.model.Message;
import com.alibaba.sdk.android.mns.model.deserialize.XMLDeserializer;
import java.io.StringReader;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import okhttp3.Response;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class MessageDeserializer
extends XMLDeserializer<Message> {
    @Override
    public Message deserialize(Response response) throws Exception {
        Message message = new Message();
        try {
            String rootName;
            String xmlMessage = response.body().string();
            DocumentBuilder builder = this.getDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xmlMessage));
            Document doc = builder.parse(is);
            Element root = doc.getDocumentElement();
            if (root != null && (rootName = root.getNodeName()).equals("Message")) {
                String priority;
                String dequeueCount;
                String firstDequeueTime;
                String nextVisibleTime;
                String enqueTime;
                String messageBody;
                String receiptHandle;
                String messageBodyMd5;
                String messageId = this.safeGetElementContent(root, "MessageId", null);
                if (messageId != null) {
                    message.setMessageId(messageId);
                }
                if ((messageBodyMd5 = this.safeGetElementContent(root, "MessageBodyMD5", null)) != null) {
                    message.setMessageBodyMd5(messageBodyMd5);
                }
                if ((receiptHandle = this.safeGetElementContent(root, "ReceiptHandle", null)) != null) {
                    message.setReceiptHandle(receiptHandle);
                }
                if ((messageBody = this.safeGetElementContent(root, "MessageBody", null)) != null) {
                    message.setMessageBody(messageBody);
                }
                if ((enqueTime = this.safeGetElementContent(root, "EnqueueTime", null)) != null) {
                    message.setEnqueueTime(new Date(Long.parseLong(enqueTime)));
                }
                if ((nextVisibleTime = this.safeGetElementContent(root, "NextVisibleTime", null)) != null) {
                    message.setNextVisibleTime(new Date(Long.parseLong(nextVisibleTime)));
                }
                if ((firstDequeueTime = this.safeGetElementContent(root, "FirstDequeueTime", null)) != null) {
                    message.setFirstDequeueTime(new Date(Long.parseLong(firstDequeueTime)));
                }
                if ((dequeueCount = this.safeGetElementContent(root, "DequeueCount", null)) != null) {
                    message.setDequeueCount(Integer.parseInt(dequeueCount));
                }
                if ((priority = this.safeGetElementContent(root, "Priority", null)) != null) {
                    message.setPriority(Integer.parseInt(priority));
                }
                return message;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

