/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.mns.model.deserialize;

import com.alibaba.sdk.android.mns.model.PagingListResult;
import com.alibaba.sdk.android.mns.model.deserialize.AbstractQueueMetaDeserializer;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import okhttp3.Response;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class QueueArrayDeserializer
extends AbstractQueueMetaDeserializer<PagingListResult<String>> {
    @Override
    public PagingListResult<String> deserialize(Response response) throws Exception {
        try {
            String responseBody = response.body().string();
            DocumentBuilder builder = this.getDocumentBuilder();
            InputSource is = new InputSource(new StringReader(responseBody));
            Document doc = builder.parse(is);
            return this.parseQueueList(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PagingListResult<String> parseQueueList(Document doc) {
        NodeList list = doc.getElementsByTagName("Queue");
        ArrayList<String> queues = new ArrayList<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element e = (Element)list.item(i);
            String tmpQueue = this.safeGetElementContent(e, "QueueURL", null);
            if (tmpQueue == null) continue;
            queues.add(tmpQueue);
        }
        PagingListResult<String> result = null;
        if (queues.size() > 0) {
            result = new PagingListResult<String>();
            list = doc.getElementsByTagName("NextMarker");
            if (list.getLength() > 0) {
                result.setMarker(list.item(0).getTextContent());
            }
            result.setResult(queues);
        }
        return result;
    }
}

