/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.mns.network;

import com.alibaba.sdk.android.common.ClientException;
import com.alibaba.sdk.android.common.ServiceException;
import com.alibaba.sdk.android.mns.callback.MNSProgressCallback;
import com.alibaba.sdk.android.mns.common.MNSLog;
import com.alibaba.sdk.android.mns.common.MNSUtils;
import com.alibaba.sdk.android.mns.internal.RequestMessage;
import com.alibaba.sdk.android.mns.internal.ResponseParser;
import com.alibaba.sdk.android.mns.internal.ResponseParsers;
import com.alibaba.sdk.android.mns.model.MNSResult;
import com.alibaba.sdk.android.mns.network.ExecutionContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class MNSRequestTask<T extends MNSResult>
implements Callable<T> {
    private ResponseParser<T> responseParser;
    private RequestMessage message;
    private ExecutionContext context;
    private OkHttpClient client;

    public MNSRequestTask(RequestMessage message, ResponseParser parser, ExecutionContext context) {
        this.responseParser = parser;
        this.message = message;
        this.context = context;
        this.client = context.getClient();
    }

    @Override
    public T call() throws Exception {
        Request request = null;
        Response response = null;
        Exception exception = null;
        Call call = null;
        try {
            Map headerMap;
            MNSLog.logD("[call] - ");
            if (this.context.getCancellationHandler().isCancelled()) {
                throw new InterruptedIOException("This task is cancelled!");
            }
            Request.Builder requestBuilder = new Request.Builder();
            String url = this.message.buildCanonicalURL();
            MNSUtils.signRequest(this.message);
            requestBuilder = requestBuilder.url(url);
            for (String key : this.message.getHeaders().keySet()) {
                requestBuilder = requestBuilder.addHeader(key, this.message.getHeaders().get(key));
            }
            String contentType = this.message.getHeaders().get("Content-Type");
            String content = this.message.getContent();
            if (this.message.getContent() != null) {
                MNSUtils.assertTrue(contentType != null, "Content type can't be null when send data!");
                requestBuilder = requestBuilder.method(this.message.getMethod().toString(), (RequestBody)new ProgressTouchableRequestBody(this.message.getContent().getBytes(), contentType, this.context.getProgressCallback()));
            } else {
                switch (this.message.getMethod()) {
                    case PUT: {
                        requestBuilder = requestBuilder.method(this.message.getMethod().toString(), RequestBody.create(null, (byte[])new byte[0]));
                        break;
                    }
                    case GET: {
                        requestBuilder = requestBuilder.get();
                        break;
                    }
                    case HEAD: {
                        requestBuilder = requestBuilder.head();
                        break;
                    }
                    case DELETE: {
                        requestBuilder = requestBuilder.delete();
                        break;
                    }
                }
            }
            request = requestBuilder.build();
            if (MNSLog.isEnableLog()) {
                MNSLog.logD("request url: " + request.url());
                headerMap = request.headers().toMultimap();
                for (String key : headerMap.keySet()) {
                    MNSLog.logD("requestHeader " + key + ": " + (String)((List)headerMap.get(key)).get(0));
                }
            }
            call = this.client.newCall(request);
            this.context.getCancellationHandler().setCall(call);
            response = call.execute();
            if (MNSLog.isEnableLog()) {
                MNSLog.logD("response code: " + response.code() + " for url: " + request.url());
                headerMap = response.headers().toMultimap();
                for (String key : headerMap.keySet()) {
                    MNSLog.logD("responseHeader " + key + ": " + (String)((List)headerMap.get(key)).get(0));
                }
            }
        }
        catch (Exception e) {
            MNSLog.logE("Encounter local execpiton: " + e.toString());
            if (MNSLog.isEnableLog()) {
                e.printStackTrace();
            }
            exception = new ClientException(e.getMessage(), e);
        }
        if (exception == null && (response.code() == 203 || response.code() >= 300)) {
            try {
                exception = ResponseParsers.parseResponseErrorXML(response);
            }
            catch (IOException e) {
                exception = new ClientException(e.getMessage(), e);
            }
        } else if (exception == null) {
            try {
                MNSResult result = (MNSResult)this.responseParser.parse(response);
                if (this.context.getCompletedCallback() != null) {
                    this.context.getCompletedCallback().onSuccess(this.context.getRequest(), result);
                }
                return (T)result;
            }
            catch (IOException e) {
                exception = new ClientException(e.getMessage(), e);
            }
        }
        if (call != null && call.isCanceled() || this.context.getCancellationHandler().isCancelled()) {
            exception = new ClientException("Task is cancelled!", exception.getCause(), true);
        }
        if (exception instanceof ClientException) {
            if (this.context.getCompletedCallback() != null) {
                this.context.getCompletedCallback().onFailure(this.context.getRequest(), (ClientException)exception, null);
            }
        } else if (this.context.getCompletedCallback() != null) {
            this.context.getCompletedCallback().onFailure(this.context.getRequest(), null, (ServiceException)exception);
        }
        throw exception;
    }

    class ProgressTouchableRequestBody
    extends RequestBody {
        private static final int SEGMENT_SIZE = 2048;
        private byte[] data;
        private File file;
        private InputStream inputStream;
        private String contentType;
        private long contentLength;
        private MNSProgressCallback callback;

        public ProgressTouchableRequestBody(File file, String contentType, MNSProgressCallback callback) {
            this.file = file;
            this.contentType = contentType;
            this.contentLength = file.length();
            this.callback = callback;
        }

        public ProgressTouchableRequestBody(byte[] data, String contentType, MNSProgressCallback callback) {
            this.data = data;
            this.contentType = contentType;
            this.contentLength = data.length;
            this.callback = callback;
        }

        public ProgressTouchableRequestBody(InputStream input, long contentLength, String contentType, MNSProgressCallback callback) {
            this.inputStream = input;
            this.contentType = contentType;
            this.contentLength = contentLength;
            this.callback = callback;
        }

        public MediaType contentType() {
            return MediaType.parse((String)this.contentType);
        }

        public long contentLength() throws IOException {
            return this.contentLength;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            long read;
            Source source = null;
            if (this.file != null) {
                source = Okio.source((File)this.file);
            } else if (this.data != null) {
                source = Okio.source((InputStream)new ByteArrayInputStream(this.data));
            } else if (this.inputStream != null) {
                source = Okio.source((InputStream)this.inputStream);
            }
            for (long total = 0L; total < this.contentLength; total += read) {
                long remain = this.contentLength - total;
                long toRead = Math.min(remain, 2048L);
                read = source.read(sink.buffer(), toRead);
                if (read == -1L) break;
                sink.flush();
                if (this.callback == null) continue;
                this.callback.onProgress(MNSRequestTask.this.context.getRequest(), total, this.contentLength);
            }
            if (source != null) {
                source.close();
            }
        }
    }
}

