/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.callback.OSSProgressCallback;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.utils.BinaryUtil;
import com.alibaba.sdk.android.oss.common.utils.IOUtils;
import com.alibaba.sdk.android.oss.internal.InternalRequestOperation;
import com.alibaba.sdk.android.oss.internal.OSSAsyncTask;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.HeadObjectRequest;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.ListPartsRequest;
import com.alibaba.sdk.android.oss.model.ListPartsResult;
import com.alibaba.sdk.android.oss.model.PartETag;
import com.alibaba.sdk.android.oss.model.PartSummary;
import com.alibaba.sdk.android.oss.model.ResumableUploadRequest;
import com.alibaba.sdk.android.oss.model.ResumableUploadResult;
import com.alibaba.sdk.android.oss.model.UploadPartRequest;
import com.alibaba.sdk.android.oss.model.UploadPartResult;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExtensionRequestOperation {
    private static final ExecutorService executor = Executors.newFixedThreadPool(3);
    private InternalRequestOperation apiOperation;

    public ExtensionRequestOperation(InternalRequestOperation apiOperation) {
        this.apiOperation = apiOperation;
    }

    public boolean doesObjectExist(String bucketName, String objectKey) throws ClientException, ServiceException {
        try {
            HeadObjectRequest head = new HeadObjectRequest(bucketName, objectKey);
            this.apiOperation.headObject(head, null).getResult();
            return true;
        }
        catch (ServiceException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    public void abortResumableUpload(ResumableUploadRequest request) throws IOException {
        String uploadFilePath = request.getUploadFilePath();
        if (request.getRecordDirectory() != null) {
            String fileMd5 = BinaryUtil.calculateMd5Str(uploadFilePath);
            String recordFileName = BinaryUtil.calculateMd5Str((fileMd5 + request.getBucketName() + request.getObjectKey() + String.valueOf(request.getPartSize())).getBytes());
            String recordPath = request.getRecordDirectory() + "/" + recordFileName;
            File recordFile = new File(recordPath);
            if (recordFile.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(recordFile));
                String uploadId = br.readLine();
                br.close();
                OSSLog.logD("[initUploadId] - Found record file, uploadid: " + uploadId);
                AbortMultipartUploadRequest abort = new AbortMultipartUploadRequest(request.getBucketName(), request.getObjectKey(), uploadId);
                this.apiOperation.abortMultipartUpload(abort, null);
            }
            if (recordFile != null) {
                recordFile.delete();
            }
        }
    }

    public OSSAsyncTask<ResumableUploadResult> resumableUpload(ResumableUploadRequest request, OSSCompletedCallback<ResumableUploadRequest, ResumableUploadResult> completedCallback) {
        ExecutionContext<ResumableUploadRequest> executionContext = new ExecutionContext<ResumableUploadRequest>(this.apiOperation.getInnerClient(), request);
        return OSSAsyncTask.wrapRequestTask(executor.submit(new ResumableUploadTask(request, completedCallback, executionContext)), executionContext);
    }

    class ResumableUploadTask
    implements Callable<ResumableUploadResult> {
        private ResumableUploadRequest request;
        private OSSCompletedCallback<ResumableUploadRequest, ResumableUploadResult> completedCallback;
        private ExecutionContext context;
        private String uploadId;
        private File recordFile;
        private List<PartETag> partETags = new ArrayList<PartETag>();
        private long fileLength;
        private long currentUploadLength;

        public ResumableUploadTask(ResumableUploadRequest request, OSSCompletedCallback<ResumableUploadRequest, ResumableUploadResult> completedCallback, ExecutionContext context) {
            this.request = request;
            this.completedCallback = completedCallback;
            this.context = context;
        }

        @Override
        public ResumableUploadResult call() throws Exception {
            try {
                this.initUploadId();
                ResumableUploadResult result = this.doMultipartUpload();
                if (this.completedCallback != null) {
                    this.completedCallback.onSuccess(this.request, result);
                }
                return result;
            }
            catch (ServiceException e) {
                if (this.completedCallback != null) {
                    this.completedCallback.onFailure(this.request, null, e);
                }
                throw e;
            }
            catch (ClientException e) {
                if (this.completedCallback != null) {
                    this.completedCallback.onFailure(this.request, e, null);
                }
                throw e;
            }
            catch (IOException e) {
                ClientException clientException = new ClientException(e.toString(), e);
                if (this.completedCallback != null) {
                    this.completedCallback.onFailure(this.request, clientException, null);
                }
                throw clientException;
            }
        }

        private void initUploadId() throws IOException, ServiceException, ClientException {
            String uploadFilePath = this.request.getUploadFilePath();
            if (this.request.getRecordDirectory() != null) {
                String fileMd5 = BinaryUtil.calculateMd5Str(uploadFilePath);
                String recordFileName = BinaryUtil.calculateMd5Str((fileMd5 + this.request.getBucketName() + this.request.getObjectKey() + String.valueOf(this.request.getPartSize())).getBytes());
                String recordPath = this.request.getRecordDirectory() + "/" + recordFileName;
                this.recordFile = new File(recordPath);
                if (this.recordFile.exists()) {
                    BufferedReader br = new BufferedReader(new FileReader(this.recordFile));
                    this.uploadId = br.readLine();
                    br.close();
                    OSSLog.logD("[initUploadId] - Found record file, uploadid: " + this.uploadId);
                    ListPartsRequest listParts = new ListPartsRequest(this.request.getBucketName(), this.request.getObjectKey(), this.uploadId);
                    OSSAsyncTask<ListPartsResult> task = ExtensionRequestOperation.this.apiOperation.listParts(listParts, null);
                    try {
                        for (PartSummary part : task.getResult().getParts()) {
                            this.partETags.add(new PartETag(part.getPartNumber(), part.getETag()));
                        }
                        return;
                    }
                    catch (ServiceException e) {
                        if (e.getStatusCode() == 404) {
                            this.uploadId = null;
                        }
                        throw e;
                    }
                    catch (ClientException e) {
                        throw e;
                    }
                }
                if (!this.recordFile.exists() && !this.recordFile.createNewFile()) {
                    throw new ClientException("Can't create file at path: " + this.recordFile.getAbsolutePath() + "\nPlease make sure the directory exist!");
                }
            }
            InitiateMultipartUploadRequest init = new InitiateMultipartUploadRequest(this.request.getBucketName(), this.request.getObjectKey(), this.request.getMetadata());
            InitiateMultipartUploadResult initResult = ExtensionRequestOperation.this.apiOperation.initMultipartUpload(init, null).getResult();
            this.uploadId = initResult.getUploadId();
            if (this.recordFile != null) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(this.recordFile));
                bw.write(this.uploadId);
                bw.close();
            }
        }

        private ResumableUploadResult doMultipartUpload() throws IOException, ClientException, ServiceException {
            long realSkip;
            if (this.context.getCancellationHandler().isCancelled()) {
                if (this.request.deleteUploadOnCancelling().booleanValue()) {
                    this.abortThisResumableUpload();
                    if (this.recordFile != null) {
                        this.recordFile.delete();
                    }
                }
                this.throwOutInterruptClientException();
            }
            long blockSize = this.request.getPartSize();
            int currentUploadIndex = this.partETags.size() + 1;
            File uploadFile = new File(this.request.getUploadFilePath());
            this.fileLength = uploadFile.length();
            final OSSProgressCallback<ResumableUploadRequest> progressCallback = this.request.getProgressCallback();
            int totalBlockNum = (int)(this.fileLength / blockSize) + (this.fileLength % blockSize == 0L ? 0 : 1);
            this.currentUploadLength = currentUploadIndex <= totalBlockNum ? blockSize * (long)(currentUploadIndex - 1) : this.fileLength;
            FileInputStream in = new FileInputStream(uploadFile);
            for (long at = 0L; at < this.currentUploadLength; at += realSkip) {
                realSkip = ((InputStream)in).skip(this.currentUploadLength - at);
                if (realSkip != -1L) continue;
                throw new IOException("Skip failed! [fileLength]: " + this.fileLength + " [needSkip]: " + this.currentUploadLength);
            }
            while (currentUploadIndex <= totalBlockNum) {
                UploadPartRequest uploadPart = new UploadPartRequest(this.request.getBucketName(), this.request.getObjectKey(), this.uploadId, currentUploadIndex);
                uploadPart.setProgressCallback(new OSSProgressCallback<UploadPartRequest>(){

                    @Override
                    public void onProgress(UploadPartRequest request, long currentSize, long totalSize) {
                        if (progressCallback != null) {
                            progressCallback.onProgress(ResumableUploadTask.this.request, ResumableUploadTask.this.currentUploadLength + currentSize, ResumableUploadTask.this.fileLength);
                        }
                    }
                });
                int toUpload = (int)Math.min(blockSize, this.fileLength - this.currentUploadLength);
                byte[] partContent = IOUtils.readStreamAsBytesArray(in, toUpload);
                uploadPart.setPartContent(partContent);
                uploadPart.setMd5Digest(BinaryUtil.calculateBase64Md5(partContent));
                UploadPartResult uploadPartResult = ExtensionRequestOperation.this.apiOperation.uploadPart(uploadPart, null).getResult();
                this.partETags.add(new PartETag(currentUploadIndex, uploadPartResult.getETag()));
                this.currentUploadLength += (long)toUpload;
                ++currentUploadIndex;
                if (!this.context.getCancellationHandler().isCancelled()) continue;
                if (this.request.deleteUploadOnCancelling().booleanValue()) {
                    this.abortThisResumableUpload();
                    if (this.recordFile != null) {
                        this.recordFile.delete();
                    }
                }
                this.throwOutInterruptClientException();
            }
            CompleteMultipartUploadRequest complete = new CompleteMultipartUploadRequest(this.request.getBucketName(), this.request.getObjectKey(), this.uploadId, this.partETags);
            complete.setMetadata(this.request.getMetadata());
            if (this.request.getCallbackParam() != null) {
                complete.setCallbackParam(this.request.getCallbackParam());
            }
            if (this.request.getCallbackVars() != null) {
                complete.setCallbackVars(this.request.getCallbackVars());
            }
            CompleteMultipartUploadResult completeResult = ExtensionRequestOperation.this.apiOperation.completeMultipartUpload(complete, null).getResult();
            if (this.recordFile != null) {
                this.recordFile.delete();
            }
            return new ResumableUploadResult(completeResult);
        }

        private void abortThisResumableUpload() {
            if (this.uploadId != null) {
                AbortMultipartUploadRequest abort = new AbortMultipartUploadRequest(this.request.getBucketName(), this.request.getObjectKey(), this.uploadId);
                ExtensionRequestOperation.this.apiOperation.abortMultipartUpload(abort, null).waitUntilFinished();
            }
        }

        private void throwOutInterruptClientException() throws ClientException {
            IOException e = new IOException();
            throw new ClientException(e.getMessage(), e);
        }
    }
}

