package com.byh.module.verlogin;

import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.SpanUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.entity.LogoutAccountReqEntity;
import com.byh.module.verlogin.present.LogoutAccountPresent;
import com.byh.module.verlogin.view.ILogoutAccountView;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.global.router.AppRouter;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.service.IExitAppProvider;
import com.kangxin.common.byh.util.VertifyDataUtil;

import org.jetbrains.annotations.NotNull;

import static com.kangxin.common.byh.global.Global.CHANNEL_CODE;
import static com.kangxin.common.byh.global.Global.RECEIVE_EXIST_APP;

@Route(path = VerloginRouter.ACCOUNT_LOGOUT_APP)
public class AccountLogoutActivity extends BaseActivity implements IToolView, ILogoutAccountView, View.OnClickListener {
    private TextView vOkLogoutTv;
    private TextView vAccountNotesTv;
    private ImageView vCheckedImg;
    private boolean isSelected = false;
    private LogoutAccountPresent mLogoutAccountPresent = new LogoutAccountPresent(this);
    private IExitAppProvider mExitAppProvider = (IExitAppProvider) ARouter.getInstance().build(AppRouter.EXIT_APP_RECEIVER).navigation();

    @Override
    public int getContentLayoutId() {
        return R.layout.activity_account_logout;
    }

    @Override
    public void start() {
        vOkLogoutTv = findViewById(R.id.vOkLogoutTv);
        vCheckedImg = findViewById(R.id.vCheckedImg);
        vAccountNotesTv = findViewById(R.id.vAccountNotesTv);

        vOkLogoutTv.setOnClickListener(v -> {
            LogoutAccountReqEntity logoutAccountReqEntity = new LogoutAccountReqEntity();
            logoutAccountReqEntity.setAccountId(VertifyDataUtil.getInstance().getAccountId());
            logoutAccountReqEntity.setChannelCode(CHANNEL_CODE);
            logoutAccountReqEntity.setNeedCheckPw(false);
            mLogoutAccountPresent.logoutAppAccount(logoutAccountReqEntity);
        });

        vAccountNotesTv.setMovementMethod(LinkMovementMethod.getInstance());
        vAccountNotesTv.setText(createAgreedText());
        vAccountNotesTv.setHighlightColor(Color.TRANSPARENT);

        if (isSelected) {
            vCheckedImg.setImageResource(R.drawable.ic_by_read_tag_ok_icon);
            vOkLogoutTv.setClickable(true);
            vOkLogoutTv.setBackgroundResource(R.color.verlogin_color_FF5F5F);
        } else {
            vCheckedImg.setImageResource(R.drawable.ic_by_unread_tag_ok_icon);
            vOkLogoutTv.setClickable(false);
            vOkLogoutTv.setBackgroundResource(R.color.color_999999);
        }

        vCheckedImg.setOnClickListener(this);
        vAccountNotesTv.setOnClickListener(this);
    }

    @NotNull
    @Override
    public View getVToolView() {
        return rootView.findViewById(R.id.vToolBar);
    }

    @Override
    public void finishCurrentView() {
        finish();
    }

    @Override
    public void logoutAccountOk() {
        ToastUtils.showLong(StringUtils.getString(R.string.verlogin_account_logout_success_tips));
        new Handler().postDelayed(() -> {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                mExitAppProvider.registerExitAppReceiver();
                mExitAppProvider.sendExitAppReceiver();
            } else {
                Intent intent = new Intent(RECEIVE_EXIST_APP);
                sendBroadcast(intent);
            }
        }, 4000);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mExitAppProvider != null) {
            mExitAppProvider.unRegisterExitAppReceiver();
        }
    }

    private CharSequence createAgreedText() {
        return new SpanUtils()
                .append(StringUtils.getString(R.string.verlogin_woyiyuedubingtongyi))
                .append(StringUtils.getString(R.string.verlogin_zhanghaozhuxiaoxuzhi_))
                .setForegroundColor(Color.parseColor("#3576E0"))
                .create();
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.vCheckedImg || v.getId() == R.id.vAccountNotesTv) {
            if (!isSelected) {
                isSelected = true;
                vCheckedImg.setImageResource(R.drawable.ic_by_read_tag_ok_icon);
                vOkLogoutTv.setClickable(true);
                vOkLogoutTv.setBackgroundResource(R.color.verlogin_color_FF5F5F);
            } else {
                isSelected = false;
                vCheckedImg.setImageResource(R.drawable.ic_by_unread_tag_ok_icon);
                vOkLogoutTv.setClickable(false);
                vOkLogoutTv.setBackgroundResource(R.color.color_999999);
            }
        }
    }

  @Override
  public boolean initYm() {
    return false;
  }
}
