package com.byh.module.verlogin;

import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.module.verlogin.event.vertify.LoginDispatchStatus;
import com.byh.module.verlogin.event.vertify.LoginStatusManager;
import com.byh.module.verlogin.present.BindWeixPresent;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.byh.module.verlogin.view.IBindWeChatView;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.event.DispatchVerStatus;
import com.kangxin.common.byh.global.router.AppRouter;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.util.CountDownUtil;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.util.common.VerifyUtil;
import com.kangxin.widget.common.byh.ZpPhoneEditText;

import static com.kangxin.common.byh.global.Global.OPEN_ID_KEY;
import static com.kangxin.common.byh.global.Global.UNIONID_KEY;

@Route(path = VerloginRouter.BIND_WECHAT)
public class BindWeixActivity extends BaseActivity implements IBindWeChatView {

    private TextView mVercodeText;
    private CountDownUtil mCountDownUtil;
    private ZpPhoneEditText mPhoneNumEdit;
    private ImageView mClosePhoneNumImg;
    private BindWeixPresent mBindWechatPresent;
    private EditText mVercodeEdt;
    TextView mErrNoticeText;

    private Button mBindBtn;

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    @Override
    public void start() {

        mBindWechatPresent = new BindWeixPresent(getBaseContext(), this);
        ImageView backImgView = findViewById(R.id.img_back_ver);
        backImgView.setImageResource(R.drawable.ic_gray_fanhui);
        mBindBtn = findViewById(R.id.bt_login);
        mBindBtn.setText(StringsUtils.getString(R.string.verlogin_bangdingshoujihao));

//        findViewById(R.id.login_question).setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                ARouter.getInstance().build(AppRouter.CONTACT_US_URL).navigation();
//            }
//        });

        hideNouseViews();

        mVercodeText = findViewById(R.id.vercode_txt);
        mPhoneNumEdit = findViewById(R.id.edt_phonenum);
        mClosePhoneNumImg = findViewById(R.id.clearlogin_img);
        mVercodeEdt = findViewById(R.id.edt_vercode);
        mErrNoticeText = findViewById(R.id.err_notice);

        mClosePhoneNumImg.setOnClickListener(view -> mPhoneNumEdit.setText(""));

        mCountDownUtil = new CountDownUtil(mVercodeText)
                .setCountDownMillis(60_000L)
                .setCountDownColor(R.color.white, android.R.color.darker_gray);//倒计时60000ms

        isVercodeUsable(false);

        mCountDownUtil.setOnDownEndListener(() -> {
            String phoneNum = mPhoneNumEdit.getPhoneText();
            if (!TextUtils.isEmpty(phoneNum)){
                isVercodeUsable(true);
            }else {
                isVercodeUsable(false);
            }
        });

        mVercodeText.setOnClickListener(view -> {
            String phoneNum = mPhoneNumEdit.getPhoneText();
            if (TextUtils.isEmpty(phoneNum)){
                return;
            }

            mBindWechatPresent.sentVerCode(phoneNum);
            mCountDownUtil.start();
            isVercodeUsable(false);
        });

        addEdtChangeListener();
    }

    private void addEdtChangeListener(){
        mPhoneNumEdit.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
            @Override
            public void afterTextChanged(Editable editable) {
                mErrNoticeText.setVisibility(View.GONE);

                String phoneNum = mPhoneNumEdit.getPhoneText();
                if (VerifyUtil.isMobilePhoneNumber(phoneNum)){
                    isVercodeUsable(true);
                }else {
                    isVercodeUsable(false);
                }

            }
        });


        mVercodeEdt.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
            @Override
            public void afterTextChanged(Editable editable) {
                mErrNoticeText.setVisibility(View.GONE);
                if (editable.length() == 6){
                    mBindBtn.setClickable(true);
                    mBindBtn.setBackground(ResourcesCompat.getDrawable(getResources(),
                            R.drawable.vercode_order_bg, null));
                }else {
                    mBindBtn.setClickable(false);
                    mBindBtn.setBackground(ResourcesCompat.getDrawable(getResources(),
                            R.drawable.bt_gray_order_bg, null));
                }

            }
        });
    }

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    private void isVercodeUsable(boolean isUse){
        if (isUse){
            mCountDownUtil.setUsable(true);
            mVercodeText.setBackground(ResourcesCompat.getDrawable(getResources(),
                    R.drawable.vercode_order_bg, null));
            mVercodeText.setTextColor(getResources().getColor(android.R.color.white));
            mVercodeText.setClickable(true);
            mVercodeText.setFocusable(true);
            mVercodeText.setText(R.string.ver_getvercode);
        }else {
            mCountDownUtil.setUsable(false);
            mVercodeText.setBackground(ResourcesCompat.getDrawable(getResources(),
                    R.drawable.edt_order_bg, null));
            mVercodeText.setTextColor(getResources().getColor(android.R.color.darker_gray));
            mVercodeText.setText(R.string.ver_getvercode);
            mVercodeText.setClickable(false);
            mVercodeText.setFocusable(false);
        }
    }

    /**
     * 隐藏没用的view
     */
    private void hideNouseViews(){
        findViewById(R.id.txt_pwd_login).setVisibility(View.GONE);
        findViewById(R.id.xieyi_linea).setVisibility(View.GONE);
        findViewById(R.id.lieanr_weixin).setVisibility(View.GONE);
    }

    @Override
    public int getContentLayoutId() {
        return R.layout.activity_ver_login;
    }

    /**
     * 点击绑定按钮
     * @param view
     */
    public void clickLogin(View view){
        String openId = getIntent().getStringExtra(OPEN_ID_KEY);
        String unionId = getIntent().getStringExtra(UNIONID_KEY);
        String verCode = mVercodeEdt.getText().toString().trim();

        String phoneNum = mPhoneNumEdit.getPhoneText();
        if (!VerifyUtil.isMobilePhoneNumber(phoneNum)){
            mErrNoticeText.setVisibility(View.VISIBLE);
            mErrNoticeText.setText(StringsUtils.getString(R.string.verlogin_shoujihaogeshibuzhengque));
            return;
        }


        mBindWechatPresent.reqBindWeChat(verCode, phoneNum, openId, unionId);
    }

    public void clickBack(View view){
        finish();
    }

    @Override
    public void bindWechatSuccess() {

        int status  =  VertifyDataUtil.getInstance(getBaseContext()).getAcountStatus();

        DispatchVerStatus loginDispatchStatus = new LoginDispatchStatus();
        loginDispatchStatus.registerStatus(new LoginStatusManager(this));

        loginDispatchStatus.dispatchStatus(status);
        updateInfoStatus();


        finish();
    }

    private void updateInfoStatus(){

        UpdateVerStatus.getInstance().updateDocDetailInfo(getBaseContext(),
                new IUpdateVerStatus.OnUpdateDocDetailInfoCallback() {
                    @Override
                    public void updateDocDetailInfoOk() {
                        finish();
                    }

                    @Override
                    public void updateDocDetailInfoErr(String err) {
                        showShortToast(err);

                    }
                });
    }

    @Override
    public void onError(String msg) {
        mCountDownUtil.reset();
        mErrNoticeText.setVisibility(View.VISIBLE);
        mErrNoticeText.setText(msg);
    }

  @Override
  public boolean initYm() {
    return false;
  }
}
