package com.byh.module.verlogin;

import static com.kangxin.common.byh.global.Global.RECEIVE_EXIST_APP;

import android.content.Intent;
import android.os.Build;
import android.os.CountDownTimer;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;

import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.module.verlogin.module.ChangePhoneViewModel;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.global.router.AppRouter;
import com.kangxin.common.byh.service.IExitAppProvider;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.util.common.VerifyUtil;

public class ChangePhoneNewNumActivity extends BaseActivity {

  private TextView tv_code;
  private EditText ed_code,ed_tel;
  private Button tv_next;
  private CountDownTimer timer;
  private ChangePhoneViewModel viewModel;
  private String codeKey = "";
  private IExitAppProvider mExitAppProvider = (IExitAppProvider) ARouter.getInstance().build(AppRouter.EXIT_APP_RECEIVER).navigation();

  @Override
  public int getContentLayoutId() {
    return R.layout.activity_change_phone_new_num;
  }

  @Override
  public void start() {

    tv_code = findViewById(R.id.tv_code);
    ed_code = findViewById(R.id.et_code);
    tv_next = findViewById(R.id.code_next);
    ed_tel = findViewById(R.id.et_tel);

    tv_next.setClickable(false);
    tv_next.setEnabled(false);
    isVercodeUsable(false);

    viewModel = new ViewModelProvider(this).get(ChangePhoneViewModel.class);

    //发送验证码
    tv_code.setOnClickListener(view -> {
      if(TextUtils.isEmpty(ed_tel.getText().toString().trim())){
        showShortToast("验证码错误,请重新输入");
        return;
      }
      sendCode(ed_tel.getText().toString().trim());
    });

    findViewById(R.id.vLeftImage).setOnClickListener(v->{
      cancelCountDownTimer();
      finish();
    });

    tv_next.setOnClickListener(v->{
      if(TextUtils.isEmpty(ed_tel.getText().toString().trim()) || TextUtils.isEmpty(ed_code.getText().toString().trim()) || TextUtils.isEmpty(codeKey)){
        showShortToast("验证码错误,请重新获取");
        return;
      }
      checkCode();
    });

    ed_tel.addTextChangedListener(new TextWatcher() {
      @Override
      public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {}

      @Override
      public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {}

      @Override
      public void afterTextChanged(Editable editable) {

        String phoneNum = ed_tel.getText().toString();
        if (VerifyUtil.isMobilePhoneNumber(phoneNum)) {
          isVercodeUsable(true);
        } else {
          isVercodeUsable(false);
        }

      }
    });

    ed_code.addTextChangedListener(new TextWatcher() {
      @Override
      public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {}

      @Override
      public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {}

      @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
      @Override
      public void afterTextChanged(Editable editable) {
        if (editable.length() == 6) {
          tv_next.setClickable(true);
          tv_next.setEnabled(true);
          tv_next.setTextColor(getResources().getColor(R.color.white));
          tv_next.setBackground(ResourcesCompat.getDrawable(getResources(),
            R.drawable.vercode_order_bg, null));
        } else {
          tv_next.setClickable(false);
          tv_next.setEnabled(false);
          tv_next.setTextColor(getResources().getColor(R.color.color_999999));
          tv_next.setBackground(ResourcesCompat.getDrawable(getResources(),
            R.drawable.bt_gray_order_bg, null));
        }
      }
    });
  }

  private void sendCode(String mPhoneNum){
    viewModel.getCodeByPhone(mPhoneNum).observe(this, new Observer<String>() {
      @Override
      public void onChanged(String s) {
        codeKey = s;
        ed_tel.setFocusable(false);
        ed_tel.setFocusableInTouchMode(false);
        isVercodeUsable(false);
        starCountDownTimer();
      }
    });
  }

  private void checkCode(){
    viewModel.checkCode(ed_code.getText().toString().trim(),codeKey).observe(this,new Observer<ResponseBody>(){
      @Override
      public void onChanged(ResponseBody responseBody) {
        if(responseBody.getCode() == 200){
          updateNewPhone();
        }else{
          if(responseBody.getMsg().contains("已失效")){
            showShortToast(responseBody.getMsg());
          }else{
            showShortToast("验证码错误，请重新获取");
          }
          codeKey = "";
          isVercodeUsable(true);
          cancelCountDownTimer();
          ed_tel.setFocusable(true);
          ed_tel.setFocusableInTouchMode(true);
        }
      }
    });
  }

  private void updateNewPhone(){
      String accountNo = VertifyDataUtil.getInstance(ChangePhoneNewNumActivity.this).getAccountNo();
      viewModel.updateNewPhoneNum(accountNo,"DOCTOR_ANDROID",ed_tel.getText().toString().trim()).observe(this, new Observer<ResponseBody>() {
        @Override
        public void onChanged(ResponseBody responseBody) {
          showShortToast(responseBody.getMsg());
          if(responseBody.getCode() == 200){
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
              mExitAppProvider.registerExitAppReceiver();
              mExitAppProvider.sendExitAppReceiver();
            } else {
              Intent intent = new Intent(RECEIVE_EXIST_APP);
              sendBroadcast(intent);
            }
          }
        }
      });
  }

  private void isVercodeUsable(boolean isUse) {
    if (isUse) {
      tv_code.setBackground(ResourcesCompat.getDrawable(getResources(),
        R.drawable.vercode_order_bg, null));
      tv_code.setTextColor(getResources().getColor(android.R.color.white));
      tv_code.setClickable(true);
      tv_code.setFocusable(true);
      tv_code.setText(R.string.ver_getvercode);
    } else {
      tv_code.setBackground(ResourcesCompat.getDrawable(getResources(),
        R.drawable.white_corner_bg, null));
      tv_code.setTextColor(getResources().getColor(android.R.color.darker_gray));
      tv_code.setText(R.string.ver_getvercode);
      tv_code.setClickable(false);
      tv_code.setFocusable(false);
    }
  }

  private void cancelCountDownTimer() {
    if (timer != null) {
      timer.cancel();
    }
    timer = null;
  }

  private void starCountDownTimer() {
    if (timer == null) {
      timer = new CountDownTimer(60000, 1000) {
        @Override
        public void onTick(long millisUntilFinished) {
          tv_code.setText(millisUntilFinished/1000+"s");
        }

        @Override
        public void onFinish() {
          isVercodeUsable(true);
          ed_tel.setFocusable(true);
          ed_tel.setFocusableInTouchMode(true);
          cancelCountDownTimer();
        }
      };
      timer.start();
    }
  }

  @Override
  public boolean initYm() {
    return false;
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();
    cancelCountDownTimer();

    if (mExitAppProvider != null) {
      mExitAppProvider.unRegisterExitAppReceiver();
    }
  }
}
