package com.byh.module.verlogin;

import android.content.Intent;
import android.os.Bundle;
import android.provider.Settings;
import android.text.Editable;
import android.text.InputType;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.core.content.res.ResourcesCompat;

import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.entity.VerCodeEntity;
import com.byh.module.verlogin.event.vertify.LoginDispatchStatus;
import com.byh.module.verlogin.event.vertify.LoginStatusManager;
import com.byh.module.verlogin.present.VerLoginPresent;
import com.byh.module.verlogin.view.ILoginView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.ByConfiguration;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.DispatchVerStatus;
import com.kangxin.common.byh.global.router.AppRouter;
import com.kangxin.common.byh.global.router.PushAdRouter;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.provider.IPushAdProvider;
import com.kangxin.common.util.AppManager;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.push.PushManager;
import com.kangxin.util.common.DeviceIdUtil;
import com.kangxin.util.common.VerifyUtil;
import com.kangxin.widget.common.byh.ZpPhoneEditText;
import com.tbruyelle.rxpermissions.RxPermissions;

import static android.Manifest.permission.READ_PHONE_STATE;

public class PwdLoginActivity extends BaseActivity implements ILoginView {

  private String TAG = "PwdLoginActivity";
  private ImageView mPwdShowImg;
  private EditText mVerPwdEdt;
  private ImageView mClosePhoneNumImg;
  private ZpPhoneEditText mPhoneNumEdt;
  private Button mLoginBtn;
  private TextView mErrNoticeText;
  private VerLoginPresent mLoginPresent;
  private TextView mForgetPwdText;
  private CheckBox checkBox;

  private static final String DEVICE_ID_SP_KEY = "umeng_device_id_sp_key";

  @Override
  public void start() {
    mLoginPresent = new VerLoginPresent(this);
    findViewById(R.id.img_back_ver).setOnClickListener(view -> finish());

    findViewById(R.id.login_question).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        ARouter.getInstance().build(AppRouter.CONTACT_US_URL).navigation();
      }
    });
    checkBox = findViewById(R.id.mCheckBox);
    mPwdShowImg = findViewById(R.id.img_pwd_kejian);
    mVerPwdEdt = findViewById(R.id.ver_pwd_edt);
    mClosePhoneNumImg = findViewById(R.id.clearlogin_img);
    mPhoneNumEdt = findViewById(R.id.edt_phonenum);
    mLoginBtn = findViewById(R.id.login_btn);
    mErrNoticeText = findViewById(R.id.err_notice);
    mForgetPwdText = findViewById(R.id.forget_pwd_tv);

    mLoginBtn.setClickable(false);
    mClosePhoneNumImg.setOnClickListener(view -> mPhoneNumEdt.setText(""));

    addEdtChangeListener();

    final int type = InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_PASSWORD;
    mPwdShowImg.setOnClickListener(view -> {
      if (mVerPwdEdt.getInputType() == type) {
        mVerPwdEdt.setInputType(InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
        mVerPwdEdt.setSelection(mVerPwdEdt.getText().length()); //把光标设置到当前文本末尾
        mPwdShowImg.setImageResource(R.drawable.ic_ver_kejian);
      } else {
        mVerPwdEdt.setInputType(type);
        mVerPwdEdt.setSelection(mVerPwdEdt.getText().length());
        mPwdShowImg.setImageResource(R.drawable.ic_bukejian);
      }
    });

    mForgetPwdText.setOnClickListener(v -> {
      String phoneNum = mPhoneNumEdt.getPhoneText();
      if (TextUtils.isEmpty(phoneNum)) {
        showShortToast(StringsUtils.getString(R.string.verlogin_qingshurushoujihao));
        return;
      } else if (!VerifyUtil.isMobilePhoneNumber(phoneNum)) {
        showShortToast(getResources().getString(R.string.forget_phone_error_tips));
        return;
      } else {
        Intent intentFPwd = new Intent(getMContext(), ForgetPassWordActivity.class);
        intentFPwd.putExtra("phoneNum", phoneNum);
        startActivity(intentFPwd);
      }
    });

    findViewById(R.id.ver_user_xieyi).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        //用户协议...
        Bundle bundle = new Bundle();
        bundle.putString("loadurl", ByConfiguration.getUserAgreement(ByConfiguration.getPlatformCode()));
        bundle.putString("title", getResources().getString(R.string.user_agreement));
        Intent intent = new Intent(PwdLoginActivity.this, AgreementNoticeCountryActivity.class);
        intent.putExtras(bundle);
        startActivity(intent);
      }
    });

    findViewById(R.id.ver_yinsizhc).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        // 隐私协议...
        Bundle bundle = new Bundle();
        bundle.putString("loadurl", ByConfiguration.getPrivatePolicy(ByConfiguration.getPlatformCode()));
        bundle.putString("title", getResources().getString(R.string.legal_notice));
        Intent intent = new Intent(PwdLoginActivity.this, AgreementNoticeCountryActivity.class);
        intent.putExtras(bundle);
        startActivity(intent);
      }
    });
  }

  private void addEdtChangeListener() {
    mPhoneNumEdt.addTextChangedListener(new TextWatcher() {
      @Override
      public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

      }

      @Override
      public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

      }

      @Override
      public void afterTextChanged(Editable editable) {
        setLoginBtnUseable();
        mErrNoticeText.setVisibility(View.GONE);
        if (editable.length() != 0) {
          mClosePhoneNumImg.setVisibility(View.VISIBLE);
        } else {
          mClosePhoneNumImg.setVisibility(View.GONE);
        }
      }
    });

    mVerPwdEdt.addTextChangedListener(new TextWatcher() {
      @Override
      public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

      }

      @Override
      public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

      }

      @Override
      public void afterTextChanged(Editable editable) {
        setLoginBtnUseable();
        mErrNoticeText.setVisibility(View.GONE);
        if (editable.length() != 0) {
          mPwdShowImg.setVisibility(View.VISIBLE);
        } else {
          mPwdShowImg.setVisibility(View.GONE);
        }
      }
    });
  }

  private void setLoginBtnUseable() {
    String phoneNum = mPhoneNumEdt.getPhoneText();
    String pwdNum = mVerPwdEdt.getText().toString().trim();

    if (!TextUtils.isEmpty(phoneNum) && !TextUtils.isEmpty(pwdNum)) {
      mLoginBtn.setClickable(true);
      mLoginBtn.setBackground(ResourcesCompat.getDrawable(getResources(), R.drawable.vercode_order_bg,
        null));

    } else {
      mLoginBtn.setClickable(false);
      mLoginBtn.setBackground(ResourcesCompat.getDrawable(getResources(), R.drawable.gray_button_background,
        null));
    }
  }

  @Override
  public int getContentLayoutId() {
    return R.layout.verpwd_login_activity;
  }

  /**
   * 点击登录
   *
   * @param view
   */
  public void clickLogin(View view) {
    if (!checkBox.isChecked()) {
      ToastUtils.showShort("请勾选隐私政策以及用户协议");
      return;
    }

    RxPermissions.getInstance(getBaseContext())
      .request(READ_PHONE_STATE)
      .subscribe(aBoolean -> {
        if (aBoolean) {
          String phoneNum = mPhoneNumEdt.getPhoneText();
          String pwd = mVerPwdEdt.getText().toString().trim();
          String loginDeviceNum = PushManager.getDeviceId(mContext, DeviceIdUtil.getDeviceId(mContext));

          Login login = new Login(phoneNum, pwd);
          login.setLoginDeviceNum(loginDeviceNum);

          mLoginPresent.loginApp(getBaseContext(), login);
        }else{
          String phoneNum = mPhoneNumEdt.getPhoneText();
          String pwd = mVerPwdEdt.getText().toString().trim();
          String loginDeviceNum = PushManager.getDeviceId(mContext, DeviceIdUtil.getDeviceId(mContext));

          Login login = new Login(phoneNum, pwd);
          login.setLoginDeviceNum(loginDeviceNum);

          mLoginPresent.loginApp(getBaseContext(), login);
        }
      });

  }

  private void gotoSetting(){
    try {
      startActivity(new Intent(Settings.ACTION_APPLICATION_SETTINGS));
    }catch (Exception ignore){
      ToastUtils.showShort("打开设置失败，请手动打开app的电话权限");
    }
  }

  @Override
  public void loginOk(ResponseBody<LoginSuccess> loginSuccess) {
    Log.i(TAG, "loginOk===>>" + loginSuccess);
    AppManager.getAppManager().finishActivity(PwdLoginActivity.class);
    AppManager.getAppManager().finishActivity(LoginActivity.class);
    receiveStatus(loginSuccess.getResult().getAccountStatus());

    IPushAdProvider pushAdProvider = (IPushAdProvider) ARouter.getInstance().build(PushAdRouter.REQUEST_PATH).navigation();
    if (pushAdProvider != null) {
      pushAdProvider.request();
    }
  }

  private void receiveStatus(int status) {
    DispatchVerStatus loginDispatchStatus = new LoginDispatchStatus();
    loginDispatchStatus.registerStatus(new LoginStatusManager(this));
    loginDispatchStatus.dispatchStatus(status);
  }

  @Override
  public void reqErr(String err) {
    Log.i(TAG, "reqErr==>>" + err);
    mErrNoticeText.setVisibility(View.VISIBLE);
    mErrNoticeText.setText(err);
  }

  @Override
  public void receiveVercode() {

  }

//  @Override
//  public void receiveVercode(VerCodeEntity verCode) {
//
//  }

  @Override
  public void setPwdOk(String msg) {


  }

  @Override
  public void getCheck() {
  }

  @Override
  public void getCheck(int status) {
    AppManager.getAppManager().finishActivity(PwdLoginActivity.class);
    AppManager.getAppManager().finishActivity(LoginActivity.class);
    receiveStatus(status);
  }

  @Override
  public boolean initYm() {
    return false;
  }
}
