package com.byh.module.verlogin;

import android.text.Editable;
import android.text.InputType;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;

import androidx.core.content.res.ResourcesCompat;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.entity.VerCodeEntity;
import com.byh.module.verlogin.present.VerLoginPresent;
import com.byh.module.verlogin.view.ILoginView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.global.router.AppRouter;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.util.AppManager;
import com.kangxin.util.common.DeviceIdUtil;

import com.kangxin.push.PushManager;

@Route(path = VerloginRouter.PWD_SET)
public class PwdSetActivity extends BaseActivity implements ILoginView {

  private String TAG = "PwdSetActivity";

  private ImageView mPwdShowImg;
  private EditText mVerPwdEdt;
  private Button mOkButton;
  private VerLoginPresent mLoginPresent;

  @Override
  public void start() {

    mLoginPresent = new VerLoginPresent(this);

//    findViewById(R.id.login_question).setOnClickListener(new View.OnClickListener() {
//      @Override
//      public void onClick(View v) {
//        ARouter.getInstance().build(AppRouter.CONTACT_US_URL).navigation();
//      }
//    });

    findViewById(R.id.img_back_ver).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View view) {
        finish();
      }
    });
    mPwdShowImg = findViewById(R.id.img_pwd_kejian);
    mVerPwdEdt = findViewById(R.id.ver_pwd_edt);
    mOkButton = findViewById(R.id.ok_btn);
    mOkButton.setClickable(false);

    mVerPwdEdt.addTextChangedListener(new TextWatcher() {
      @Override
      public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

      }

      @Override
      public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

      }

      @Override
      public void afterTextChanged(Editable editable) {
        setOkBtnUseable();
        if (editable.length() != 0) {
          mPwdShowImg.setVisibility(View.VISIBLE);
        } else {
          mPwdShowImg.setVisibility(View.GONE);
        }
      }
    });

    final int type = InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_PASSWORD;
    mPwdShowImg.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View view) {
        if (mVerPwdEdt.getInputType() == type) {
          mVerPwdEdt.setInputType(InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
          mVerPwdEdt.setSelection(mVerPwdEdt.getText().length()); //把光标设置到当前文本末尾
          mPwdShowImg.setImageResource(R.drawable.ic_ver_kejian);
        } else {
          mVerPwdEdt.setInputType(type);
          mVerPwdEdt.setSelection(mVerPwdEdt.getText().length());
          mPwdShowImg.setImageResource(R.drawable.ic_bukejian);
        }
      }
    });

  }

  @Override
  public int getContentLayoutId() {
    return R.layout.activity_ver_pwdset;
  }

  private void setOkBtnUseable() {
    String phoneNum = mVerPwdEdt.getText().toString().trim();
    if (TextUtils.isEmpty(phoneNum)) {
      mOkButton.setClickable(false);
      mOkButton.setBackground(ResourcesCompat.getDrawable(getResources(), R.drawable.gray_button_background,
        null));
    } else {
      mOkButton.setClickable(true);
      mOkButton.setBackground(ResourcesCompat.getDrawable(getResources(), R.drawable.vercode_order_bg,
        null));
    }

  }

  /**
   * 点击密码设置按钮
   *
   * @param view
   */
  public void clickOk(View view) {
    String pwd = mVerPwdEdt.getText().toString().trim();
    if (!VertifyDataUtil.getInstance(getBaseContext()).authPwd(pwd)) {
      return;
    }

    Login login = new Login();
    String phoneNum = VertifyDataUtil.getInstance(getBaseContext()).getLoginData().getMobileNumber();
    login.setAccountNo(phoneNum);
    login.setPassword(pwd);
    login.setLoginDeviceNum(PushManager.getDeviceId(mContext, DeviceIdUtil.getDeviceId(mContext)));
    mLoginPresent.setPassword(getBaseContext(), login);
  }

  @Override
  public void loginOk(ResponseBody<LoginSuccess> loginSuccess) {

  }

  @Override
  public void reqErr(String err) {
    Log.i(TAG, "==reqErr==>" + err);
  }

  @Override
  public void receiveVercode() {

  }

//  @Override
//    public void receiveVercode(VerCodeEntity verCode) {
//
//    }

  @Override
  public void setPwdOk(String msg) {
    ARouter.getInstance().build(VerloginRouter.PERSON_INFO).navigation();
    finish();
    AppManager.getAppManager().finishActivity(LoginActivity.class);
  }

  @Override
  public void getCheck() {

  }

  @Override
  public void getCheck(int status) {

  }


  @Override
  public boolean initYm() {
    return false;
  }
}
