package com.byh.module.verlogin;

import android.os.Environment;

import androidx.room.Room;

import com.blankj.utilcode.util.Utils;
import com.kangxin.common.base.BaseApplication;
import com.kangxin.common.byh.db.AppDataBase;
import com.kangxin.common.byh.db.DB;
import com.kangxin.common.imageloader.GalleryImageLoader;

import java.io.File;

import cn.finalteam.galleryfinal.CoreConfig;
import cn.finalteam.galleryfinal.FunctionConfig;
import cn.finalteam.galleryfinal.GalleryFinal;
import cn.finalteam.galleryfinal.ThemeConfig;

public class VerLoginApplication extends BaseApplication {

    @Override
    public void onCreate() {
        //初始化网络请求框架
        super.onCreate();
//        RetrofitHelpr.getInstance().createRetrofit(BuildConfig.DEBUG_HOST);

        initGalleryTheme();
    }

    private void initGalleryTheme() {
        //设置主题
        //ThemeConfig.CYAN
        ThemeConfig theme = new ThemeConfig.Builder()
                .build();
        //配置功能
        FunctionConfig functionConfig = new FunctionConfig.Builder()
                .setEnableCamera(true)
                .setEnableEdit(true)
                .setEnableCrop(true)
                .setEnableRotate(true)
                .setCropSquare(true)
                .setEnablePreview(true)
                .build();


        Utils.init(this);

        //初始化数据库
        DB.init(Room.databaseBuilder(this , AppDataBase.class , "by_doctor").build());



        //初始化个推
//        ByPushManager.getInstance().registerPushCallBack(LoginPushCallBack.class , new LoginPushCallBack());
//        ByPushManager.getInstance().initGeTui(this);
        //要在登录成功之后进行绑定

        String sdcard = Environment.getExternalStorageDirectory().getPath();
        File file = new File(sdcard + "/DCIM/");
        //配置imageloader
        GalleryImageLoader imageloader = new GalleryImageLoader();
        CoreConfig coreConfig = new CoreConfig.Builder(this, imageloader, theme)
                .setFunctionConfig(functionConfig)
                .setTakePhotoFolder(file)
                .build();
        GalleryFinal.init(coreConfig);
    }
}
