package com.byh.module.verlogin.callback;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.Log;

import androidx.core.app.NotificationCompat;
import androidx.core.view.ViewCompat;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.StringUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.kangxin.common.byh.db.DB;
import com.kangxin.common.byh.db.entity.ByPushEntity;
import com.kangxin.common.byh.entity.UpdateDataEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.global.PushCode;
import com.kangxin.common.byh.global.router.AppRouter;
import com.kangxin.common.byh.global.router.ByhimRouter;
import com.kangxin.common.byh.inter.IPushSaveCallback;
import com.kangxin.common.byh.provider.IImMsgHandlerProvider;
import com.kangxin.common.byh.provider.AppIntentProvider;
import com.kangxin.common.byh.service.OffLineService;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.umeng.message.PushAgent;
import com.umeng.message.entity.UMessage;

import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

import java.util.Date;

import com.kangxin.push.config.IPushCallback;

import static android.app.PendingIntent.FLAG_UPDATE_CURRENT;
import static android.content.Context.NOTIFICATION_SERVICE;
import static com.kangxin.common.byh.global.PushCode.AGREE_FRIEND_APPLY;
import static com.kangxin.common.byh.global.PushCode.CONSU_PUSH_106;
import static com.kangxin.common.byh.global.PushCode.APPLY_REFUNDED_DOCTOR_ACTION_CODE;
import static com.kangxin.common.byh.global.PushCode.DELETE_FRIEND;
import static com.kangxin.common.byh.global.PushCode.EXAMINE_FAILED;
import static com.kangxin.common.byh.global.PushCode.EXAMINE_PASS;
import static com.kangxin.common.byh.global.PushCode.FOLLOW_UP_ACTION_CODE;
import static com.kangxin.common.byh.global.PushCode.FOLLOW_UP_CREATE_LIST;
import static com.kangxin.common.byh.global.PushCode.HEALTHY_MANAGE;
import static com.kangxin.common.byh.global.PushCode.HT_ASSISTANT_CHECK;
import static com.kangxin.common.byh.global.PushCode.NOTICE_TYPE;
import static com.kangxin.common.byh.global.PushCode.OFFLINE;
import static com.kangxin.common.byh.global.PushCode.PATIENTS_COME;
import static com.kangxin.common.byh.global.PushCode.PHOTO_ORDER_ACCEPT;
import static com.kangxin.common.byh.global.PushCode.SERVICE_PKG;
import static com.kangxin.common.byh.global.PushCode.VIDEO_ORDER_ACCEPT;
import static com.kangxin.common.byh.global.router.ByhimRouter.IMMAGHAND_PROVIDER;
import static com.kangxin.common.byh.global.PushCode.WAIT_TO_REVIEW_ACTION_CODE;
import static com.kangxin.common.byh.global.PushCode.WAIT_TO_REVIEW_DOCTOR_ACTION_CODE;

//推送通知栏 回调处理
@Route(path = IPushCallback.ROUTE_PUSH_PATH)
public class LoginPushCallBack implements IPushSaveCallback, IPushCallback {

    private static final String TAG = "LoginPushCallBack";

    private void dispatchPushCode(Context context, ByPushEntity byPushEntity) {
        Log.i(TAG, "dispatchPushCode: byPushEntity:" + byPushEntity);
        String pushCode = byPushEntity.getPushCode();
        String notifyType = byPushEntity.getNotifyType();

        Log.i(TAG, "dispatchPushCode: pushCode:" + pushCode);
        Log.i(TAG, "dispatchPushCode: notifyType:" + notifyType);

        PushAgent.getInstance(context).setNotificationOnForeground(true);
        if (!TextUtils.isEmpty(notifyType)) {
            switch (notifyType) {
                case OFFLINE:
                    String notifyUserId = byPushEntity.getUserId();

                    String localUserId = VertifyDataUtil.getInstance(context).getUserId();

                    Log.i(TAG, "dispatchPushCode: notifyUserId:" + notifyUserId + ", localUserId:" + localUserId);
                    if (!TextUtils.isEmpty(notifyUserId)) {
                        if (notifyUserId.equals(localUserId)) {
                            OffLineService offLineService = (OffLineService) ARouter.getInstance().build(ByhimRouter.OFFLINE_NOTIFY_ACTIVITY).navigation();
                            offLineService.startOffLineActivity();
                            PushAgent.getInstance(context).setNotificationOnForeground(true);
                            Log.i(TAG, "dispatchPushCode: OFFLINE");
                        } else {
                            Log.i(TAG, "dispatchPushCode: else notifyUserId===============");
                            PushAgent.getInstance(context).setNotificationOnForeground(false);
                        }
                    } else {
                        Log.i(TAG, "dispatchPushCode: notifyUserId is null=======");
                        PushAgent.getInstance(context).setNotificationOnForeground(false);
                    }
                    break;
            }
        }

        if (!TextUtils.isEmpty(pushCode)) {
            switch (pushCode) {
                case EXAMINE_PASS:
                case EXAMINE_FAILED:
                    //如果认证通过或者失败的话就更新状态以及个人信息
                    UpdateVerStatus.getInstance().updateDocDetailInfo(context, null);
                    Log.i(TAG, "dispatchPushCode: EXAMINE_FAILED");
                    break;
                case AGREE_FRIEND_APPLY:
                    //同意加好友
                    EventBus.getDefault().post(new ByhCommEvent.UpdateFriendsListEvent());
                    Log.i(TAG, "dispatchPushCode: AGREE_FRIEND_APPLY");
                    break;
                case DELETE_FRIEND:
                    //删除好友
                    String targetId = byPushEntity.getBusinessExtend();
                    EventBus.getDefault().post(new ByhCommEvent.UpdateFriendsListEvent(targetId));
                  IImMsgHandlerProvider msgHandlerProvider = (IImMsgHandlerProvider) ARouter.getInstance().build(IMMAGHAND_PROVIDER).navigation();

                  msgHandlerProvider.deleteFriend(byPushEntity.getSdkAccount(), new IImMsgHandlerProvider.ImHandlerCallback() {
                    @Override
                    public void onError(int code, @NotNull String desc) {

                    }

                    @Override
                    public void onSuccess() {
                      msgHandlerProvider.deleteConversation(byPushEntity.getSdkAccount());
                    }
                  });
                    Log.i(TAG, "dispatchPushCode: DELETE_FRIEND");
                    break;
              case VIDEO_ORDER_ACCEPT:
              case PHOTO_ORDER_ACCEPT:
                //接诊通知刷新列表
                EventBus.getDefault().post(new ByhCommEvent.UpdateTencConverListEvent());
                break;
            }
        }
    }

    @Override
    public boolean savePushEntity(Context context, ByPushEntity byPushEntity) {
        dispatchPushCode(context, byPushEntity);

        //过滤数据
        //系统公告，不进数据库
        if (NOTICE_TYPE.equals(byPushEntity.getPushCode())) {
            return true;
        }

        //数据库存储
        if (!StringUtils.isEmpty(byPushEntity.getPushKey())) {
            //先删除操作，在进行存储操作,相当于去重操作
            new Thread(new Runnable() {
                @Override
                public void run() {
                    DB.getInstance().pushDao().clearPushByPushKey(byPushEntity.getPushKey());
                    Long aLong = DB.getInstance().pushDao().savePush(byPushEntity);
                    if (aLong > 0) {
                        EventBus.getDefault().postSticky(new UpdateDataEntity());
//                        LogUtils.d("success save push entiy");
                    } else {
//                        LogUtils.e("entity push key have mulitity");
                    }
                }
            }).start();
        } else {
            LogUtils.e("push key is null , don't save push entity");
        }

        return true;
    }

    @Override
    public void init(Context context) {
    }

    @Override
    public void receiverMsg(Object object, Context context) {
        //这个没用了
    }

    @Override
    public void receiverNotifyMsg(Object object, Context context) {
        if (object instanceof UMessage) {//Umeng推送 没有走这个，不知道是干啥用的
            UMessage result = (UMessage) object;
            ByPushEntity pushEntity = ByPushEntity.parse(result);
            //实体判断,进入不同页面
            String businessType = pushEntity.getBusinessType();
            if (businessType != null) {
                //先启动首页,在启动页面
                ARouter.getInstance().build(AppRouter.MAIN_PAGE_URL).navigation();
                EventBus.getDefault().postSticky(pushEntity);
                EventBus.getDefault().post(new ByhCommEvent.ClickNotifyEvent());
            }
        }
    }

    @Override
    public boolean dealWithNotificationMessage(Context context, UMessage msg) {

      //将UM推送转换为自定义字段 坑的一批 乱定义字段
      ByPushEntity byPushEntity = ByPushEntity.parse(msg);
      if(CONSU_PUSH_106.equals(byPushEntity.getPushCode())){
        return true;
      }
        receiverMsg(msg, context);//无用代码
        Intent appIntent = null;
        NotificationManager manager = (NotificationManager) context.getSystemService(NOTIFICATION_SERVICE);
        AppIntentProvider appIntentProvider = (AppIntentProvider) ARouter.getInstance().build(AppRouter.APP_INTENT_PROVIDER).navigation();
        //将UM推送转换为自定义字段 坑的一批
        ByPushEntity pushEntity = ByPushEntity.parse(msg);
        //保存到数据库
        savePushEntity(context, pushEntity);
        int generateViewId = ViewCompat.generateViewId();
        String action = pushEntity.getActionCode();
        if (action != null) {// android ios 后台 历史原因使用不同code判断，服了
            if (action.equals(FOLLOW_UP_ACTION_CODE) ||
                    action.equals(FOLLOW_UP_CREATE_LIST) ||
                    action.equals(WAIT_TO_REVIEW_DOCTOR_ACTION_CODE) ||
                    action.equals(WAIT_TO_REVIEW_ACTION_CODE) ||
                    action.equals(APPLY_REFUNDED_DOCTOR_ACTION_CODE)||
                    action.equals(HEALTHY_MANAGE)|| //健康管理通知
                    action.equals(PATIENTS_COME)||
                    action.equals(HT_ASSISTANT_CHECK)
            ) {
                appIntent = appIntentProvider.getAppIntent(msg);
            }
        }

       String businessType = pushEntity.getBusinessType();
      if(businessType.equals(PushCode.HT_HLZH_502)||
        businessType.equals(PushCode.HT_HLZH_503)
        || businessType.equals(PushCode.HT_HLZH_504)
        || businessType.equals(PushCode.HT_HLZH_501)
        || businessType.equals(PushCode.HT_HLZH_505)){
          appIntent = appIntentProvider.getAppIntent(msg);
        }

        if (appIntent == null) {
            appIntent = context.getPackageManager().getLaunchIntentForPackage(context.getApplicationInfo().processName);
        }
        PendingIntent pendingIntent = PendingIntent.getActivity(context.getApplicationContext(), generateViewId, appIntent, FLAG_UPDATE_CURRENT);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationChannel mChannel = new NotificationChannel(context.getPackageName(), "name", NotificationManager.IMPORTANCE_LOW);
            manager.createNotificationChannel(mChannel);
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, context.getPackageName());
        builder.setTicker(msg.ticker);//通知首次出现在通知栏，带上升动画效果的
        builder.setAutoCancel(true);//点击后消失
        builder.setSmallIcon(R.mipmap.ic_launcher);//设置通知栏消息标题的头像
        builder.setDefaults(NotificationCompat.DEFAULT_SOUND);//设置通知铃声
        builder.setWhen(new Date().getTime()); //发送时间
        builder.setContentTitle(msg.title);//设置标题
        builder.setContentText(msg.text);//设置内容
        builder.setPriority(Notification.PRIORITY_HIGH); //设置该通知优先级
        builder.setContentIntent(pendingIntent);
        Notification build = builder.build();
        manager.notify(generateViewId, build);
        LightTheScreen(context);
        try {
          palyMp3(context);
        }catch (Exception e){
          return true;
        }finally {

        }
        return true;
    }

    @Override
    public boolean receiverLaunchApp(Object o, Context context) {
        return false;
    }


    public static  void palyMp3(Context context){
      synchronized(LoginPushCallBack.class){
        MediaPlayer mMediaPlayer=null;
        if (mMediaPlayer == null) {
          mMediaPlayer=MediaPlayer.create(context, R.raw.wx);
        }
        mMediaPlayer.start();
      }
    }

  /**
   * 点亮屏幕
   */
  public static void LightTheScreen(Context context){
    //点亮屏幕
    PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
    PowerManager.WakeLock wl = pm.newWakeLock(PowerManager.ACQUIRE_CAUSES_WAKEUP |
      PowerManager.SCREEN_BRIGHT_WAKE_LOCK, "bright");
    wl.acquire();
    wl.release();
  }
}
