package com.byh.module.verlogin.event.vertify;

import android.app.Activity;
import android.util.Log;

import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.VerStatusManager;
import com.kangxin.common.byh.global.router.AppRouter;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.util.StringsUtils;

import static com.kangxin.common.byh.global.Global.OPEN_ID_KEY;
import static com.kangxin.common.byh.global.Global.UNIONID_KEY;
import static com.kangxin.common.byh.global.VertifyStatus.AUTH_AGAIN;
import static com.kangxin.common.byh.global.VertifyStatus.AUTH_FAILED;
import static com.kangxin.common.byh.global.VertifyStatus.AUTH_ING;
import static com.kangxin.common.byh.global.VertifyStatus.ENABELD;

public class WeChatStatusManager extends VerStatusManager<Activity> {
    private static final String TAG = "WeChatStatusManager";

    public WeChatStatusManager(Activity mExpandmember) {
        super(mExpandmember);
    }

    @Override
    public void verEnabled() {

        Log.i(TAG, "==verEnabled==");
        VertifyDataUtil.getInstance(mExpandmember.getApplicationContext()).setVertifyStatus(ENABELD);
        ARouter.getInstance().build(AppRouter.MAIN_PAGE_URL).navigation();
        UpdateVerStatus.getInstance().updateImToken(mExpandmember.getBaseContext());

        mExpandmember.finish();
    }

    @Override
    public void verDisAbled() {
        ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_zhanghuyitingyong));
    }

    @Override
    public void verUnAuth() {
//        ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_xitonghaiweirenzhengciyonghu));
//        VertifyDataUtil.getInstance(mExpandmember.getApplicationContext()).setVertifyStatus(UN_AUTH);
//        ARouter.getInstance().build(MAIN_PAGE_URL).navigation();
        ARouter.getInstance().build(VerloginRouter.PERSON_INFO).navigation();
        mExpandmember.finish();
    }

    @Override
    public void verAuthIng() {
        ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_renzhengshenhezhong_qingnaixindengdai));
        VertifyDataUtil.getInstance(mExpandmember.getApplicationContext()).setVertifyStatus(AUTH_ING);
        ARouter.getInstance().build(AppRouter.MAIN_PAGE_URL).navigation();
    }

    @Override
    public void verAuthFailed() {
        ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_yonghurenzhengweitongguo_qingdaogerenzhongxinjinxingzaicirenzheng));
        VertifyDataUtil.getInstance(mExpandmember.getApplicationContext()).setVertifyStatus(AUTH_FAILED);
        ARouter.getInstance().build(AppRouter.MAIN_PAGE_URL).navigation();

    }

    @Override
    public void verNoRegister() {

        LoginSuccess loginSuccess = VertifyDataUtil.getInstance(mExpandmember.getBaseContext())
                .getLoginData();

        ARouter.getInstance().build(VerloginRouter.BIND_WECHAT)
                .withString(OPEN_ID_KEY, loginSuccess.getOpenId())
                .withString(UNIONID_KEY,  loginSuccess.getUnionId())
                .navigation();
        mExpandmember.finish();
    }

    @Override
    public void verNoPersonInfo() {
        ARouter.getInstance().build(VerloginRouter.PERSON_INFO).navigation();
        mExpandmember.finish();
    }

    @Override
    public void verNoAuthInfo() {
        ARouter.getInstance().build(VerloginRouter.AUTHJOB_INFO).navigation();
        mExpandmember.finish();
    }

    @Override
    public void verUnUsed() {
        ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_linshizhuangtai));
    }

    @Override
    public void verNoExit() {
        ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_zhanghubucunzai));
    }

    @Override
    public void verAuthAgain() {
        VertifyDataUtil.getInstance(mExpandmember.getApplicationContext()).setVertifyStatus(AUTH_AGAIN);
        ARouter.getInstance().build(AppRouter.MAIN_PAGE_URL).navigation();
        mExpandmember.finish();
    }

    @Override
    public void verNoSetPwd() {
        ARouter.getInstance().build(VerloginRouter.PWD_SET).navigation();
    }
}
