package com.byh.module.verlogin.fragment;



import android.view.View;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.byh.module.verlogin.R;
import com.kangxin.common.byh.entity.SelZhicEntity;
import com.byh.module.verlogin.present.SelZhicPresent;
import com.byh.module.verlogin.view.ISelzhicView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.base.kt.BaseFragment;

import java.util.List;

/**
 * 选择职称
 */
public class SelZhicFragment extends BaseFragment implements ISelzhicView {

    private BaseQuickAdapter<SelZhicEntity, BaseViewHolder> mZhicListAdapter;
    private SelZhicPresent mSelZhicPresent;

    public static SelZhicFragment getInstance(){
        return new SelZhicFragment();
    }
    @Override
    public void init() {
        mSelZhicPresent = new SelZhicPresent(this);
        mSelZhicPresent.getSelZchicList(getContext());
    }

    private void setAdapter(){
        RecyclerView zhicRecycleView = findViewById(rootView, R.id.recycler_list);

        zhicRecycleView.setLayoutManager(new LinearLayoutManager(getContext()));

        mZhicListAdapter = new BaseQuickAdapter<SelZhicEntity, BaseViewHolder>(R.layout.zhic_list_item, mZhicList) {
            @Override
            protected void convert(BaseViewHolder helper, SelZhicEntity item) {
                helper.setText(R.id.zhic_name, item.getDicName());
                if (item.isSelected()){
                    helper.setImageResource(R.id.sel_img, R.drawable.ic_person_duihao);
                }else {
                    helper.setImageResource(R.id.sel_img, 0);
                }
            }
        };

        mZhicListAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                initList();
                mZhicList.get(position).setSelected(true);
                mDictEntity = mZhicList.get(position);
                mZhicListAdapter.notifyDataSetChanged();
            }
        });

        zhicRecycleView.setAdapter(mZhicListAdapter);
    }

    private SelZhicEntity mDictEntity;

    public SelZhicEntity getDictEntity() {
        return mDictEntity;
    }

    private void initList(){
        for (int i=0; i < mZhicList.size(); i++){
            mZhicList.get(i).setSelected(false);
        }
    }

    @Override
    public void showErr(String msg) {
        showShortToast(msg);
    }

    private List<SelZhicEntity> mZhicList;
    @Override
    public void showZhicList(List<SelZhicEntity> selZhicEntityResponseBody) {
        mZhicList = selZhicEntityResponseBody;
        setAdapter();
    }



    @Override
    protected int getLayoutId() {
        return R.layout.recycler_list_layout;
    }
}
