package com.byh.module.verlogin.fragment;

import android.annotation.SuppressLint;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import com.bigkoo.pickerview.builder.OptionsPickerBuilder;
import com.bigkoo.pickerview.listener.OnOptionsSelectListener;
import com.bigkoo.pickerview.view.OptionsPickerView;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.AddDeptEntity;
import com.byh.module.verlogin.entity.AddHospitalEntity;
import com.byh.module.verlogin.entity.AllRegionEntity;
import com.byh.module.verlogin.present.AddHospitalPresent;
import com.byh.module.verlogin.present.ProvinceCityAreaPresent;
import com.byh.module.verlogin.view.AddHospitalView;
import com.byh.module.verlogin.view.ProvinceCityAreaView;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.entity.DepartmentEntity;
import com.kangxin.common.byh.entity.MenuDepartmentList;
import com.kangxin.common.byh.entity.VerHospitalListEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.util.common.VerifyUtil;

import org.greenrobot.eventbus.EventBus;

import java.util.ArrayList;
import java.util.List;

import static com.kangxin.doctor.libdata.http.api.Api.DEPT_FIRST_ID;
import static com.kangxin.doctor.libdata.http.api.Api.DEPT_FIRST_NAME;
import static com.kangxin.doctor.libdata.http.api.Api.DEPT_SECOND_ID;
import static com.kangxin.doctor.libdata.http.api.Api.DEPT_SECOND_NAME;
import static com.kangxin.doctor.libdata.http.api.Api.HOSPITAL_ID;
import static com.kangxin.doctor.libdata.http.api.Api.OTHER_ID_HOS;
import static com.kangxin.doctor.libdata.http.api.Api.OTHER_KESHI_KEY;

public class SetHosNameFragment extends BaseFragment implements AddHospitalView , ProvinceCityAreaView {

    private static final String TAG = "SetHosNameFragment";
    private EditText mHospitalNameEdt;

    private AddHospitalPresent mAddHosPresent;
    private long mHosId = -1L;
    private int mKeshiFirstId = -1;
    private String mKeshiFirstName = null;
    private int mKeshiSecondId = -1;
    private String mKeshiSecondName = null;
    private MenuDepartmentList mMenuDeptment = null;
    private DepartmentEntity mDeptmentEntity = null;
    private int mKeshiId;
    private TextView mHosTitleView;
    private ProvinceCityAreaPresent mProvinceCityAreaPresent;

    public static SetHosNameFragment newInstance(){
        return new SetHosNameFragment();
    }
    @Override
    public void init() {
        mHosTitleView = findViewById(rootView, R.id.hos_title);
        mHospitalNameEdt = findViewById(rootView, R.id.edt_hosname);

        mKeshiId = getArguments().getInt(OTHER_KESHI_KEY);

        if (mKeshiId == OTHER_ID_HOS){

            mHosTitleView.setText(StringsUtils.getString(R.string.verlogin_keshimingcheng));
            mHospitalNameEdt.setHint(StringsUtils.getString(R.string.verlogin_qingshurukeshimingcheng));
            mMenuDeptment = new MenuDepartmentList();
            mDeptmentEntity = new DepartmentEntity();

            mHosId = getArguments().getLong(HOSPITAL_ID);
            mKeshiFirstId = getArguments().getInt(DEPT_FIRST_ID);
            mKeshiFirstName = getArguments().getString(DEPT_FIRST_NAME);
            mKeshiSecondId = getArguments().getInt(DEPT_SECOND_ID);
            mKeshiSecondName = getArguments().getString(DEPT_SECOND_NAME);

            Log.i(TAG, "mKeshiFirstId:" + mKeshiFirstId + ", mKeshiFirstName:" + mKeshiFirstName);
            Log.i(TAG, "mKeshiSecondId:" + mKeshiSecondId + ", mKeshiSecondName:" + mKeshiSecondName);

            mMenuDeptment.setId(mKeshiFirstId);
            mMenuDeptment.setDisplayName(mKeshiFirstName);
            mDeptmentEntity.setStdSecondDepId(mKeshiSecondId);
            mDeptmentEntity.setStandardSecondDepName(mKeshiSecondName);
            findViewById(rootView, R.id.ll_docaddress).setVisibility(View.GONE);
        }else {
            findViewById(rootView, R.id.ll_docaddress).setVisibility(View.VISIBLE);

            mProvinceCityAreaPresent = new ProvinceCityAreaPresent(this);
            mProvinceCityAreaPresent.reqRegionProvinceCityArea();

            mDocProAddrView = findViewById(rootView, R.id.txt_hosname);

            mDocProAddrView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    showPrincePicker();
                }
            });
        }

        mAddHosPresent = new AddHospitalPresent(this);

        findViewById(rootView, R.id.btn_save).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clickSave();

            }
        });


    }

    private TextView mDocProAddrView;

    private ArrayList<ArrayList<String>> options2Items = new ArrayList<>();
    private ArrayList<ArrayList<ArrayList<String>>> options3Items = new ArrayList<>();
    private String mRegionId;

    /**
     * 显示省市区的弹出框
     */
    private void showPrincePicker(){

        if (mAllRegionList == null){
            showShortToast(StringsUtils.getString(R.string.verlogin_weihuoqudaoshengshiqushuju));
            return;
        }

        @SuppressLint("ResourceAsColor") OptionsPickerView optionsPickerView = new OptionsPickerBuilder(getContext(), new OnOptionsSelectListener() {
            @Override
            public void onOptionsSelect(int options1, int options2, int options3, View v) {

                String option1 = mAllRegionList.size() > 0 ? mAllRegionList.get(options1).getPickerViewText() : "";
                String option2 = options2Items.size() > 0
                        && options2Items.get(options1).size() > 0 ?
                        options2Items.get(options1).get(options2) : "";

                String option3 = options2Items.size() > 0
                        && options3Items.get(options1).size() > 0
                        && options3Items.get(options1).get(options2).size() > 0 ?
                        options3Items.get(options1).get(options2).get(options3) : "";
                mDocProAddrView.setText(option1 + option2 + option3);

                mRegionId = mAllRegionList.get(options1).getSubRegionVoList().get(options2)
                        .getSubRegionList().get(options3).getRegionId();



            }
        }).setTitleText(StringsUtils.getString(R.string.verlogin_chengshixuanze))
                .setDividerColor(Color.BLACK)
                .setCancelColor(Color.BLACK)
                .setSubmitColor(Color.BLACK)
                .setTextColorCenter(Color.BLACK) //设置选中项文字颜色
                .setContentTextSize(18)
                .setDividerColor(android.R.color.transparent)
                .build();

        optionsPickerView.setPicker(mAllRegionList, options2Items, options3Items);
        optionsPickerView.show();

    }

    @Override
    protected int getLayoutId() {
        return R.layout.set_hospital_fragment;
    }

    private String mHosName;
    public void clickSave(){
        mHosName = mHospitalNameEdt.getText().toString().toLowerCase();
        if (!TextUtils.isEmpty(mHosName)){
            if (mKeshiId == OTHER_ID_HOS){
                AddDeptEntity addDeptEntity = new AddDeptEntity();
                addDeptEntity.setName(mHosName);
                addDeptEntity.setHospitalId(mHosId);
                addDeptEntity.setStdFirstDepId(mKeshiFirstId);
                addDeptEntity.setStatus(1);

                int doctorId = VertifyDataUtil.getInstance(getContext()).getLoginUserId();
                mAddHosPresent.addHosDepartment(mHosName, (long)mKeshiFirstId, mHosId,
                        (long)doctorId);
            }else {
                AddHospitalEntity addHospitalEntity = new AddHospitalEntity();
                addHospitalEntity.setName(mHosName);
                int doctorId = VertifyDataUtil.getInstance(getContext()).getLoginUserId();

                if (TextUtils.isEmpty(mRegionId)){
                    showShortToast(StringsUtils.getString(R.string.verlogin_shengshiquxuanzeyouwu));
                    return;
                }

                mAddHosPresent.addHospitalInfo(mHosName, (long)doctorId, mRegionId);
            }

        }else {
            showShortToast(StringsUtils.getString(R.string.verlogin_qingtianxieyiyuan));
        }
    }

    @Override
    public boolean onBackPressedSupport() {
        return super.onBackPressedSupport();
    }

    @Override
    public void addHosOk(String hosCode) {

        if (TextUtils.isEmpty(hosCode)){
            showShortToast(StringsUtils.getString(R.string.verlogin_weihuoqudaoyiyuanid));
            return;
        }

        VerHospitalListEntity.PageDataBean pageDataBean = new VerHospitalListEntity.PageDataBean();
        pageDataBean.setName(mHosName);

        if (!VerifyUtil.isInteger(hosCode)){
            if (mKeshiId == OTHER_ID_HOS){
                showShortToast(StringsUtils.getString(R.string.verlogin_keshiidfeifa));
            }else {
                showShortToast(StringsUtils.getString(R.string.verlogin_yiyuanidfeifa));
            }
            return;
        }

        pageDataBean.setId((int) Float.parseFloat(hosCode));
        Log.i(TAG, "addHosOk===>" + hosCode);
        Log.i(TAG, "==name===>" + mHosName);

        if (mMenuDeptment != null && mDeptmentEntity != null){
            mDeptmentEntity.setName(mHosName);
            mDeptmentEntity.setId((int) Float.parseFloat(hosCode));
            EventBus.getDefault().post(new ByhCommEvent.KeshiEvent(mMenuDeptment, mDeptmentEntity));
        }else {
            EventBus.getDefault().post(pageDataBean);
        }
        getActivity().finish();

    }

    private List<AllRegionEntity> mAllRegionList;

    @Override
    public void bindProvinceCityAreas(List<AllRegionEntity> allRegionEntityList, ArrayList<ArrayList<String>> options2Items,
                                      ArrayList<ArrayList<ArrayList<String>>> options3Items) {
        mAllRegionList = allRegionEntityList;
        this.options2Items = options2Items;
        this.options3Items = options3Items;
    }
}
