package com.byh.module.verlogin.fragment;

import android.os.Handler;
import android.view.View;
import android.widget.EditText;

import com.byh.module.verlogin.R;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.Event;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

/**
 * 擅长领域
 */
public class ShanChlyFragment extends BaseFragment {

    EditText mShancLyEdt;
    @Override
    public void init() {
        mShancLyEdt = findViewById(rootView, R.id.shanc_lingy_edt);

        findViewById(rootView, R.id.save_btn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String shancDesc = getShancText();
                EventBus.getDefault().post(new Event.ShancName(shancDesc));
                getActivity().finish();
            }
        });
    }

    @Override
    protected int getLayoutId() {
        return R.layout.shanchh_ly_fragment;
    }

    public String getShancText(){
        return mShancLyEdt.getText().toString().trim();
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true)
    public void receiveSpecialityEvent(ByhCommEvent.SpecialityEvent specialityEvent){
        new Handler().postDelayed(() -> mShancLyEdt.setText(specialityEvent.getSpeciality()), 200);
    }
}
