package com.byh.module.verlogin.intercept;

import com.blankj.utilcode.util.Utils;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.global.ILoginCommon;
import com.kangxin.common.byh.present.impl.GlobalPresent;
import com.kangxin.common.byh.util.VertifyDataUtil;

import org.greenrobot.eventbus.EventBus;

import java.util.ArrayList;
import java.util.List;

import com.kangxin.push.PushManager;

import static com.kangxin.common.byh.global.VertifyStatus.ENABELD;

public class LoginCommonIntercept implements ILoginCommon {
  private static final String TAG = "LoginCommonIntercept";
  private static final List<Runnable> busBackList = new ArrayList<>();

  @Override
  public void loginOk() {
    EventBus.getDefault().postSticky(new ByhCommEvent.UpdateFriendsListEvent());
    EventBus.getDefault().post(new ByhCommEvent.UpdateWorktabAdapterEvent());
    EventBus.getDefault().postSticky(new ByhCommEvent.AcountCompuEvent());
    EventBus.getDefault().postSticky(new ByhCommEvent.ConnectImEvent());
    EventBus.getDefault().postSticky(new ByhCommEvent.ImConnectOkEvent());
    EventBus.getDefault().postSticky(new ByhCommEvent.UpdateConsuList());
    PushManager.start();
    UpdateVerStatus.getInstance().updateImToken(Utils.getApp());
    new GlobalPresent().reqOldAndNewNodes();


    int status = VertifyDataUtil.getInstance(Utils.getApp()).getAcountStatus();
    if (status == ENABELD) {
      for (Runnable item : busBackList) {
        item.run();
      }
    }
  }

  public static void regLoginSucBack(Runnable runnable) {
    busBackList.add(runnable);
  }

}
