package com.byh.module.verlogin.module.impl;

import com.byh.module.verlogin.api.VerLoginApi;
import com.byh.module.verlogin.entity.AllRegionEntity;
import com.byh.module.verlogin.entity.JobTitleEntity;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.entity.LogoutAccountReqEntity;
import com.byh.module.verlogin.entity.LogoutBody;
import com.byh.module.verlogin.entity.OccupationEntity;
import com.byh.module.verlogin.entity.PwdParam;
import com.byh.module.verlogin.entity.UpdatePhoneParam;
import com.byh.module.verlogin.entity.UserDevInfoEntity;
import com.byh.module.verlogin.entity.VerCodeEntity;
import com.byh.module.verlogin.entity.VertifyStatus;
import com.byh.module.verlogin.entity.WeixRespTokenEntity;
import com.byh.module.verlogin.module.IVerLoginModule;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BaseModel;
import com.kangxin.common.byh.ByConfiguration;
import com.kangxin.common.byh.entity.PersonInfoBody;
import com.kangxin.common.byh.entity.SelZhicEntity;
import com.kangxin.common.byh.entity.VerHospitalListEntity;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.req.SmsAuthReq;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.util.SchedulesSwitch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.reactivex.Observable;

public class VerLoginModule extends BaseModel implements IVerLoginModule {
    @Override
    public Observable<ResponseBody<LoginSuccess>> userLogin(Login login) {
        return createFitApi(VerLoginApi.class).userLogin(login)
                .compose(SchedulesSwitch.<ResponseBody<LoginSuccess>>applySchedulers());
    }

    @Override
    public Observable<ResponseBody> doctorAddInfoCheck(String doctorId, String organId) {
        return createFitApi(VerLoginApi.class).doctorAddInfoCheck(doctorId, organId)
                .compose(SchedulesSwitch.<ResponseBody>applySchedulers());
    }


    @Override
    public Observable<ResponseBody<VerCodeEntity>> sendVertifyCode(String mobileNumber) {
        return createFitApi(VerLoginApi.class)
                .sendVertifyCode(mobileNumber)
                .compose(SchedulesSwitch.<ResponseBody<VerCodeEntity>>applySchedulers());
    }

    /**
     * 获得登录认证的状态
     *
     * @param phone
     * @return
     */
    @Override
    public Observable<ResponseBody<VertifyStatus>> getStatus(String phone) {
        return createFitApi(VerLoginApi.class).getStatus(phone)
                .compose(SchedulesSwitch.<ResponseBody<VertifyStatus>>applySchedulers());
    }


    /**
     * 设置密码
     *
     * @param login {
     *              "accountNo": "18012345678",
     *              "channelCode": "DOCTOR_ANDROID",
     *              "password": "123456"
     *              }
     * @return
     */
    @Override
    public Observable<ResponseBody<LoginSuccess>> setPassword(Login login) {
        return createFitApi(VerLoginApi.class).setPassword(login)
                .compose(SchedulesSwitch.applySchedulers());
    }

    /**
     * 保存个人信息
     *
     * @param personInfoBody
     * @return
     */
    @Override
    public Observable<ResponseBody<LoginSuccess>> savePersonInfo(String token, PersonInfoBody personInfoBody) {
        return createFitApi(VerLoginApi.class).savePersonInfo(token, personInfoBody)
                .compose(SchedulesSwitch.applySchedulers());
    }


    /**
     * 更新个人认证信息
     *
     * @param reqWebBody {
     *                   "accountId": 0,
     *                   "badgeUrl": "string",
     *                   "headImageUrl": "string",
     *                   "idCardBack": "string",
     *                   "idCardFront": "string"
     *                   }
     * @return
     */
    @Override
    public Observable<ResponseBody<LoginSuccess>> updateCertified(String token, ReqWebBody reqWebBody) {
        return createFitApi(VerLoginApi.class).updateCertified(token, reqWebBody)
                .compose(SchedulesSwitch.applySchedulers());
    }


    /**
     * 个人信息认证-获取医院列表
     *
     * @param searchParam
     * @param distCode
     * @param page
     * @param size
     * @return
     */
    @Override
    public Observable<ResponseBody<VerHospitalListEntity>> getVerHospitalList(Long doctorId,
                                                                              Integer page,
                                                                              Integer size,
                                                                              String searchParam,
                                                                              String distCode) {
        return createFitApi(VerLoginApi.class).getVerHospitalList(doctorId, page, size, searchParam,
                distCode)
                .compose(SchedulesSwitch.<ResponseBody<VerHospitalListEntity>>applySchedulers());
    }

    /**
     * 通过验证码登录
     *
     * @param login
     * @return
     */
    @Override
    public Observable<ResponseBody<LoginSuccess>> loginByVercode(Login login) {
        return createFitApi(VerLoginApi.class)
                .loginByVercode(login)
                .compose(SchedulesSwitch.applySchedulers());
    }

    /**
     * 更新用户设备信息
     *
     * @param userDevInfoEntity
     * @return
     */
    @Override
    public Observable<ResponseBody> updateUserDeviceInfo(UserDevInfoEntity userDevInfoEntity) {
        return createFitApi(VerLoginApi.class)
                .updateUserDeviceInfo(userDevInfoEntity)
                .compose(SchedulesSwitch.applySchedulers());
    }


    /**
     * 添加医院
     *
     * @param hospitalName
     * @return
     */
    @Override
    public Observable<ResponseBody> addHospitalInfo(String hospitalName, Long doctorId, String distCode) {
        return createFitApi(VerLoginApi.class)
                .addHospitalInfo(hospitalName, doctorId, distCode)
                .compose(SchedulesSwitch.applySchedulers());
    }

    /**
     * 添加科室
     *
     * @param
     * @return
     */
    @Override
    public Observable<ResponseBody> addHosDepartment(String departmentName,
                                                     Long stdFirstDepId,
                                                     Long hospitalId,
                                                     Long doctorId) {
        return createFitApi(VerLoginApi.class)
                .addHosDepartment(departmentName, stdFirstDepId, hospitalId, doctorId)
                .compose(SchedulesSwitch.applySchedulers());
    }

    /**
     * 退出app
     * <<<<<<< HEAD
     *
     * @param body =======
     *             >>>>>>> sign_account_br
     * @return
     */
    @Override
    public Observable<ResponseBody> exitApp(LogoutBody body) {
        return createFitApi(VerLoginApi.class)
                .exitApp(body)
                .compose(SchedulesSwitch.applySchedulers());
    }

    /**
     * 账号注销
     *
     * @param
     * @return
     */
    @Override
    public Observable<ResponseBody> cancelAppAccount(LogoutAccountReqEntity logoutAccountReqEntity) {
        return createFitApi(VerLoginApi.class)
                .cancelAppAccount(logoutAccountReqEntity)
                .compose(SchedulesSwitch.applySchedulers());
    }

    /**
     * 发送验证码
     *
     * @param phoneNum
     * @return
     */
    @Override
    public Observable<ResponseBody<LoginSuccess>> sendSmsAuthCode(String phoneNum) {
//        SmsSendAuthCodeReq smsSendAuthCodeReq = new SmsSendAuthCodeReq();
//        SmsSendAuthCodeReq.TelBean telBean = new SmsSendAuthCodeReq.TelBean();
//        telBean.setMobile(phoneNum);
//        smsSendAuthCodeReq.setTel(telBean);
//        smsSendAuthCodeReq.setTemplateCode("");

        SmsAuthReq smsAuthReq = new SmsAuthReq();
        smsAuthReq.setPhone(phoneNum);
        smsAuthReq.setSmsAppCode("EHOS_BYH");
        smsAuthReq.setTemplateCode("SMS_112470358");
        smsAuthReq.setUserType("1");
        smsAuthReq.setAppSdkType("ali");
        String appCode = ByConfiguration.getPlatformCode();
        smsAuthReq.setAppCode(appCode);
        return createFitApi(VerLoginApi.class)
                .sendSmsAuthCode(smsAuthReq)
                .compose(SchedulesSwitch.applySchedulers());
    }


    /**
     * 完善医生资质
     *
     * @param token
     * @param reqWebBody {
     *                   "accountId": "1564315641231",
     *                   "badgeUrl": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "channelCode": "DOCTOR_ANDROID",
     *                   "headImageUrl": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "idCardBack": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "idCardFront": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg"
     *                   }
     * @return
     */
    @Override
    public Observable<ResponseBody<LoginSuccess>> saveCertifyInfo(String token, ReqWebBody reqWebBody) {
        return createFitApi(VerLoginApi.class)
                .saveCertifyInfo(token, reqWebBody)
                .compose(SchedulesSwitch.applySchedulers());
    }

    /**
     * 修改密码
     *
     * @param login {
     *              "accountId": "string",
     *              "authKey": "string",
     *              "channelCode": "DOCTOR_ANDROID",
     *              "code": "string",
     *              "password": "string",
     *              "passwordNew": "string",
     *              "type": "1短信校验修改、2原密码校验修改"
     *              }
     * @return
     */
    @Override
    public Observable<ResponseBody<LoginSuccess>> updatePassword(Login login) {
        return createFitApi(VerLoginApi.class)
                .updatePassword(login)
                .compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<LoginSuccess>> loginByWeixin(Login login) {
        login.setAppIdType(ByConfiguration.getAppIdType());
        return createFitApi(VerLoginApi.class)
                .loginByWeixin(login)
                .compose(SchedulesSwitch.applySchedulers());
    }

    /**
     * 获取职称列表
     *
     * @param accessToken
     * @param reqWebBody  {
     *                    "channelCode": "DOCTOR_ANDROID",
     *                    "code": "01",
     *                    "type": "gender"
     *                    }
     * @return
     */
    @Override
    public Observable<ResponseBody<List<SelZhicEntity>>> findProfessionalList(String accessToken, ReqWebBody reqWebBody) {
        return createFitApi(VerLoginApi.class)
                .findProfessionalList(accessToken, reqWebBody)
                .compose(SchedulesSwitch.applySchedulers());
    }


    /**
     * 重置登录密码
     *
     * @param requestBody {
     *                    "accountNo": "string",
     *                    "channelCode": "DOCTOR_ANDROID",
     *                    "password": "string"
     *                    }
     * @return
     */
    public Observable<ResponseBody<LoginSuccess>> setForgetResetPwdPersonInfo(ReqWebBody requestBody) {
        return createFitApi(VerLoginApi.class)
                .setForgetResetPwdPersonInfo(requestBody)
                .compose(SchedulesSwitch.applySchedulers());
    }


    /**
     * 验证短信验证码
     *
     * @param reqWebBody {
     *                   "authCode": "验证码",
     *                   "authKey": "每条短信的唯一key，发送时会返回"
     *                   }
     * @return
     */
    @Override
    public Observable<ResponseBody> validatePhoneAndCode(ReqWebBody reqWebBody) {
        return createApi2(VerLoginApi.class)
                .validatePhoneAndCode(reqWebBody)
                .compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<List<AllRegionEntity>>> reqRegionProvinceCityArea() {
        return createFitApi(VerLoginApi.class)
                .reqRegionProvinceCityArea();
    }

    @Override
    public Observable<ResponseBody<LoginSuccess>> reqWeixToken(String code) {
        ReqWebBody reqWebBody = new ReqWebBody();
        reqWebBody.setAppIdType(ByConfiguration.getAppIdType());
        reqWebBody.setCode(code);
        return createFitApi(VerLoginApi.class)
                .reqWeixToken(reqWebBody)
                .compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<WeixRespTokenEntity>> resHasBindWeix(String unionId) {
        return createFitApi(VerLoginApi.class)
                .resHasBindWeix(unionId)
                .compose(SchedulesSwitch.applySchedulers());
    }


    /**
     * 绑定微信
     *
     * @param reqWebBody {
     *                   "authKey": "authKey",
     *                   "channelCode": "DOCTOR_ANDROID",
     *                   "code": "123456",
     *                   "loginDeviceNum": "236511321231441",
     *                   "loginDeviceType": "APP",
     *                   "mobileNumber": "18888888888",
     *                   "openId": "123456",
     *                   "unionId": "123456"
     *                   }
     * @return
     */
    @Override
    public Observable<ResponseBody<LoginSuccess>> reqBindWeChat(ReqWebBody reqWebBody) {
        reqWebBody.setAppIdType(ByConfiguration.getAppIdType());
        return createFitApi(VerLoginApi.class)
                .reqBindWeChat(reqWebBody)
                .compose(SchedulesSwitch.applySchedulers());
    }

    /**
     * 获取医生职业
     */
    @Override
    public Observable<ResponseBody<List<OccupationEntity>>> getOccupation() {
        return createFitApi(VerLoginApi.class)
                .getOccupation()
                .compose(SchedulesSwitch.applySchedulers());
    }

    /**
     * 获取医生职称
     */
    @Override
    public Observable<ResponseBody<List<JobTitleEntity>>> getJobTitle(String dicCode) {
        return createFitApi(VerLoginApi.class)
                .getJobTitle(dicCode)
                .compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody> setSiguUP(Map<String, String> Map) {
        return createFitApi(VerLoginApi.class)
                .setSiguUP(Map)
                .compose(SchedulesSwitch.applySchedulers());
    }

  @Override
  public Observable<ResponseBody<Object>> updateNewPhoneNum(UpdatePhoneParam updatePhone) {
    return createFitApi(VerLoginApi.class)
      .updateNewPhoneNum(updatePhone)
      .compose(SchedulesSwitch.applySchedulers());
  }

  @Override
  public Observable<ResponseBody<Object>> checkPwdForNewPhoneNum(PwdParam pwd) {
    return createFitApi(VerLoginApi.class)
      .checkPwdForNewPhoneNum(pwd)
      .compose(SchedulesSwitch.applySchedulers());
  }
}
