package com.byh.module.verlogin.present;


import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.IForgetSendVercodeView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.common.widget.RxProgressObserver;

public class ForgetSendVerifyCodePersent {

    private IForgetSendVercodeView mIForgetSendVercodeView;
    private VerLoginModule     mVerLoginModule;

    public ForgetSendVerifyCodePersent(IForgetSendVercodeView iForgetSendVercodeView) {
        this.mIForgetSendVercodeView = iForgetSendVercodeView;
        mVerLoginModule = new VerLoginModule();
    }

    public void receiveByVercode(String phoneNum){

        mVerLoginModule.sendSmsAuthCode(phoneNum)
                .subscribe(new RxProgressObserver<ResponseBody<LoginSuccess>>() {
                    @Override
                    public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                        ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_fasongchenggong));
                        mIForgetSendVercodeView.receiveResult(loginSuccessResponseBody.getResult());
                    }
                });

    }
}
