package com.byh.module.verlogin.present;

import android.content.Context;

import com.byh.module.verlogin.entity.AllRegionEntity;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.ProvinceCityAreaView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.common.util.SchedulesSwitch;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.functions.Function;

public class ProvinceCityAreaPresent {
    private VerLoginModule mLoginModule;

    private ProvinceCityAreaView mProvinceCityAreaView;

    public ProvinceCityAreaPresent(ProvinceCityAreaView provinceCityAreaView) {
        this.mProvinceCityAreaView = provinceCityAreaView;

        mLoginModule = new VerLoginModule();
    }

    public void reqRegionProvinceCityArea(){

        mLoginModule.reqRegionProvinceCityArea()
                .map(new Function<ResponseBody<List<AllRegionEntity>>, ProvinceData>() {
                    @Override
                    public ProvinceData apply(ResponseBody<List<AllRegionEntity>> listResponseBody) throws Exception {
                        ArrayList<ArrayList<String>> options2Items = new ArrayList<>();
                        ArrayList<ArrayList<ArrayList<String>>> options3Items = new ArrayList<>();
                        List<AllRegionEntity> allRegionEntityList = listResponseBody.getResult();

                        for (AllRegionEntity allRegionEntity : allRegionEntityList){ //遍历省份
                            ArrayList<String> cityList = new ArrayList<>();//该省的城市列表（第二级）
                            ArrayList<ArrayList<String>> provinceAreaList = new ArrayList<>();//该省的所有地区列表（第三极）

                            for (AllRegionEntity.SubRegionVoListBean subRegionVoListBean :
                                    allRegionEntity.getSubRegionVoList()){
                                cityList.add(subRegionVoListBean.getParentRegion().getRegionName());

                                ArrayList<String> areaList = new ArrayList<>();
                                for (AllRegionEntity.SubRegionVoListBean.SubRegionListBean subRegionListBean :
                                        subRegionVoListBean.getSubRegionList()){
                                    areaList.add(subRegionListBean.getRegionName());
                                }

                                provinceAreaList.add(areaList);
                            }

                            options2Items.add(cityList);
                            options3Items.add(provinceAreaList);
                        }


                        ProvinceData provinceData = new ProvinceData();
                        provinceData.setAllRegionEntityList(allRegionEntityList);
                        provinceData.setOptions2Items(options2Items);
                        provinceData.setOptions3Items(options3Items);
                        return provinceData;
                    }
                }).compose(SchedulesSwitch.applySchedulers())
                .subscribe(new ProgressDialogObserver<ProvinceData>() {
                    @Override
                    public void onNext(ProvinceData provinceData) {
                        if (provinceData != null){
                            mProvinceCityAreaView.bindProvinceCityAreas(provinceData.getAllRegionEntityList(),
                                    provinceData.getOptions2Items(), provinceData.getOptions3Items());
                        }
                    }

                    @Override
                    protected Context attachContext() {
                        return mProvinceCityAreaView.injectContext();
                    }
                });
    }

    class ProvinceData{
        private List<AllRegionEntity> allRegionEntityList;
        private ArrayList<ArrayList<String>> options2Items;
        private ArrayList<ArrayList<ArrayList<String>>> options3Items;

        public List<AllRegionEntity> getAllRegionEntityList() {
            return allRegionEntityList;
        }

        public void setAllRegionEntityList(List<AllRegionEntity> allRegionEntityList) {
            this.allRegionEntityList = allRegionEntityList;
        }

        public ArrayList<ArrayList<String>> getOptions2Items() {
            return options2Items;
        }

        public void setOptions2Items(ArrayList<ArrayList<String>> options2Items) {
            this.options2Items = options2Items;
        }

        public ArrayList<ArrayList<ArrayList<String>>> getOptions3Items() {
            return options3Items;
        }

        public void setOptions3Items(ArrayList<ArrayList<ArrayList<String>>> options3Items) {
            this.options3Items = options3Items;
        }
    }
}
