package com.byh.module.verlogin.present;

import android.content.Context;

import com.kangxin.common.byh.entity.SelZhicEntity;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.ISelzhicView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.RxProgressObserver;

import java.util.List;

public class SelZhicPresent {
    private VerLoginModule mLoginModule;
    private ISelzhicView mSelzhicView;

    public SelZhicPresent(ISelzhicView mSelzhicView) {
        this.mSelzhicView = mSelzhicView;
        mLoginModule = new VerLoginModule();
    }

    public void getSelZchicList(Context context){

        String token = VertifyDataUtil.getInstance(context).getToken();
        ReqWebBody reqWebBody = new ReqWebBody();
        reqWebBody.setType("100");
        mLoginModule.findProfessionalList(token, reqWebBody)
                .subscribe(new RxProgressObserver<ResponseBody<List<SelZhicEntity>>>() {
                    @Override
                    public void onReqNext(ResponseBody<List<SelZhicEntity>> listResponseBody) {
                        mSelzhicView.showZhicList(listResponseBody.getData());
                    }
                });
    }
}

