package com.byh.module.verlogin.present;

import android.content.Context;

import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.present.inter.IValidatePhoneCodePresent;
import com.byh.module.verlogin.view.IValidatePhoneAndCodeView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxBaseObserver;
import com.kangxin.common.widget.RxProgressObserver;

import io.reactivex.Observable;

public class ValidatePhoneAndCodePresent implements IValidatePhoneCodePresent {

    private IValidatePhoneAndCodeView mValidatePhoneAndCodeView;
    private VerLoginModule mVerloginModule;

    public ValidatePhoneAndCodePresent(IValidatePhoneAndCodeView validatePhoneAndCodeView) {
        this.mValidatePhoneAndCodeView = validatePhoneAndCodeView;
        mVerloginModule = new VerLoginModule();
    }

    @Override
    public void getValidatePhoneCodePresenter(String code,String authKey, boolean isShowLoading) {

        ReqWebBody reqWebBody = new ReqWebBody();
        reqWebBody.setAuthCode(code);
        reqWebBody.setAuthKey(authKey);

        if (isShowLoading){
            mVerloginModule.validatePhoneAndCode(reqWebBody)
                    .subscribe(new RxProgressObserver<ResponseBody>() {
                        @Override
                        public void onReqNext(ResponseBody responseBody) {
                            mValidatePhoneAndCodeView.getValidatePhoneAndCodeOk(responseBody);
                        }
                    });
        }else {
            mVerloginModule.validatePhoneAndCode(reqWebBody)
                    .subscribe(new RxBaseObserver<ResponseBody>() {
                        @Override
                        public void onReqNext(ResponseBody responseBody) {
                            mValidatePhoneAndCodeView.getValidatePhoneAndCodeOk(responseBody);
                        }

                        @Override
                        public void onError(Throwable e) {

                        }

                        @Override
                        public void onComplete() {

                        }
                    });
        }

    }
}
