package com.byh.module.verlogin.present;

import android.content.Context;

import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.IVerHospitalListView;
import com.kangxin.common.byh.entity.RegionCtitiesEntity;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.VerHospitalListEntity;
import com.kangxin.common.byh.module.IGionCitiesModule;
import com.kangxin.common.byh.module.impl.GionCitiesModule;
import com.kangxin.common.rx.ProgressDialogObserver;

public class VerHospitalListPresent {
    private VerLoginModule mLoginModule;
    private IVerHospitalListView verHospitalListView;
    private IGionCitiesModule mCitiesModule;

    public VerHospitalListPresent(IVerHospitalListView verHospitalListView) {
        this.verHospitalListView = verHospitalListView;
        mLoginModule = new VerLoginModule();
        mCitiesModule = new GionCitiesModule();
    }

    /**
     * 请求获取医院的列表
     * @param searchParam 搜索参数
     * @param distCode 省市code
     * @param page 页码
     * @param size 一页显示的数量
     */
    public void reqHospitalList(Long doctorId,
                                Integer page,
                                Integer size,
                                String searchParam,
                                String distCode){


        mLoginModule.getVerHospitalList(doctorId, page, size, searchParam, distCode)
                .subscribe(new ProgressDialogObserver<ResponseBody<VerHospitalListEntity>>() {
                    @Override
                    public void onNext(ResponseBody<VerHospitalListEntity> hospitalListEntityResponseBody) {

                        if (hospitalListEntityResponseBody.getCode() != 200){
                            verHospitalListView.error(hospitalListEntityResponseBody.getMsg());
                            return;
                        }

                        verHospitalListView.showHospitalList(hospitalListEntityResponseBody);
                    }

                    @Override
                    protected Context attachContext() {
                        return verHospitalListView.injectContext();
                    }
                });
    }

    /**
     * 获得省市列表
     * @param fileName
     */
    public void getRegioCities(String fileName){

        mCitiesModule.getRegioCities(fileName)
                .subscribe(new ProgressDialogObserver<RegionCtitiesEntity>() {
                    @Override
                    public void onNext(RegionCtitiesEntity regionCtitiesEntity) {


                        if (regionCtitiesEntity.getCode() != 200){
                            verHospitalListView.error(regionCtitiesEntity.getMsg());
                            return;
                        }
                        verHospitalListView.showCities(regionCtitiesEntity.getResult());
                    }

                    @Override
                    protected Context attachContext() {
                        return verHospitalListView.injectContext();
                    }
                });
    }


}
