package com.byh.module.verlogin.present;

import android.content.Context;
import android.util.Log;

import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.intercept.RxLoginCommonObserver;
import com.byh.module.verlogin.module.IVerLoginModule;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.IWeixAuthView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.Event;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.util.common.DeviceIdUtil;

import org.greenrobot.eventbus.EventBus;

import com.kangxin.push.PushManager;


public class WeixAuthPresent {

    private IVerLoginModule mVerloginModule;
    private IWeixAuthView mWeixAuthView;

    private Context mContext;

    public WeixAuthPresent(Context context, IWeixAuthView weixAuthView) {
        mContext = context;
        mWeixAuthView = weixAuthView;
        this.mVerloginModule = new VerLoginModule();
    }

    public void reqWeixAuth(String code) {

        Login login = new Login();
        login.setLoginDeviceNum(PushManager.getDeviceId(mContext, DeviceIdUtil.getDeviceId(mContext)));
        login.setCode(code);

        mVerloginModule.loginByWeixin(login)
                .subscribe(new RxLoginCommonObserver<ResponseBody<LoginSuccess>>() {
                    @Override
                    public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                        LoginSuccess loginSuccess = loginSuccessResponseBody.getResult();
                        VertifyDataUtil.getInstance(mContext).setLoginData(loginSuccess);
                        mWeixAuthView.authOk(loginSuccess);
                        if (null != loginSuccessResponseBody.getData().getDoctorLoginInfo()) {
                            doctorzraddInfo(mContext, loginSuccessResponseBody.getData().getDoctorLoginInfo().getDoctorId(),
                                    loginSuccessResponseBody.getData().getDoctorLoginInfo().getOrganId());
                        }
                        super.onReqNext(loginSuccessResponseBody);
                    }
                });
    }

    public void doctorzraddInfo(Context context, String doctorId, String organId) {
        mVerloginModule.doctorAddInfoCheck(doctorId, organId)
                .subscribe(new RxProgressObserver<ResponseBody>() {
                    @Override
                    public void onReqNext(ResponseBody loginSuccessResponseBody) {
                        VertifyDataUtil.getInstance(context).setInfoCheck((Boolean) loginSuccessResponseBody.getData());
                        EventBus.getDefault().post(new Event.infoCheck((Boolean) loginSuccessResponseBody.getData()));
                        Log.e("Event.infoCheck---3",loginSuccessResponseBody.getData()+"");

                    }
                });
    }

}
