/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.SpanUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.LogoutAccountReqEntity;
import com.byh.module.verlogin.present.LogoutAccountPresent;
import com.byh.module.verlogin.view.ILogoutAccountView;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.service.IExitAppProvider;
import com.kangxin.common.byh.util.VertifyDataUtil;
import org.jetbrains.annotations.NotNull;

@Route(path="/login/account/AccountLogoutActivity")
public class AccountLogoutActivity
extends BaseActivity
implements IToolView,
ILogoutAccountView,
View.OnClickListener {
    private TextView vOkLogoutTv;
    private TextView vAccountNotesTv;
    private ImageView vCheckedImg;
    private boolean isSelected = false;
    private LogoutAccountPresent mLogoutAccountPresent = new LogoutAccountPresent(this);
    private IExitAppProvider mExitAppProvider = (IExitAppProvider)ARouter.getInstance().build("/AppRouter/exit/app/ExitAppProvider").navigation();

    public int getContentLayoutId() {
        return R.layout.activity_account_logout;
    }

    public void start() {
        this.vOkLogoutTv = (TextView)this.findViewById(R.id.vOkLogoutTv);
        this.vCheckedImg = (ImageView)this.findViewById(R.id.vCheckedImg);
        this.vAccountNotesTv = (TextView)this.findViewById(R.id.vAccountNotesTv);
        this.vOkLogoutTv.setOnClickListener(v -> {
            LogoutAccountReqEntity logoutAccountReqEntity = new LogoutAccountReqEntity();
            logoutAccountReqEntity.setAccountId(VertifyDataUtil.getInstance().getAccountId());
            logoutAccountReqEntity.setChannelCode("DOCTOR_ANDROID");
            logoutAccountReqEntity.setNeedCheckPw(false);
            this.mLogoutAccountPresent.logoutAppAccount(logoutAccountReqEntity);
        });
        this.vAccountNotesTv.setMovementMethod(LinkMovementMethod.getInstance());
        this.vAccountNotesTv.setText(this.createAgreedText());
        this.vAccountNotesTv.setHighlightColor(0);
        if (this.isSelected) {
            this.vCheckedImg.setImageResource(R.drawable.ic_by_read_tag_ok_icon);
            this.vOkLogoutTv.setClickable(true);
            this.vOkLogoutTv.setBackgroundResource(R.color.verlogin_color_FF5F5F);
        } else {
            this.vCheckedImg.setImageResource(R.drawable.ic_by_unread_tag_ok_icon);
            this.vOkLogoutTv.setClickable(false);
            this.vOkLogoutTv.setBackgroundResource(R.color.color_999999);
        }
        this.vCheckedImg.setOnClickListener((View.OnClickListener)this);
        this.vAccountNotesTv.setOnClickListener((View.OnClickListener)this);
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    @Override
    public void logoutAccountOk() {
        ToastUtils.showLong((CharSequence)StringUtils.getString((int)R.string.verlogin_account_logout_success_tips));
        new Handler().postDelayed(() -> {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mExitAppProvider.registerExitAppReceiver();
                this.mExitAppProvider.sendExitAppReceiver();
            } else {
                Intent intent = new Intent("com.kangxin.doctor.worktable.exitapp");
                this.sendBroadcast(intent);
            }
        }, 4000L);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mExitAppProvider != null) {
            this.mExitAppProvider.unRegisterExitAppReceiver();
        }
    }

    private CharSequence createAgreedText() {
        return new SpanUtils().append((CharSequence)StringUtils.getString((int)R.string.verlogin_woyiyuedubingtongyi)).append((CharSequence)StringUtils.getString((int)R.string.verlogin_zhanghaozhuxiaoxuzhi_)).setForegroundColor(Color.parseColor((String)"#3576E0")).create();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.vCheckedImg || v.getId() == R.id.vAccountNotesTv) {
            if (!this.isSelected) {
                this.isSelected = true;
                this.vCheckedImg.setImageResource(R.drawable.ic_by_read_tag_ok_icon);
                this.vOkLogoutTv.setClickable(true);
                this.vOkLogoutTv.setBackgroundResource(R.color.verlogin_color_FF5F5F);
            } else {
                this.isSelected = false;
                this.vCheckedImg.setImageResource(R.drawable.ic_by_unread_tag_ok_icon);
                this.vOkLogoutTv.setClickable(false);
                this.vOkLogoutTv.setBackgroundResource(R.color.color_999999);
            }
        }
    }

    public boolean initYm() {
        return false;
    }
}

