/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.CountDownTimer;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.byh.module.verlogin.ChangePhoneNewNumActivity;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.module.ChangePhoneViewModel;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;

public class ChangePhoneByCodeActivity
extends BaseActivity {
    private TextView tv_code;
    private EditText ed_code;
    private Button tv_next;
    private CountDownTimer timer;
    private ChangePhoneViewModel viewModel;
    private String codeKey = "";

    public int getContentLayoutId() {
        return R.layout.activity_change_phone_code;
    }

    public void start() {
        String mPhoneNum = this.getIntent().getStringExtra("phoneNum");
        String maskNumber = mPhoneNum.substring(0, 3) + "****" + mPhoneNum.substring(7, mPhoneNum.length());
        TextView tvP = (TextView)this.findViewById(R.id.tv_p);
        this.tv_code = (TextView)this.findViewById(R.id.tv_code);
        this.ed_code = (EditText)this.findViewById(R.id.et_code);
        this.tv_next = (Button)this.findViewById(R.id.code_next);
        tvP.setText((CharSequence)("\u901a\u8fc7+86 " + maskNumber + " \u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801"));
        this.tv_next.setClickable(false);
        this.viewModel = (ChangePhoneViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(ChangePhoneViewModel.class);
        this.tv_code.setOnClickListener(view -> this.sendCode(mPhoneNum));
        this.findViewById(R.id.vLeftImage).setOnClickListener(v -> {
            this.cancelCountDownTimer();
            this.finish();
        });
        this.tv_next.setOnClickListener(v -> {
            if (TextUtils.isEmpty((CharSequence)this.ed_code.getText().toString().trim()) || TextUtils.isEmpty((CharSequence)this.codeKey)) {
                this.showShortToast("\u9a8c\u8bc1\u7801\u9519\u8bef,\u8bf7\u91cd\u65b0\u83b7\u53d6");
                return;
            }
            this.checkCode();
        });
        this.ed_code.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @RequiresApi(api=16)
            public void afterTextChanged(Editable editable) {
                if (editable.length() == 6) {
                    ChangePhoneByCodeActivity.this.tv_next.setClickable(true);
                    ChangePhoneByCodeActivity.this.tv_next.setEnabled(true);
                    ChangePhoneByCodeActivity.this.tv_next.setTextColor(ChangePhoneByCodeActivity.this.getResources().getColor(R.color.white));
                    ChangePhoneByCodeActivity.this.tv_next.setBackground(ResourcesCompat.getDrawable((Resources)ChangePhoneByCodeActivity.this.getResources(), (int)R.drawable.vercode_order_bg, null));
                } else {
                    ChangePhoneByCodeActivity.this.tv_next.setClickable(false);
                    ChangePhoneByCodeActivity.this.tv_next.setEnabled(false);
                    ChangePhoneByCodeActivity.this.tv_next.setTextColor(ChangePhoneByCodeActivity.this.getResources().getColor(R.color.color_999999));
                    ChangePhoneByCodeActivity.this.tv_next.setBackground(ResourcesCompat.getDrawable((Resources)ChangePhoneByCodeActivity.this.getResources(), (int)R.drawable.bt_gray_order_bg, null));
                }
            }
        });
    }

    private void sendCode(String mPhoneNum) {
        this.viewModel.getCodeByPhone(mPhoneNum).observe((LifecycleOwner)this, (Observer)new Observer<String>(){

            public void onChanged(String s) {
                ChangePhoneByCodeActivity.this.codeKey = s;
                ChangePhoneByCodeActivity.this.isVercodeUsable(false);
                ChangePhoneByCodeActivity.this.starCountDownTimer();
            }
        });
    }

    private void checkCode() {
        this.viewModel.checkCode(this.ed_code.getText().toString().trim(), this.codeKey).observe((LifecycleOwner)this, (Observer)new Observer<ResponseBody>(){

            public void onChanged(ResponseBody responseBody) {
                if (responseBody.getCode() == 200) {
                    ChangePhoneByCodeActivity.this.showShortToast(responseBody.getMsg());
                    ChangePhoneByCodeActivity.this.startActivity(new Intent((Context)ChangePhoneByCodeActivity.this, ChangePhoneNewNumActivity.class));
                } else {
                    if (responseBody.getMsg().contains("\u5df2\u5931\u6548")) {
                        ChangePhoneByCodeActivity.this.showShortToast(responseBody.getMsg());
                    } else {
                        ChangePhoneByCodeActivity.this.showShortToast("\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
                    }
                    ChangePhoneByCodeActivity.this.codeKey = "";
                    ChangePhoneByCodeActivity.this.isVercodeUsable(true);
                    ChangePhoneByCodeActivity.this.cancelCountDownTimer();
                }
            }
        });
    }

    private void isVercodeUsable(boolean isUse) {
        if (isUse) {
            this.tv_code.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.vercode_order_bg, null));
            this.tv_code.setTextColor(this.getResources().getColor(17170443));
            this.tv_code.setClickable(true);
            this.tv_code.setFocusable(true);
            this.tv_code.setText(R.string.ver_getvercode);
        } else {
            this.tv_code.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.white_corner_bg, null));
            this.tv_code.setTextColor(this.getResources().getColor(0x1060000));
            this.tv_code.setText(R.string.ver_getvercode);
            this.tv_code.setClickable(false);
            this.tv_code.setFocusable(false);
        }
    }

    private void cancelCountDownTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    private void starCountDownTimer() {
        if (this.timer == null) {
            this.timer = new CountDownTimer(60000L, 1000L){

                public void onTick(long millisUntilFinished) {
                    ChangePhoneByCodeActivity.this.tv_code.setText((CharSequence)(millisUntilFinished / 1000L + "s"));
                }

                public void onFinish() {
                    ChangePhoneByCodeActivity.this.isVercodeUsable(true);
                    ChangePhoneByCodeActivity.this.cancelCountDownTimer();
                }
            };
            this.timer.start();
        }
    }

    public boolean initYm() {
        return false;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.cancelCountDownTimer();
    }
}

