/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.AgreementNoticeCountryActivity;
import com.byh.module.verlogin.PwdLoginActivity;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.callback.LoginPushCallBack;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.entity.VerCodeEntity;
import com.byh.module.verlogin.event.vertify.LoginDispatchStatus;
import com.byh.module.verlogin.event.vertify.ModuleManager;
import com.byh.module.verlogin.present.LoginByVercodePresent;
import com.byh.module.verlogin.present.VerLoginPresent;
import com.byh.module.verlogin.present.WeixAuthPresent;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.byh.module.verlogin.view.ILoginByCodeOkView;
import com.byh.module.verlogin.view.ILoginView;
import com.byh.module.verlogin.view.IWeixAuthView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.ByConfiguration;
import com.kangxin.common.byh.ByPlatform;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.present.IUpdatePresenter;
import com.kangxin.common.byh.present.impl.UpdatePresenter;
import com.kangxin.common.byh.provider.IPushAdProvider;
import com.kangxin.common.byh.service.IWeixLoginProvider;
import com.kangxin.common.byh.service.ImChatSerivice;
import com.kangxin.common.byh.util.CountDownUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.byh.widget.UserAgrrPrimary;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.push.PushManager;
import com.kangxin.push.config.Config;
import com.kangxin.push.config.IPushCallback;
import com.kangxin.util.common.DeviceIdUtil;
import com.kangxin.util.common.SPUtils;
import com.kangxin.util.common.VerifyUtil;
import com.kangxin.widget.common.byh.ZpPhoneEditText;
import org.greenrobot.eventbus.EventBus;

@Route(path="/VerloginRouter/verification/LoginActivity")
public class LoginActivity
extends BaseActivity
implements ILoginView,
ILoginByCodeOkView,
IWeixAuthView {
    private static final String TAG = "LoginActivity";
    ZpPhoneEditText mPhoneNumEdit;
    ImageView mClosePhoneNumImg;
    TextView mVercodeText;
    Button mLoginButton;
    EditText mVercodeEdt;
    ImageView mBackImg;
    TextView mErrNoticeText;
    private CountDownUtil mCountDownUtil;
    private VerLoginPresent mLoginPresent;
    private LoginByVercodePresent mLoginByVercodePresent;
    private WeixRespReceiver mWeixRespReceiver;
    private WeixAuthPresent mWeixAuthPresent;
    private IUpdatePresenter updatePresenter = new UpdatePresenter();
    private CheckBox mCheckBox;
    private IWeixLoginProvider mWeixLoginProvider;
    private String mVerCode;
    private VerCodeEntity mVerCodeEntity;

    @Override
    public void authOk(LoginSuccess loginSuccess) {
        this.updateUserInfo();
        this.receiveStatus(loginSuccess.getAccountStatus(), LoginFlag.WECHAT);
    }

    public boolean initYm() {
        return false;
    }

    private void registerWeixRespReceiver() {
        this.mWeixRespReceiver = new WeixRespReceiver();
        IntentFilter intentFilter = new IntentFilter("com.kangxin.doctor.receiver.action.resp");
        this.registerReceiver(this.mWeixRespReceiver, intentFilter);
    }

    private void unRegisterWeixRespReceiver() {
        if (this.mWeixRespReceiver == null) {
            return;
        }
        this.unregisterReceiver(this.mWeixRespReceiver);
        if (this.mWeixLoginProvider != null) {
            this.mWeixLoginProvider.unRegisterWeixBroadCast();
        }
    }

    public void start() {
        ARouter.init((Application)this.getApplication());
        this.mWeixLoginProvider = (IWeixLoginProvider)ARouter.getInstance().build("/AppRouter/weix/login/WeixLoginProvider").navigation();
        TextView login_question = (TextView)this.findViewById(R.id.login_question);
        if (login_question != null) {
            login_question.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ARouter.getInstance().build("/AppRouter/minecontact/ContactUsActivity").navigation();
                }
            });
        }
        this.mLoginPresent = new VerLoginPresent(this);
        this.mLoginByVercodePresent = new LoginByVercodePresent(this);
        this.initViews();
        this.findViewById(R.id.weix_login_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (Build.VERSION.SDK_INT >= 26) {
                    if (LoginActivity.this.mWeixLoginProvider != null) {
                        LoginActivity.this.mWeixLoginProvider.registerWeixBroadCast("com.kangxin.doctor.receiver.action.weixlogin");
                        LoginActivity.this.mWeixLoginProvider.sendWeixLoginBroadCast("com.kangxin.doctor.receiver.action.weixlogin");
                    }
                } else {
                    Intent intent = new Intent("com.kangxin.doctor.receiver.action.weixlogin");
                    LoginActivity.this.sendBroadcast(intent);
                }
            }
        });
        this.registerWeixRespReceiver();
        this.findViewById(R.id.weix_login_btn).setVisibility(ByPlatform.createResources().addBy((Object)0).addYd((Object)0).addHt((Object)0).addNde((Object)8).addZdy((Object)8).addLyt((Object)0).addYc((Object)8).intValue());
    }

    private void initViews() {
        this.mCheckBox = (CheckBox)this.findViewById(R.id.mCheckBox);
        this.findViewById(R.id.ver_user_xieyi).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bundle bundle = new Bundle();
                bundle.putString("loadurl", ByConfiguration.getUserAgreement((String)ByConfiguration.getPlatformCode()));
                bundle.putString("title", LoginActivity.this.getResources().getString(R.string.user_agreement));
                Intent intent = new Intent((Context)LoginActivity.this, AgreementNoticeCountryActivity.class);
                intent.putExtras(bundle);
                LoginActivity.this.startActivity(intent);
            }
        });
        this.findViewById(R.id.ver_yinsizhc).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bundle bundle = new Bundle();
                bundle.putString("loadurl", ByConfiguration.getPrivatePolicy((String)ByConfiguration.getPlatformCode()));
                bundle.putString("title", LoginActivity.this.getResources().getString(R.string.legal_notice));
                Intent intent = new Intent((Context)LoginActivity.this, AgreementNoticeCountryActivity.class);
                intent.putExtras(bundle);
                LoginActivity.this.startActivity(intent);
            }
        });
        this.mPhoneNumEdit = (ZpPhoneEditText)this.findViewById(R.id.edt_phonenum);
        this.mClosePhoneNumImg = (ImageView)this.findViewById(R.id.clearlogin_img);
        this.mVercodeText = (TextView)this.findViewById(R.id.vercode_txt);
        this.mLoginButton = (Button)this.findViewById(R.id.bt_login);
        this.mVercodeEdt = (EditText)this.findViewById(R.id.edt_vercode);
        this.mBackImg = (ImageView)this.findViewById(R.id.img_back_ver);
        this.mErrNoticeText = (TextView)this.findViewById(R.id.err_notice);
        this.mLoginButton.setClickable(false);
        this.mCountDownUtil = new CountDownUtil(this.mVercodeText).setCountDownMillis(60000L).setCountDownColor(R.color.white, 0x1060000);
        this.isVercodeUsable(false);
        this.mCountDownUtil.setOnDownEndListener(() -> {
            String phoneNum = this.mPhoneNumEdit.getPhoneText();
            if (!TextUtils.isEmpty((CharSequence)phoneNum)) {
                this.isVercodeUsable(true);
            } else {
                this.isVercodeUsable(false);
            }
        });
        this.mClosePhoneNumImg.setOnClickListener(view -> this.mPhoneNumEdit.setText((CharSequence)""));
        this.mVercodeText.setOnClickListener(view -> {
            String phoneNum = this.mPhoneNumEdit.getPhoneText();
            if (TextUtils.isEmpty((CharSequence)phoneNum)) {
                return;
            }
            this.mLoginPresent.sentVerCode(phoneNum);
            this.isVercodeUsable(false);
        });
        this.addEdtChangeListener();
        UserAgrrPrimary.getInstance().showAgreenDialog((Activity)this, new UserAgrrPrimary.OnRxReq(){

            public void onNext() {
                PushManager.getInstance().initPush(new Config(LoginActivity.this.getApplicationContext()).appKey(ByConfiguration.getUMAppKey()).messageSecret(ByConfiguration.getUMAppSecret()));
                PushManager.getInstance().registerPushCallback((IPushCallback)new LoginPushCallBack());
                ImChatSerivice chatSerivice = (ImChatSerivice)ARouter.getInstance().build("/ByhimRouter/imchat_service/ImChatServiceImpl").navigation();
                if (chatSerivice != null) {
                    chatSerivice.initRongIm();
                }
                SPUtils.setSharedBooleanData((Context)LoginActivity.this.getApplicationContext(), (String)"privacy_agreement", (boolean)true);
            }
        });
        IPushAdProvider pushAdProvider = (IPushAdProvider)ARouter.getInstance().build("/PushAdRouter/request/path").navigation();
        if (pushAdProvider != null) {
            pushAdProvider.request();
        }
    }

    private void addEdtChangeListener() {
        this.mPhoneNumEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                LoginActivity.this.mErrNoticeText.setVisibility(8);
                if (editable.length() != 0) {
                    LoginActivity.this.mClosePhoneNumImg.setVisibility(0);
                    LoginActivity.this.mBackImg.setImageResource(R.drawable.ic_gray_fanhui);
                } else {
                    LoginActivity.this.mClosePhoneNumImg.setVisibility(8);
                    LoginActivity.this.mBackImg.setImageResource(R.drawable.ic_ver_guanbi);
                }
                String phoneNum = LoginActivity.this.mPhoneNumEdit.getPhoneText();
                if (VerifyUtil.isMobilePhoneNumber((String)phoneNum)) {
                    LoginActivity.this.isVercodeUsable(true);
                } else {
                    LoginActivity.this.isVercodeUsable(false);
                }
            }
        });
        this.mVercodeEdt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @RequiresApi(api=16)
            public void afterTextChanged(Editable editable) {
                LoginActivity.this.mErrNoticeText.setVisibility(8);
                if (editable.length() == 6) {
                    LoginActivity.this.mLoginButton.setClickable(true);
                    LoginActivity.this.mLoginButton.setBackground(ResourcesCompat.getDrawable((Resources)LoginActivity.this.getResources(), (int)R.drawable.vercode_order_bg, null));
                } else {
                    LoginActivity.this.mLoginButton.setClickable(false);
                    LoginActivity.this.mLoginButton.setBackground(ResourcesCompat.getDrawable((Resources)LoginActivity.this.getResources(), (int)R.drawable.bt_gray_order_bg, null));
                }
                if (editable.length() != 0) {
                    LoginActivity.this.mBackImg.setImageResource(R.drawable.ic_gray_fanhui);
                } else {
                    LoginActivity.this.mBackImg.setImageResource(R.drawable.ic_ver_guanbi);
                }
            }
        });
    }

    public int getContentLayoutId() {
        return R.layout.activity_ver_login;
    }

    public void clickLogin(View view) {
        if (!this.mCheckBox.isChecked()) {
            ToastUtils.showShort((CharSequence)"\u8bf7\u52fe\u9009\u9690\u79c1\u653f\u7b56\u4ee5\u53ca\u7528\u6237\u534f\u8bae");
            return;
        }
        String phoneNum = this.mPhoneNumEdit.getPhoneText();
        String verCode = this.mVercodeEdt.getText().toString().trim();
        if (!VerifyUtil.isMobilePhoneNumber((String)phoneNum)) {
            ToastUtils.showLong((CharSequence)StringsUtils.getString((int)R.string.verlogin_shoujihaogeshibuzhengque));
            return;
        }
        Login login = new Login();
        login.setAccountNo(phoneNum);
        String authKey = this.mLoginPresent.getAuthKey();
        if (TextUtils.isEmpty((CharSequence)authKey)) {
            ToastUtils.showLong((CharSequence)StringsUtils.getString((int)R.string.verlogin_qinghuoquyanzhengma));
            return;
        }
        login.setAuthKey(authKey);
        login.setCode(verCode);
        login.setLoginDeviceNum(PushManager.getDeviceId((Context)this.mContext, (String)DeviceIdUtil.getDeviceId((Context)this.mContext)));
        this.mLoginByVercodePresent.loginByVercode(this.getBaseContext(), login);
    }

    public void clickPwdLogin(View view) {
        this.startActivity(new Intent((Context)this, PwdLoginActivity.class));
    }

    public void clickBack(View view) {
        String phoneNum = this.mPhoneNumEdit.getPhoneText();
        String verCode = this.mVercodeEdt.getText().toString().trim();
        if (!TextUtils.isEmpty((CharSequence)phoneNum) || !TextUtils.isEmpty((CharSequence)verCode)) {
            this.mPhoneNumEdit.setText((CharSequence)"");
            this.mVercodeEdt.setText((CharSequence)"");
            this.mCountDownUtil.reset();
            this.isVercodeUsable(false);
        } else {
            ARouter.getInstance().build("/AppRouter/home/MainActivity").navigation();
            this.finish();
        }
    }

    public void onBackPressedSupport() {
        ARouter.getInstance().build("/AppRouter/home/MainActivity").navigation();
        this.finish();
    }

    @Override
    public void loginOk(ResponseBody<LoginSuccess> loginSuccess) {
    }

    @Override
    public void reqErr(String err) {
        Log.i((String)TAG, (String)("==reqErr==" + err));
        this.mCountDownUtil.reset();
    }

    @Override
    public void receiveVercode() {
        this.mCountDownUtil.start();
    }

    @Override
    public void setPwdOk(String msg) {
    }

    @Override
    public void getCheck() {
    }

    @Override
    public void getCheck(int stutas) {
    }

    private void isVercodeUsable(boolean isUse) {
        if (isUse) {
            this.mCountDownUtil.setUsable(true);
            this.mVercodeText.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.vercode_order_bg, null));
            this.mVercodeText.setTextColor(this.getResources().getColor(17170443));
            this.mVercodeText.setClickable(true);
            this.mVercodeText.setFocusable(true);
            this.mVercodeText.setText(R.string.ver_getvercode);
        } else {
            this.mCountDownUtil.setUsable(false);
            this.mVercodeText.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.edt_order_bg, null));
            this.mVercodeText.setTextColor(this.getResources().getColor(0x1060000));
            this.mVercodeText.setText(R.string.ver_getvercode);
            this.mVercodeText.setClickable(false);
            this.mVercodeText.setFocusable(false);
        }
    }

    @Override
    public void loginByCodeOk(LoginSuccess loginSuccess, String msg) {
        Log.i((String)TAG, (String)("loginByCodeOk==>" + loginSuccess));
        if (loginSuccess == null) {
            this.showShortToast(msg);
            return;
        }
        this.updateUserInfo();
        this.receiveStatus(loginSuccess.getAccountStatus(), LoginFlag.NORMAL);
    }

    private void updateUserInfo() {
        UpdateVerStatus.getInstance().updateDocDetailInfo(this.getBaseContext(), new IUpdateVerStatus.OnUpdateDocDetailInfoCallback(){

            public void updateDocDetailInfoOk() {
            }

            public void updateDocDetailInfoErr(String err) {
                LoginActivity.this.showShortToast(err);
            }
        });
    }

    public void receiveStatus(int status, LoginFlag loginFlag) {
        Log.i((String)TAG, (String)"===receiveStatus==");
        LoginDispatchStatus loginDispatchStatus = new LoginDispatchStatus();
        if (loginFlag == LoginFlag.WECHAT) {
            loginDispatchStatus.registerStatus(ModuleManager.getWX(1, (Activity)this));
        } else {
            loginDispatchStatus.registerStatus(ModuleManager.getLogin(1, (Activity)this));
        }
        loginDispatchStatus.dispatchStatus(status);
        EventBus.getDefault().post((Object)new ByhCommEvent.LoginOkEvent());
        UpdateVerStatus.getInstance().updateImToken(this.getBaseContext());
        this.finish();
        IPushAdProvider pushAdProvider = (IPushAdProvider)ARouter.getInstance().build("/PushAdRouter/request/path").navigation();
        if (pushAdProvider != null) {
            pushAdProvider.request();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unRegisterWeixRespReceiver();
    }

    static enum LoginFlag {
        WECHAT,
        NORMAL;

    }

    private class WeixRespReceiver
    extends BroadcastReceiver {
        private WeixRespReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String code = intent.getStringExtra("WEIX_RESP_CODE_KEY");
            Log.i((String)LoginActivity.TAG, (String)("code===>" + code));
            LoginActivity.this.mWeixAuthPresent = new WeixAuthPresent(LoginActivity.this.getBaseContext(), LoginActivity.this);
            LoginActivity.this.mWeixAuthPresent.reqWeixAuth(code);
        }
    }
}

