/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.bigkoo.pickerview.builder.OptionsPickerBuilder;
import com.bigkoo.pickerview.view.OptionsPickerView;
import com.byh.module.verlogin.FramePerInfoControActivity;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.JobTitleEntity;
import com.byh.module.verlogin.entity.OccupationEntity;
import com.byh.module.verlogin.present.PersonInfoPresent;
import com.byh.module.verlogin.view.IPersonInfosView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.PersonInfoBody;
import com.kangxin.common.byh.entity.SelZhicEntity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.entity.v2.HospitalEntityV2;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.Event;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IPersonalInfoVerifyView;
import com.kangxin.common.util.StringUtil;
import com.kangxin.common.util.StringsUtils;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.Nullable;

@Route(path="/VerloginRouter/verification/PersonInfoActivity")
public class PersonInfoActivity
extends BaseActivity
implements IToolView,
View.OnClickListener,
IPersonInfosView,
IPersonalInfoVerifyView {
    private static final String TAG = "PersonInfoActivity";
    private TextView mYiyuanNameText;
    private TextView mSuozKeshiText;
    private TextView mSelZhiyText;
    private TextView mSelZhicText;
    private TextView mShanChlyText;
    private EditText mRealNameEdt;
    private PersonInfoPresent mPersonInfoPresent;
    private EditText mIdcardEdtView;
    private ArrayList<OccupationEntity> occupationEntities;
    private OccupationEntity selectOccupation;
    private ArrayList<JobTitleEntity> jobTitleEntities;
    private JobTitleEntity selectJobTitle;
    private HospitalEntityV2 mHospitalEntity;
    private String mAreaCode;
    private ByhCommEvent.HosDeptDataEvent mHosDeptData;
    private String mShancArea;
    private SelZhicEntity mDictEntity;
    private String mRealName;
    private PersonInfoBody personInfoBody;

    public void start() {
        this.occupationEntities = new ArrayList();
        this.jobTitleEntities = new ArrayList();
        this.mPersonInfoPresent = new PersonInfoPresent(this);
        this.vToolTitleTextView.setText(R.string.person_info);
        this.mYiyuanNameText = (TextView)this.findViewById(R.id.yiy_name);
        this.mYiyuanNameText.setOnClickListener((View.OnClickListener)this);
        this.mSuozKeshiText = (TextView)this.findViewById(R.id.suoz_keshi);
        this.mSuozKeshiText.setOnClickListener((View.OnClickListener)this);
        this.mSelZhiyText = (TextView)this.findViewById(R.id.sel_zhiy);
        this.mSelZhiyText.setOnClickListener((View.OnClickListener)this);
        this.mSelZhicText = (TextView)this.findViewById(R.id.sel_zhic);
        this.mSelZhicText.setOnClickListener((View.OnClickListener)this);
        this.mShanChlyText = (TextView)this.findViewById(R.id.shanc_liny);
        this.mShanChlyText.setOnClickListener((View.OnClickListener)this);
        this.mRealNameEdt = (EditText)this.findViewById(R.id.real_name_edt);
        this.mIdcardEdtView = (EditText)this.findViewById(R.id.idcardnum_edt);
    }

    public int getContentLayoutId() {
        return R.layout.person_info_activity;
    }

    public View getVToolView() {
        return this.rootView.findViewById(R.id.tool_bar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    @Override
    public void occupationSuccess(List<OccupationEntity> entityList) {
        this.occupationEntities.clear();
        this.occupationEntities.addAll(entityList);
        OptionsPickerView pickerView = new OptionsPickerBuilder((Context)this, (options1, option2, options3, v) -> {
            if (this.selectOccupation != null && TextUtils.equals((CharSequence)this.selectOccupation.getTypeCode(), (CharSequence)this.occupationEntities.get(options1).getTypeCode())) {
                return;
            }
            this.selectOccupation = this.occupationEntities.get(options1);
            this.mSelZhiyText.setText((CharSequence)this.selectOccupation.getTypeName());
            this.mSelZhiyText.setTextColor(ContextCompat.getColor((Context)this.getBaseContext(), (int)R.color.gray_333333));
            this.mSelZhicText.setText((CharSequence)this.getString(R.string.psel_xuanze));
            this.mSelZhicText.setTextColor(ContextCompat.getColor((Context)this.getBaseContext(), (int)R.color.color_999999));
            this.selectJobTitle = null;
        }).setSubmitText(this.getString(R.string.ver_ok)).setCancelText(this.getString(R.string.ver_cancel)).setTitleText(this.getString(R.string.psel_xuanze)).isCenterLabel(false).build();
        pickerView.setPicker(this.occupationEntities);
        pickerView.show();
    }

    @Override
    public void jobTitleSuccess(List<JobTitleEntity> entities) {
        this.jobTitleEntities.clear();
        this.jobTitleEntities.addAll(entities);
        OptionsPickerView pickerView = new OptionsPickerBuilder((Context)this, (options1, option2, options3, v) -> {
            this.selectJobTitle = this.jobTitleEntities.get(options1);
            this.mSelZhicText.setText((CharSequence)this.selectJobTitle.getDicName());
            this.mSelZhicText.setTextColor(ContextCompat.getColor((Context)this.getBaseContext(), (int)R.color.gray_333333));
        }).setSubmitText(this.getString(R.string.ver_ok)).setCancelText(this.getString(R.string.ver_cancel)).setTitleText(this.getString(R.string.psel_xuanze)).isCenterLabel(false).build();
        pickerView.setPicker(this.jobTitleEntities);
        pickerView.show();
    }

    public void onClick(View view) {
        Intent intent = new Intent((Context)this, FramePerInfoControActivity.class);
        int i = view.getId();
        if (i == R.id.sel_zhiy) {
            if (this.occupationEntities.isEmpty()) {
                this.mPersonInfoPresent.occupationList();
            } else {
                this.occupationSuccess(new ArrayList<OccupationEntity>(this.occupationEntities));
            }
            return;
        }
        if (i == R.id.sel_zhic) {
            if (this.selectOccupation == null) {
                this.showShortToast(this.getString(R.string.psel_suoznizhiy));
                return;
            }
            if (this.jobTitleEntities.isEmpty()) {
                this.mPersonInfoPresent.jobTitleList(this.selectOccupation.getTypeCode());
            } else if (TextUtils.equals((CharSequence)this.selectOccupation.getTypeCode(), (CharSequence)this.jobTitleEntities.get(0).getParentCode())) {
                this.jobTitleSuccess(new ArrayList<JobTitleEntity>(this.jobTitleEntities));
            } else {
                this.mPersonInfoPresent.jobTitleList(this.selectOccupation.getTypeCode());
            }
            return;
        }
        if (i == R.id.yiy_name) {
            intent.putExtra("MSG_JUMP_TYPE", 5382);
        } else if (i == R.id.suoz_keshi) {
            if (this.mHospitalEntity == null) {
                this.showShortToast(this.getString(R.string.psel_suosyy));
                return;
            }
            long hosId = Long.parseLong(this.mHospitalEntity.getHospitalId());
            String appCode = this.mHospitalEntity.getAppCode();
            intent.putExtra("MSG_JUMP_TYPE", 5383);
            intent.putExtra("HOS_APP_CODE", appCode);
            Log.i((String)TAG, (String)("hosId==>" + hosId));
            intent.putExtra("HOSPITAL_ID", hosId);
        } else if (i == R.id.shanc_liny) {
            intent.putExtra("MSG_JUMP_TYPE", 5385);
        }
        this.startActivity(intent);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveHosEntityEvent(ByhCommEvent.HosEntityEvent hosEntityEvent) {
        this.mHospitalEntity = hosEntityEvent.getmHosEntity();
        this.mAreaCode = this.mHospitalEntity.getDistrictCode();
        this.mYiyuanNameText.setText((CharSequence)this.mHospitalEntity.getHospitalName());
        this.mSuozKeshiText.setText((CharSequence)StringsUtils.getString((int)R.string.verlogin_qingxuanzeninsuozaikeshi));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveKeshiDataEvent(ByhCommEvent.HosDeptDataEvent hosDeptDataEvent) {
        this.mHosDeptData = hosDeptDataEvent;
        this.mSuozKeshiText.setText((CharSequence)this.mHosDeptData.getStdDeptName());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveEvent(Event.ShancName shancName) {
        this.mShancArea = shancName.getShancDesc();
        String shancArea = StringUtil.changeSubText((String)this.mShancArea, (int)15);
        this.mShanChlyText.setText((CharSequence)shancArea);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveZhicEntity(SelZhicEntity dictEntityListBean) {
        this.mDictEntity = dictEntityListBean;
        this.mSelZhicText.setText((CharSequence)this.mDictEntity.getDicName());
    }

    public void clickSave(View view) {
        this.mRealName = this.mRealNameEdt.getText().toString().trim();
        if (TextUtils.isEmpty((CharSequence)this.mRealName)) {
            this.showShortToast(this.getString(R.string.p_input_realname));
            return;
        }
        if (this.mHospitalEntity == null) {
            this.showShortToast(this.getString(R.string.psel_suosyy));
            return;
        }
        if (this.mHosDeptData == null || this.mSuozKeshiText.getText().equals(StringsUtils.getString((int)R.string.verlogin_qingxuanzeninsuozaikeshi))) {
            this.showShortToast(this.getString(R.string.verlogin_psel_keshiname));
            return;
        }
        String keshiName = this.mSuozKeshiText.getText().toString();
        if (TextUtils.isEmpty((CharSequence)keshiName)) {
            this.showShortToast(this.getString(R.string.verlogin_psel_keshiname));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mSelZhiyText.getText().toString())) {
            this.showShortToast(this.getString(R.string.verlogin_psel_zhiye));
        }
        if (this.selectJobTitle == null || this.mSelZhicText.getText().toString().isEmpty()) {
            this.showShortToast(this.getString(R.string.psel_suoznizhic));
            return;
        }
        if (this.mSelZhicText.getText().toString().trim().equals(this.getString(R.string.psel_suoznizhic))) {
            this.showShortToast(this.getString(R.string.psel_suoznizhic));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mShancArea)) {
            this.showShortToast(this.getString(R.string.please_input_shancly));
            return;
        }
        this.reqSavePersonInfo();
    }

    private void reqSavePersonInfo() {
        String idcardNum = this.mIdcardEdtView.getText().toString().trim();
        this.personInfoBody = new PersonInfoBody();
        LoginSuccess loginSuccess = VertifyDataUtil.getInstance((Context)this.getApplicationContext()).getLoginData();
        String accountId = VertifyDataUtil.getInstance((Context)this.getApplicationContext()).getLoginData().getAccountId();
        this.personInfoBody.setPhone(loginSuccess.getMobileNumber());
        this.personInfoBody.setAccountId(accountId);
        this.personInfoBody.setAreaCode(this.mAreaCode);
        this.personInfoBody.setChannelCode("DOCTOR_ANDROID");
        this.personInfoBody.setDisplayName(this.mRealName);
        this.personInfoBody.setAppCode(this.mHospitalEntity.getAppCode());
        this.personInfoBody.setHospitalId(this.mHospitalEntity.getHospitalId());
        this.personInfoBody.setHospitalCode(this.mHospitalEntity.getOrganCode());
        this.personInfoBody.setJob(this.mSelZhiyText.getText().toString());
        this.personInfoBody.setJobCode(this.selectOccupation.getTypeCode());
        this.personInfoBody.setProfession(this.selectJobTitle.getDicName());
        this.personInfoBody.setProfessionCode(this.selectJobTitle.getDicCode());
        this.personInfoBody.setHospitalDeptCode(this.mHosDeptData.getStdDeptId());
        this.personInfoBody.setHospitalDeptName(this.mHosDeptData.getHosDeptName());
        this.personInfoBody.setIdCardNo(idcardNum);
        this.personInfoBody.setRegHospitalName(this.mHospitalEntity.getHospitalName());
        this.personInfoBody.setSpeciality(this.mShancArea);
        this.personInfoBody.setStdFristDeptCode(this.mHosDeptData.getStdFirstDeptCode());
        this.personInfoBody.setStdFristDeptName(this.mHosDeptData.getStdFirstDeptName());
        this.personInfoBody.setStdSecondDeptCode(this.mHosDeptData.getStdSecondDeptCode());
        this.personInfoBody.setStdSecondDeptName(this.mHosDeptData.getStdSecondDeptName());
        this.mPersonInfoPresent.savePersonInfo(this.getBaseContext(), this.personInfoBody);
    }

    public void showErr(String msg) {
        this.showShortToast(msg);
    }

    public void showPersonInfo(LoginSuccess responseBody) {
        ExpertInfoEntity expertInfoEntity = new ExpertInfoEntity();
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = new ExpertInfoEntity.UserInfoVOBean();
        userInfoVOBean.setName(this.mRealName);
        userInfoVOBean.setHospitalId(this.mHospitalEntity.getHospitalId());
        userInfoVOBean.setProfessionCode(this.selectJobTitle.getDicCode());
        userInfoVOBean.setJob(this.selectOccupation.getTypeName());
        userInfoVOBean.setJobCode(this.selectOccupation.getTypeCode());
        expertInfoEntity.setUserInfoVO(userInfoVOBean);
        VertifyDataUtil.getInstance((Context)this.getBaseContext()).setDocDetailInfo(expertInfoEntity);
        VertifyDataUtil.getInstance().setOpenCode(this.mHospitalEntity.getAppCode());
        ARouter.getInstance().build("/VerloginRouter/verification/ProfesCertifyActivity").navigation();
        this.finish();
    }

    public void showVerifyResult(ResponseBody responseBody) {
        this.reqSavePersonInfo();
    }

    public void error(@Nullable String errorMsg) {
        this.showShortToast(errorMsg);
    }

    public boolean initYm() {
        return false;
    }
}

