/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.res.ResourcesCompat;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.AgreementNoticeCountryActivity;
import com.byh.module.verlogin.ForgetPassWordActivity;
import com.byh.module.verlogin.LoginActivity;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.event.vertify.LoginDispatchStatus;
import com.byh.module.verlogin.event.vertify.LoginStatusManager;
import com.byh.module.verlogin.present.VerLoginPresent;
import com.byh.module.verlogin.view.ILoginView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.ByConfiguration;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.provider.IPushAdProvider;
import com.kangxin.common.util.AppManager;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.push.PushManager;
import com.kangxin.util.common.DeviceIdUtil;
import com.kangxin.util.common.VerifyUtil;
import com.kangxin.widget.common.byh.ZpPhoneEditText;
import com.tbruyelle.rxpermissions.RxPermissions;

public class PwdLoginActivity
extends BaseActivity
implements ILoginView {
    private String TAG = "PwdLoginActivity";
    private ImageView mPwdShowImg;
    private EditText mVerPwdEdt;
    private ImageView mClosePhoneNumImg;
    private ZpPhoneEditText mPhoneNumEdt;
    private Button mLoginBtn;
    private TextView mErrNoticeText;
    private VerLoginPresent mLoginPresent;
    private TextView mForgetPwdText;
    private CheckBox checkBox;
    private static final String DEVICE_ID_SP_KEY = "umeng_device_id_sp_key";

    public void start() {
        this.mLoginPresent = new VerLoginPresent(this);
        this.findViewById(R.id.img_back_ver).setOnClickListener(view -> this.finish());
        this.findViewById(R.id.login_question).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ARouter.getInstance().build("/AppRouter/minecontact/ContactUsActivity").navigation();
            }
        });
        this.checkBox = (CheckBox)this.findViewById(R.id.mCheckBox);
        this.mPwdShowImg = (ImageView)this.findViewById(R.id.img_pwd_kejian);
        this.mVerPwdEdt = (EditText)this.findViewById(R.id.ver_pwd_edt);
        this.mClosePhoneNumImg = (ImageView)this.findViewById(R.id.clearlogin_img);
        this.mPhoneNumEdt = (ZpPhoneEditText)this.findViewById(R.id.edt_phonenum);
        this.mLoginBtn = (Button)this.findViewById(R.id.login_btn);
        this.mErrNoticeText = (TextView)this.findViewById(R.id.err_notice);
        this.mForgetPwdText = (TextView)this.findViewById(R.id.forget_pwd_tv);
        this.mLoginBtn.setClickable(false);
        this.mClosePhoneNumImg.setOnClickListener(view -> this.mPhoneNumEdt.setText((CharSequence)""));
        this.addEdtChangeListener();
        int type = 129;
        this.mPwdShowImg.setOnClickListener(view -> {
            if (this.mVerPwdEdt.getInputType() == 129) {
                this.mVerPwdEdt.setInputType(144);
                this.mVerPwdEdt.setSelection(this.mVerPwdEdt.getText().length());
                this.mPwdShowImg.setImageResource(R.drawable.ic_ver_kejian);
            } else {
                this.mVerPwdEdt.setInputType(129);
                this.mVerPwdEdt.setSelection(this.mVerPwdEdt.getText().length());
                this.mPwdShowImg.setImageResource(R.drawable.ic_bukejian);
            }
        });
        this.mForgetPwdText.setOnClickListener(v -> {
            String phoneNum = this.mPhoneNumEdt.getPhoneText();
            if (TextUtils.isEmpty((CharSequence)phoneNum)) {
                this.showShortToast(StringsUtils.getString((int)R.string.verlogin_qingshurushoujihao));
                return;
            }
            if (!VerifyUtil.isMobilePhoneNumber((String)phoneNum)) {
                this.showShortToast(this.getResources().getString(R.string.forget_phone_error_tips));
                return;
            }
            Intent intentFPwd = new Intent(this.getMContext(), ForgetPassWordActivity.class);
            intentFPwd.putExtra("phoneNum", phoneNum);
            this.startActivity(intentFPwd);
        });
        this.findViewById(R.id.ver_user_xieyi).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bundle bundle = new Bundle();
                bundle.putString("loadurl", ByConfiguration.getUserAgreement((String)ByConfiguration.getPlatformCode()));
                bundle.putString("title", PwdLoginActivity.this.getResources().getString(R.string.user_agreement));
                Intent intent = new Intent((Context)PwdLoginActivity.this, AgreementNoticeCountryActivity.class);
                intent.putExtras(bundle);
                PwdLoginActivity.this.startActivity(intent);
            }
        });
        this.findViewById(R.id.ver_yinsizhc).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bundle bundle = new Bundle();
                bundle.putString("loadurl", ByConfiguration.getPrivatePolicy((String)ByConfiguration.getPlatformCode()));
                bundle.putString("title", PwdLoginActivity.this.getResources().getString(R.string.legal_notice));
                Intent intent = new Intent((Context)PwdLoginActivity.this, AgreementNoticeCountryActivity.class);
                intent.putExtras(bundle);
                PwdLoginActivity.this.startActivity(intent);
            }
        });
    }

    private void addEdtChangeListener() {
        this.mPhoneNumEdt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                PwdLoginActivity.this.setLoginBtnUseable();
                PwdLoginActivity.this.mErrNoticeText.setVisibility(8);
                if (editable.length() != 0) {
                    PwdLoginActivity.this.mClosePhoneNumImg.setVisibility(0);
                } else {
                    PwdLoginActivity.this.mClosePhoneNumImg.setVisibility(8);
                }
            }
        });
        this.mVerPwdEdt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                PwdLoginActivity.this.setLoginBtnUseable();
                PwdLoginActivity.this.mErrNoticeText.setVisibility(8);
                if (editable.length() != 0) {
                    PwdLoginActivity.this.mPwdShowImg.setVisibility(0);
                } else {
                    PwdLoginActivity.this.mPwdShowImg.setVisibility(8);
                }
            }
        });
    }

    private void setLoginBtnUseable() {
        String phoneNum = this.mPhoneNumEdt.getPhoneText();
        String pwdNum = this.mVerPwdEdt.getText().toString().trim();
        if (!TextUtils.isEmpty((CharSequence)phoneNum) && !TextUtils.isEmpty((CharSequence)pwdNum)) {
            this.mLoginBtn.setClickable(true);
            this.mLoginBtn.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.vercode_order_bg, null));
        } else {
            this.mLoginBtn.setClickable(false);
            this.mLoginBtn.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.gray_button_background, null));
        }
    }

    public int getContentLayoutId() {
        return R.layout.verpwd_login_activity;
    }

    public void clickLogin(View view) {
        if (!this.checkBox.isChecked()) {
            ToastUtils.showShort((CharSequence)"\u8bf7\u52fe\u9009\u9690\u79c1\u653f\u7b56\u4ee5\u53ca\u7528\u6237\u534f\u8bae");
            return;
        }
        RxPermissions.getInstance((Context)this.getBaseContext()).request(new String[]{"android.permission.READ_PHONE_STATE"}).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                String phoneNum = this.mPhoneNumEdt.getPhoneText();
                String pwd = this.mVerPwdEdt.getText().toString().trim();
                String loginDeviceNum = PushManager.getDeviceId((Context)this.mContext, (String)DeviceIdUtil.getDeviceId((Context)this.mContext));
                Login login = new Login(phoneNum, pwd);
                login.setLoginDeviceNum(loginDeviceNum);
                this.mLoginPresent.loginApp(this.getBaseContext(), login);
            } else {
                String phoneNum = this.mPhoneNumEdt.getPhoneText();
                String pwd = this.mVerPwdEdt.getText().toString().trim();
                String loginDeviceNum = PushManager.getDeviceId((Context)this.mContext, (String)DeviceIdUtil.getDeviceId((Context)this.mContext));
                Login login = new Login(phoneNum, pwd);
                login.setLoginDeviceNum(loginDeviceNum);
                this.mLoginPresent.loginApp(this.getBaseContext(), login);
            }
        });
    }

    private void gotoSetting() {
        try {
            this.startActivity(new Intent("android.settings.APPLICATION_SETTINGS"));
        }
        catch (Exception ignore) {
            ToastUtils.showShort((CharSequence)"\u6253\u5f00\u8bbe\u7f6e\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u6253\u5f00app\u7684\u7535\u8bdd\u6743\u9650");
        }
    }

    @Override
    public void loginOk(ResponseBody<LoginSuccess> loginSuccess) {
        Log.i((String)this.TAG, (String)("loginOk===>>" + loginSuccess));
        AppManager.getAppManager().finishActivity(PwdLoginActivity.class);
        AppManager.getAppManager().finishActivity(LoginActivity.class);
        this.receiveStatus(((LoginSuccess)loginSuccess.getResult()).getAccountStatus());
        IPushAdProvider pushAdProvider = (IPushAdProvider)ARouter.getInstance().build("/PushAdRouter/request/path").navigation();
        if (pushAdProvider != null) {
            pushAdProvider.request();
        }
    }

    private void receiveStatus(int status) {
        LoginDispatchStatus loginDispatchStatus = new LoginDispatchStatus();
        loginDispatchStatus.registerStatus(new LoginStatusManager((Activity)this));
        loginDispatchStatus.dispatchStatus(status);
    }

    @Override
    public void reqErr(String err) {
        Log.i((String)this.TAG, (String)("reqErr==>>" + err));
        this.mErrNoticeText.setVisibility(0);
        this.mErrNoticeText.setText((CharSequence)err);
    }

    @Override
    public void receiveVercode() {
    }

    @Override
    public void setPwdOk(String msg) {
    }

    @Override
    public void getCheck() {
    }

    @Override
    public void getCheck(int status) {
        AppManager.getAppManager().finishActivity(PwdLoginActivity.class);
        AppManager.getAppManager().finishActivity(LoginActivity.class);
        this.receiveStatus(status);
    }

    public boolean initYm() {
        return false;
    }
}

