/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.content.Context;
import android.content.res.Resources;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import androidx.core.content.res.ResourcesCompat;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.module.verlogin.LoginActivity;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.present.VerLoginPresent;
import com.byh.module.verlogin.view.ILoginView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.util.AppManager;
import com.kangxin.push.PushManager;
import com.kangxin.util.common.DeviceIdUtil;

@Route(path="/VerloginRouter/verification/PwdSetActivity")
public class PwdSetActivity
extends BaseActivity
implements ILoginView {
    private String TAG = "PwdSetActivity";
    private ImageView mPwdShowImg;
    private EditText mVerPwdEdt;
    private Button mOkButton;
    private VerLoginPresent mLoginPresent;

    public void start() {
        this.mLoginPresent = new VerLoginPresent(this);
        this.findViewById(R.id.img_back_ver).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PwdSetActivity.this.finish();
            }
        });
        this.mPwdShowImg = (ImageView)this.findViewById(R.id.img_pwd_kejian);
        this.mVerPwdEdt = (EditText)this.findViewById(R.id.ver_pwd_edt);
        this.mOkButton = (Button)this.findViewById(R.id.ok_btn);
        this.mOkButton.setClickable(false);
        this.mVerPwdEdt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                PwdSetActivity.this.setOkBtnUseable();
                if (editable.length() != 0) {
                    PwdSetActivity.this.mPwdShowImg.setVisibility(0);
                } else {
                    PwdSetActivity.this.mPwdShowImg.setVisibility(8);
                }
            }
        });
        int type = 129;
        this.mPwdShowImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PwdSetActivity.this.mVerPwdEdt.getInputType() == 129) {
                    PwdSetActivity.this.mVerPwdEdt.setInputType(144);
                    PwdSetActivity.this.mVerPwdEdt.setSelection(PwdSetActivity.this.mVerPwdEdt.getText().length());
                    PwdSetActivity.this.mPwdShowImg.setImageResource(R.drawable.ic_ver_kejian);
                } else {
                    PwdSetActivity.this.mVerPwdEdt.setInputType(129);
                    PwdSetActivity.this.mVerPwdEdt.setSelection(PwdSetActivity.this.mVerPwdEdt.getText().length());
                    PwdSetActivity.this.mPwdShowImg.setImageResource(R.drawable.ic_bukejian);
                }
            }
        });
    }

    public int getContentLayoutId() {
        return R.layout.activity_ver_pwdset;
    }

    private void setOkBtnUseable() {
        String phoneNum = this.mVerPwdEdt.getText().toString().trim();
        if (TextUtils.isEmpty((CharSequence)phoneNum)) {
            this.mOkButton.setClickable(false);
            this.mOkButton.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.gray_button_background, null));
        } else {
            this.mOkButton.setClickable(true);
            this.mOkButton.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.vercode_order_bg, null));
        }
    }

    public void clickOk(View view) {
        String pwd = this.mVerPwdEdt.getText().toString().trim();
        if (!VertifyDataUtil.getInstance((Context)this.getBaseContext()).authPwd(pwd)) {
            return;
        }
        Login login = new Login();
        String phoneNum = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getLoginData().getMobileNumber();
        login.setAccountNo(phoneNum);
        login.setPassword(pwd);
        login.setLoginDeviceNum(PushManager.getDeviceId((Context)this.mContext, (String)DeviceIdUtil.getDeviceId((Context)this.mContext)));
        this.mLoginPresent.setPassword(this.getBaseContext(), login);
    }

    @Override
    public void loginOk(ResponseBody<LoginSuccess> loginSuccess) {
    }

    @Override
    public void reqErr(String err) {
        Log.i((String)this.TAG, (String)("==reqErr==>" + err));
    }

    @Override
    public void receiveVercode() {
    }

    @Override
    public void setPwdOk(String msg) {
        ARouter.getInstance().build("/VerloginRouter/verification/PersonInfoActivity").navigation();
        this.finish();
        AppManager.getAppManager().finishActivity(LoginActivity.class);
    }

    @Override
    public void getCheck() {
    }

    @Override
    public void getCheck(int status) {
    }

    public boolean initYm() {
        return false;
    }
}

