/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin.fragment;

import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.present.SelZhicPresent;
import com.byh.module.verlogin.view.ISelzhicView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.entity.SelZhicEntity;
import java.util.List;

public class SelZhicFragment
extends BaseFragment
implements ISelzhicView {
    private BaseQuickAdapter<SelZhicEntity, BaseViewHolder> mZhicListAdapter;
    private SelZhicPresent mSelZhicPresent;
    private SelZhicEntity mDictEntity;
    private List<SelZhicEntity> mZhicList;

    public static SelZhicFragment getInstance() {
        return new SelZhicFragment();
    }

    public void init() {
        this.mSelZhicPresent = new SelZhicPresent(this);
        this.mSelZhicPresent.getSelZchicList(this.getContext());
    }

    private void setAdapter() {
        RecyclerView zhicRecycleView = (RecyclerView)this.findViewById(this.rootView, R.id.recycler_list);
        zhicRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mZhicListAdapter = new BaseQuickAdapter<SelZhicEntity, BaseViewHolder>(R.layout.zhic_list_item, this.mZhicList){

            protected void convert(BaseViewHolder helper, SelZhicEntity item) {
                helper.setText(R.id.zhic_name, (CharSequence)item.getDicName());
                if (item.isSelected()) {
                    helper.setImageResource(R.id.sel_img, R.drawable.ic_person_duihao);
                } else {
                    helper.setImageResource(R.id.sel_img, 0);
                }
            }
        };
        this.mZhicListAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                SelZhicFragment.this.initList();
                ((SelZhicEntity)SelZhicFragment.this.mZhicList.get(position)).setSelected(true);
                SelZhicFragment.this.mDictEntity = (SelZhicEntity)SelZhicFragment.this.mZhicList.get(position);
                SelZhicFragment.this.mZhicListAdapter.notifyDataSetChanged();
            }
        });
        zhicRecycleView.setAdapter(this.mZhicListAdapter);
    }

    public SelZhicEntity getDictEntity() {
        return this.mDictEntity;
    }

    private void initList() {
        for (int i = 0; i < this.mZhicList.size(); ++i) {
            this.mZhicList.get(i).setSelected(false);
        }
    }

    @Override
    public void showErr(String msg) {
        this.showShortToast(msg);
    }

    @Override
    public void showZhicList(List<SelZhicEntity> selZhicEntityResponseBody) {
        this.mZhicList = selZhicEntityResponseBody;
        this.setAdapter();
    }

    protected int getLayoutId() {
        return R.layout.recycler_list_layout;
    }
}

