/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin.module;

import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.PwdParam;
import com.byh.module.verlogin.entity.UpdatePhoneParam;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.common.widget.RxProgressObserver;
import io.reactivex.Observer;

public class ChangePhoneViewModel
extends ViewModel {
    private VerLoginModule mVerLoginModule;

    public MutableLiveData<String> getCodeByPhone(String mPhoneNum) {
        final MutableLiveData key = new MutableLiveData();
        this.mVerLoginModule = new VerLoginModule();
        this.mVerLoginModule.sendSmsAuthCode(mPhoneNum).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                key.setValue((Object)((LoginSuccess)loginSuccessResponseBody.getResult()).getAuthKey());
                ToastUtils.showLong((CharSequence)StringsUtils.getString((int)R.string.verlogin_fasongchenggong));
            }

            public void onReqErr(Throwable e) {
                ToastUtils.showLong((CharSequence)StringsUtils.getString((int)R.string.verlogin_fasongchenggong_shibai));
            }
        });
        return key;
    }

    public MutableLiveData<ResponseBody> checkCode(String code, String authKey) {
        final MutableLiveData msg = new MutableLiveData();
        this.mVerLoginModule = new VerLoginModule();
        ReqWebBody reqWebBody = new ReqWebBody();
        reqWebBody.setAuthCode(code);
        reqWebBody.setAuthKey(authKey);
        reqWebBody.setOperate("D");
        this.mVerLoginModule.validatePhoneAndCode(reqWebBody).subscribe((Observer)new RxProgressObserver<ResponseBody>(){

            public void onReqNext(ResponseBody responseBody) {
                msg.setValue((Object)responseBody);
            }

            public void onReqErr(int code, String msgs, String errCode) {
                ResponseBody response = new ResponseBody();
                response.setCode("0");
                response.setMsg(msgs);
                msg.setValue((Object)response);
            }
        });
        return msg;
    }

    public MutableLiveData<ResponseBody> checkPwdForNewPhone(String accountNo, String pwd) {
        final MutableLiveData result = new MutableLiveData();
        this.mVerLoginModule = new VerLoginModule();
        PwdParam pwdParam = new PwdParam();
        pwdParam.setLoginPwd(pwd);
        pwdParam.setAccountNo(accountNo);
        this.mVerLoginModule.checkPwdForNewPhoneNum(pwdParam).subscribe((Observer)new RxProgressObserver<ResponseBody>(){

            public void onReqNext(ResponseBody responseBody) {
                result.setValue((Object)responseBody);
            }
        });
        return result;
    }

    public MutableLiveData<ResponseBody> updateNewPhoneNum(String accountNo, String channel, String phone) {
        final MutableLiveData result = new MutableLiveData();
        this.mVerLoginModule = new VerLoginModule();
        UpdatePhoneParam phoneParam = new UpdatePhoneParam();
        phoneParam.setPhoneNumber(phone);
        phoneParam.setChannelCode(channel);
        phoneParam.setAccountNo(accountNo);
        this.mVerLoginModule.updateNewPhoneNum(phoneParam).subscribe((Observer)new RxProgressObserver<ResponseBody>(){

            public void onReqNext(ResponseBody responseBody) {
                result.setValue((Object)responseBody);
            }
        });
        return result;
    }
}

