/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin.present;

import android.content.Context;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.WeixRespTokenEntity;
import com.byh.module.verlogin.module.IVerLoginModule;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.IBindWeChatView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.push.PushManager;
import com.kangxin.util.common.DeviceIdUtil;
import io.reactivex.Observer;

public class BindWeixPresent {
    private IVerLoginModule mVerLoginModule;
    private IBindWeChatView mBindWechatView;
    private Context mContext;
    private String mAuthKey;

    public BindWeixPresent(Context context, IBindWeChatView bindWeChatView) {
        this.mContext = context;
        this.mBindWechatView = bindWeChatView;
        this.mVerLoginModule = new VerLoginModule();
    }

    public void sentVerCode(String phoneNum) {
        this.mVerLoginModule.sendSmsAuthCode(phoneNum).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                ToastUtils.showShort((CharSequence)StringsUtils.getString((int)R.string.verlogin_fasongchenggong));
                BindWeixPresent.this.mAuthKey = ((LoginSuccess)loginSuccessResponseBody.getResult()).getAuthKey();
            }
        });
    }

    private void reqHasBindWeix(String unionId) {
        this.mVerLoginModule.resHasBindWeix(unionId).subscribe((Observer)new RxProgressObserver<ResponseBody<WeixRespTokenEntity>>(){

            public void onReqNext(ResponseBody<WeixRespTokenEntity> weixRespTokenEntityResponseBody) {
                WeixRespTokenEntity weixRespTokenEntity = (WeixRespTokenEntity)weixRespTokenEntityResponseBody.getResult();
                if (weixRespTokenEntity == null) {
                    BindWeixPresent.this.mBindWechatView.onError(StringsUtils.getString((int)R.string.verlogin_bangdingshibai));
                    return;
                }
                LoginSuccess loginSuccess = VertifyDataUtil.getInstance((Context)BindWeixPresent.this.mContext).getLoginData();
                if (loginSuccess == null) {
                    loginSuccess = new LoginSuccess();
                }
                VertifyDataUtil.getInstance((Context)BindWeixPresent.this.mContext).setLoginData(loginSuccess);
                BindWeixPresent.this.mBindWechatView.bindWechatSuccess();
            }
        });
    }

    private void realReqBindWeChat(String mobileNumber, String openId, String unionId, String vercode) {
        ReqWebBody reqWebBody = new ReqWebBody();
        reqWebBody.setAuthKey(this.mAuthKey);
        reqWebBody.setCode(vercode);
        reqWebBody.setLoginDeviceNum(PushManager.getDeviceId((Context)this.mContext, (String)DeviceIdUtil.getDeviceId((Context)this.mContext)));
        reqWebBody.setMobileNumber(mobileNumber);
        reqWebBody.setOpenId(openId);
        reqWebBody.setUnionId(unionId);
        this.mVerLoginModule.reqBindWeChat(reqWebBody).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                VertifyDataUtil.getInstance((Context)BindWeixPresent.this.mContext).setLoginData((LoginSuccess)loginSuccessResponseBody.getResult());
                BindWeixPresent.this.mBindWechatView.bindWechatSuccess();
            }
        });
    }

    public void reqBindWeChat(String verCode, String mobileNumber, String openId, String unionId) {
        ReqWebBody authCodeReqWebBody = new ReqWebBody();
        authCodeReqWebBody.setAuthCode(verCode);
        authCodeReqWebBody.setAuthKey(this.mAuthKey);
        this.realReqBindWeChat(mobileNumber, openId, unionId, verCode);
    }
}

