/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin.present;

import android.content.Context;
import android.util.Log;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.byh.module.verlogin.entity.JobTitleEntity;
import com.byh.module.verlogin.entity.OccupationEntity;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.IPersonInfosView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.PersonInfoBody;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.Event;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.present.IPersonInfoPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IPersonInfoView;
import com.kangxin.common.widget.RxProgressObserver;
import io.reactivex.Observer;
import java.util.List;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;

@Route(path="/VerloginRouter/service_person/PRESENTER_PERSON_INFO")
public class PersonInfoPresent
implements IPersonInfoPresenter {
    private VerLoginModule mLoginModule;
    protected IPersonInfoView mPersonView;
    private IUserModule mUserModule;

    public PersonInfoPresent(IPersonInfoView personInfoView) {
        this.mPersonView = personInfoView;
        this.mLoginModule = new VerLoginModule();
        this.mUserModule = new UserModule();
    }

    public PersonInfoPresent() {
    }

    public void attachView(IPersonInfoView personInfoView) {
        this.mPersonView = personInfoView;
        this.mLoginModule = new VerLoginModule();
        this.mUserModule = new UserModule();
    }

    public void occupationList() {
        this.mLoginModule.getOccupation().subscribe((Observer)new RxProgressObserver<ResponseBody<List<OccupationEntity>>>(){

            public void onReqNext(ResponseBody<List<OccupationEntity>> listResponseBody) {
                if (PersonInfoPresent.this.mPersonView instanceof IPersonInfosView) {
                    ((IPersonInfosView)PersonInfoPresent.this.mPersonView).occupationSuccess((List)listResponseBody.getData());
                }
            }
        });
    }

    public void jobTitleList(String typeCode) {
        this.mLoginModule.getJobTitle(typeCode).subscribe((Observer)new RxProgressObserver<ResponseBody<List<JobTitleEntity>>>(){

            public void onReqNext(ResponseBody<List<JobTitleEntity>> listResponseBody) {
                if (PersonInfoPresent.this.mPersonView instanceof IPersonInfosView) {
                    ((IPersonInfosView)PersonInfoPresent.this.mPersonView).jobTitleSuccess((List)listResponseBody.getData());
                }
            }
        });
    }

    public void setSiguUP(Map<String, String> post) {
        this.mLoginModule.setSiguUP(post).subscribe((Observer)new RxProgressObserver<ResponseBody>(){

            public void onReqNext(ResponseBody listResponseBody) {
                PersonInfoPresent.this.mPersonView.onSucress(listResponseBody.getMsg());
            }
        });
    }

    public void savePersonInfo(final Context context, PersonInfoBody personInfoBody) {
        String token = VertifyDataUtil.getInstance((Context)context).getLoginData().getToken();
        this.mLoginModule.savePersonInfo(token, personInfoBody).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                LoginSuccess loginSuccess = (LoginSuccess)loginSuccessResponseBody.getResult();
                VertifyDataUtil.getInstance((Context)context).setAccountStatus(loginSuccess.getAccountStatus());
                if (null != ((LoginSuccess)loginSuccessResponseBody.getData()).getDoctorLoginInfo()) {
                    PersonInfoPresent.this.doctorzraddInfo(context, ((LoginSuccess)loginSuccessResponseBody.getData()).getDoctorLoginInfo().getDoctorId(), ((LoginSuccess)loginSuccessResponseBody.getData()).getDoctorLoginInfo().getOrganId());
                }
                PersonInfoPresent.this.mPersonView.showPersonInfo((LoginSuccess)loginSuccessResponseBody.getResult());
            }
        });
    }

    public void doctorzraddInfo(final Context context, String doctorId, String organId) {
        this.mLoginModule.doctorAddInfoCheck(doctorId, organId).subscribe((Observer)new RxProgressObserver<ResponseBody>(){

            public void onReqNext(ResponseBody loginSuccessResponseBody) {
                VertifyDataUtil.getInstance((Context)context).setInfoCheck(((Boolean)loginSuccessResponseBody.getData()).booleanValue());
                EventBus.getDefault().post((Object)new Event.infoCheck(((Boolean)loginSuccessResponseBody.getData()).booleanValue()));
                Log.e((String)"Event.infoCheck---6", (String)(loginSuccessResponseBody.getData() + ""));
            }
        });
    }

    @Deprecated
    public void updatePersonInfo(Context context, PersonInfoBody personInfoBody) {
    }

    public void saveCertifyInfo(final Context context, ReqWebBody reqWebBody) {
        String token = VertifyDataUtil.getInstance((Context)context).getLoginData().getToken();
        this.mLoginModule.saveCertifyInfo(token, reqWebBody).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                LoginSuccess loginSuccess = (LoginSuccess)loginSuccessResponseBody.getResult();
                VertifyDataUtil.getInstance((Context)context).setAccountStatus(loginSuccess.getAccountStatus());
                if (null != loginSuccess.getDoctorLoginInfo()) {
                    PersonInfoPresent.this.doctorzraddInfo(context, loginSuccess.getDoctorLoginInfo().getDoctorId(), loginSuccess.getDoctorLoginInfo().getOrganId());
                }
                PersonInfoPresent.this.mPersonView.showPersonInfo((LoginSuccess)loginSuccessResponseBody.getResult());
            }
        });
    }

    public void updateCertified(Context context, ReqWebBody reqWebBody) {
        String token = VertifyDataUtil.getInstance((Context)context).getLoginData().getToken();
        this.mLoginModule.updateCertified(token, reqWebBody).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                PersonInfoPresent.this.mPersonView.showPersonInfo((LoginSuccess)loginSuccessResponseBody.getResult());
            }
        });
    }

    public void init(Context context) {
    }
}

