/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ListAdapter;
import com.byh.lib.byhim.FrameContractsActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.adapter.GroupMembersAdapter;
import com.byh.lib.byhim.present.impl.MemberListPresent;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.MembersGroupPageView;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.response.GroupMembersEntity;
import com.kangxin.common.byh.entity.response.MembersPageBean;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.NoScrollGridView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnLoadmoreListener;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

public class GroupMembersActivity
extends BaseActivity
implements IToolView,
MembersGroupPageView {
    private static final String TAG = "GroupMembersActivity";
    private SmartRefreshLayout mSmartRefreshLayout;
    private MemberListPresent mMemberListPresent;
    private GroupMembersAdapter mGroupMembersAdapter;
    private int mLoadMoreIndex = 1;
    private List<GroupMembersEntity> mGroupMemBersList = new ArrayList<GroupMembersEntity>();

    public void start() {
        this.mMemberListPresent = new MemberListPresent(this);
        this.vToolTitleTextView.setText(R.string.byhim_im_group_members);
        this.mSmartRefreshLayout = (SmartRefreshLayout)this.findViewById(R.id.refresh_loading);
        this.mSmartRefreshLayout.setEnableRefresh(false);
        this.mSmartRefreshLayout.setEnableLoadmore(true);
        final String groupId = RongUtil.getInstance().getChatExtraBean().getTargetId();
        final String docId = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getLoginUserId() + "";
        this.mSmartRefreshLayout.setOnLoadmoreListener(new OnLoadmoreListener(){

            public void onLoadmore(RefreshLayout refreshlayout) {
                GroupMembersActivity.this.mLoadMoreIndex++;
                GroupMembersActivity.this.mMemberListPresent.reqGroupMembersByPage(groupId, docId, GroupMembersActivity.this.mLoadMoreIndex, 45, "");
            }
        });
        NoScrollGridView noScrollGridView = (NoScrollGridView)this.findViewById(R.id.vGridView);
        this.mGroupMembersAdapter = new GroupMembersAdapter(this.getBaseContext());
        noScrollGridView.setAdapter((ListAdapter)this.mGroupMembersAdapter);
        this.mMemberListPresent.reqGroupMembersByPage(groupId, docId, this.mLoadMoreIndex, 45, "");
        this.mGroupMembersAdapter.setOnClickMemberItemListener(new GroupMembersAdapter.ClickMemberItemListener(){

            @Override
            public void clickItem(int position, GroupMembersEntity groupMembersEntity) {
                String doctorId = groupMembersEntity.getDoctorId();
                if (!TextUtils.isEmpty((CharSequence)doctorId)) {
                    int docId = Integer.parseInt(doctorId);
                    GroupMembersActivity.this.startActivity(new Intent(GroupMembersActivity.this.getBaseContext(), FrameContractsActivity.class).putExtra("MSG_JUMP_TYPE", 5394).putExtra("IM_DOCTOR_ID", docId));
                }
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveAddOrDelMemberEvent(ByhCommEvent.DelMembersOk delMembersOk) {
        this.finish();
    }

    public int getContentLayoutId() {
        return R.layout.byhim_group_members_activity;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    @Override
    public void bindMembersGroup(MembersPageBean membersPageBean) {
        this.mSmartRefreshLayout.finishLoadmore();
        Log.i((String)TAG, (String)("groupMembersEntityList==>" + this.mGroupMemBersList));
        List groupMembersEntityList = membersPageBean.getPageData();
        if (groupMembersEntityList == null) {
            return;
        }
        if (groupMembersEntityList.isEmpty()) {
            return;
        }
        if (this.mGroupMemBersList.isEmpty()) {
            this.mGroupMemBersList.addAll(groupMembersEntityList);
        } else {
            this.mGroupMemBersList.addAll(this.mGroupMemBersList.size() - 1, groupMembersEntityList);
        }
        Log.i((String)TAG, (String)("groupMembersEntityList===size=>" + this.mGroupMemBersList.size()));
        this.mGroupMembersAdapter.addCollection(this.mGroupMemBersList);
        this.mGroupMembersAdapter.notifyDataSetChanged();
    }
}

