/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.LogUtils;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.adapter.ImPatInfoGridAdapter;
import com.byh.lib.byhim.widget.dialog.SelConsTypeDialog;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.activity.MulitImageShowActivity;
import com.kangxin.common.byh.entity.PatientEntity;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.common.byh.inter.CloseNewApplyEvent;
import com.kangxin.common.byh.inter.CloseNewApplyMsgEvent;
import com.kangxin.common.byh.util.ActivityUtils;
import com.kangxin.common.util.TimeUtil;
import com.kangxin.common.widget.NoScrollGridView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.jetbrains.annotations.NotNull;

@Route(path="/patientdetail/patient_detail_activity")
public class HuanZheDetailsActivity
extends BaseActivity
implements IToolView {
    private static final String TAG = "HuanZheDetailsActivity";
    private PatientDetailEntity mPatientDetail;

    public void start() {
        ActivityUtils.addActivity((Activity)this);
        this.mPatientDetail = (PatientDetailEntity)this.getIntent().getSerializableExtra("MSG_APPLY_DETAIL");
        Button huanzBtn = (Button)this.findViewById(R.id.btn_shnqhz);
        int jumpType = this.getIntent().getIntExtra("MSG_JUMP_TYPE", -1);
        switch (jumpType) {
            case 5381: {
                this.vToolTitleTextView.setText(R.string.shenq_details);
                huanzBtn.setVisibility(0);
                break;
            }
            case 5380: {
                this.vToolTitleTextView.setText(R.string.guah_details);
                huanzBtn.setVisibility(8);
            }
        }
        if (this.mPatientDetail.isHideBottomButton()) {
            huanzBtn.setVisibility(8);
        }
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.info_list);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getMContext()));
        BaseQuickAdapter<HuanInfo, BaseViewHolder> patientInfoAdapter = new BaseQuickAdapter<HuanInfo, BaseViewHolder>(R.layout.huandetail_item, this.getHuanInfos()){

            protected void convert(BaseViewHolder helper, HuanInfo item) {
                helper.setText(R.id.title, (CharSequence)item.title);
                helper.setText(R.id.value, (CharSequence)item.value);
            }
        };
        ArrayList<String> picImsg = new ArrayList<String>();
        for (PatientDetailEntity.AttchMentEntity attchMentEntity : this.mPatientDetail.getCaseAttachmentList()) {
            picImsg.add(attchMentEntity.getUrl());
        }
        if (!picImsg.isEmpty()) {
            patientInfoAdapter.addFooterView(this.getPatFootView(picImsg));
        }
        recyclerView.setAdapter((RecyclerView.Adapter)patientInfoAdapter);
    }

    private View getPatFootView(final List<String> imgsList) {
        View pDataFootView = LayoutInflater.from((Context)this.getBaseContext()).inflate(R.layout.im_patientinfo_footview, null);
        if (pDataFootView instanceof NoScrollGridView) {
            ImPatInfoGridAdapter imPatInfoGridAdapter = new ImPatInfoGridAdapter(this.getBaseContext());
            imPatInfoGridAdapter.addCollection(imgsList);
            ((NoScrollGridView)pDataFootView).setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                    Log.i((String)HuanZheDetailsActivity.TAG, (String)("==onItemClick=>" + i));
                    Log.i((String)HuanZheDetailsActivity.TAG, (String)("==onItemClick=size=>" + imgsList.size()));
                    HuanZheDetailsActivity.this.startActivity(new Intent(HuanZheDetailsActivity.this.getBaseContext(), MulitImageShowActivity.class).putExtra("position", i).putStringArrayListExtra("images", (ArrayList)imgsList));
                }
            });
            ((NoScrollGridView)pDataFootView).setAdapter((ListAdapter)imPatInfoGridAdapter);
        }
        return pDataFootView;
    }

    public void clickShenqHuiz(View view) {
        final SelConsTypeDialog selConsTypeDialog = new SelConsTypeDialog((Context)this);
        selConsTypeDialog.setOnClickApplyItemListener(new SelConsTypeDialog.OnClickApplyItemListener(){

            @Override
            public void clickDoctorTeam() {
                PatientEntity patientEntity = HuanZheDetailsActivity.this.mPatientDetail.parsePatientEntity();
                Log.i((String)HuanZheDetailsActivity.TAG, (String)("==patientEntity==>" + patientEntity));
                ARouter.getInstance().build("/workTable/HospitalUnionActivity").withSerializable("mPatientEntity", (Serializable)patientEntity).navigation();
                selConsTypeDialog.dismiss();
            }

            @Override
            public void clickDoctorProfes() {
                PatientEntity patientEntity = HuanZheDetailsActivity.this.mPatientDetail.parsePatientEntity();
                Log.i((String)HuanZheDetailsActivity.TAG, (String)("==patientEntity==>" + patientEntity));
                ARouter.getInstance().build("/workTable/FamousExpertActivity").withSerializable("mPatientEntity", (Serializable)patientEntity).navigation();
                selConsTypeDialog.dismiss();
            }

            @Override
            public void clickDistritMode() {
                PatientEntity patientEntity = HuanZheDetailsActivity.this.mPatientDetail.parsePatientEntity();
                Log.i((String)HuanZheDetailsActivity.TAG, (String)("==patientEntity==>" + patientEntity));
                ARouter.getInstance().build("/workTable/QuickAllocationActivity").withSerializable("mPatientEntity", (Serializable)patientEntity).navigation();
                selConsTypeDialog.dismiss();
            }
        });
        selConsTypeDialog.show();
    }

    public int getContentLayoutId() {
        return R.layout.shqi_details_activity;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    private List<HuanInfo> getHuanInfos() {
        ArrayList<HuanInfo> huanInfos = new ArrayList<HuanInfo>();
        if (this.mPatientDetail != null) {
            huanInfos.add(new HuanInfo("\u59d3\u540d\uff1a", this.mPatientDetail.getPatientName()));
            int pSex = this.mPatientDetail.getPatientSex();
            String sex = pSex == 1 ? "\u7537" : "\u5973";
            huanInfos.add(new HuanInfo("\u6027\u522b\uff1a", sex));
            huanInfos.add(new HuanInfo("\u5e74\u9f84\uff1a", this.mPatientDetail.getPatientAge() + ""));
            huanInfos.add(new HuanInfo("\u8eab\u4efd\u8bc1\u53f7\uff1a", this.mPatientDetail.getPatIdCard()));
            huanInfos.add(new HuanInfo("\u8054\u7cfb\u65b9\u5f0f\uff1a", this.mPatientDetail.getPatientTel()));
            huanInfos.add(new HuanInfo("\u4e3b\u8bc9\uff1a", this.mPatientDetail.getPatCaseMainSuit()));
            String time = TimeUtil.utc2Local((String)this.mPatientDetail.getPatCreateTime(), (String)"yyyy-MM-dd HH:mm");
            huanInfos.add(new HuanInfo("\u7533\u8bf7\u65f6\u95f4\uff1a", time));
            if (this.mPatientDetail.getCaseAttachmentList() != null && this.mPatientDetail.getCaseAttachmentList().size() > 0) {
                huanInfos.add(new HuanInfo("\u75c5\u5386\u8d44\u6599\uff1a", ""));
            } else {
                huanInfos.add(new HuanInfo("\u75c5\u5386\u8d44\u6599\uff1a", "\u6682\u65e0"));
            }
        }
        return huanInfos;
    }

    @Subscribe(sticky=true)
    void finishNewApply(CloseNewApplyEvent event) {
        LogUtils.i((Object[])new Object[]{"\u8fd4\u56de2"});
        EventBus.getDefault().post((Object)new CloseNewApplyMsgEvent());
        this.finish();
    }

    class HuanInfo {
        String title;
        String value;

        public HuanInfo(String title, String value) {
            this.title = title;
            this.value = value;
        }
    }
}

