/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim;

import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.byh.lib.byhim.Event;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.adapter.QuitGroupMemberAdapter;
import com.byh.lib.byhim.bean.UnGroupBody;
import com.byh.lib.byhim.present.QuitGroupPresent;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.QuitGroupView;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.response.GroupMembersEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.indexablerv.IndexableAdapter;
import me.yokeyword.indexablerv.IndexableLayout;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

public class ImQuitGroupMemberActivity
extends BaseActivity
implements IToolView,
QuitGroupView {
    private EditText mSearchEdtView;
    private IndexableLayout mIndexLayout;
    private QuitGroupMemberAdapter mQuitGroupMemberAdapter;
    private List<GroupMembersEntity> mGroupMembersEntities;
    private QuitGroupPresent mQuitGroupPrensent;

    public void start() {
        this.mQuitGroupPrensent = new QuitGroupPresent(this);
        this.mGroupMembersEntities = (List)((Object)this.getIntent().getSerializableExtra("GROUP_MEMBERS_KEY"));
        this.initViews();
        if (this.mGroupMembersEntities != null) {
            this.mQuitGroupMemberAdapter.setDatas(this.mGroupMembersEntities);
            this.mQuitGroupMemberAdapter.notifyDataSetChanged();
        }
    }

    private void initViews() {
        this.vToolTitleTextView.setText(R.string.byhim_delete_group_members);
        this.vToolRightTextView.setVisibility(0);
        this.vToolRightTextView.setText(R.string.im_ok);
        this.vToolRightTextView.setTextColor(-1);
        this.vToolRightTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImQuitGroupMemberActivity.this.delGroupMembers();
            }
        });
        this.mSearchEdtView = (EditText)this.findViewById(R.id.search_bar);
        this.mIndexLayout = (IndexableLayout)this.findViewById(R.id.vIndexLayout);
        this.mIndexLayout.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getMContext()));
        this.mQuitGroupMemberAdapter = new QuitGroupMemberAdapter(this.getBaseContext());
        this.mIndexLayout.setAdapter((IndexableAdapter)this.mQuitGroupMemberAdapter);
        this.mQuitGroupMemberAdapter.setOnItemContentClickListener((IndexableAdapter.OnItemContentClickListener)new IndexableAdapter.OnItemContentClickListener<GroupMembersEntity>(){

            public void onItemClick(View v, int originalPosition, int currentPosition, GroupMembersEntity entity) {
                if (((GroupMembersEntity)ImQuitGroupMemberActivity.this.mGroupMembersEntities.get(originalPosition)).isSelected()) {
                    ((GroupMembersEntity)ImQuitGroupMemberActivity.this.mGroupMembersEntities.get(originalPosition)).setSelected(false);
                } else {
                    ((GroupMembersEntity)ImQuitGroupMemberActivity.this.mGroupMembersEntities.get(originalPosition)).setSelected(true);
                }
                ImQuitGroupMemberActivity.this.mQuitGroupMemberAdapter.notifyDataSetChanged();
            }
        });
        this.mSearchEdtView.setOnEditorActionListener((textView, actionId, event) -> {
            String searchParam;
            List<GroupMembersEntity> groupMembersEntities;
            if (actionId == 3 && (groupMembersEntities = this.searchGroupMembers(searchParam = this.mSearchEdtView.getText().toString().trim())) != null) {
                this.mQuitGroupMemberAdapter.setDatas(groupMembersEntities);
            }
            return false;
        });
    }

    private void delGroupMembers() {
        List<GroupMembersEntity> groupMembersEntityList = this.filterSelectedMembers();
        if (groupMembersEntityList == null) {
            return;
        }
        if (groupMembersEntityList.size() == 0) {
            this.showShortToast("\u8bf7\u9009\u62e9\u7fa4\u6210\u5458");
            return;
        }
        String groupId = RongUtil.getInstance().getChatExtraBean().getTargetId();
        UnGroupBody unGroupBody = new UnGroupBody();
        unGroupBody.setGroupId(groupId);
        ArrayList<UnGroupBody.RongCloudUserIdVoListBean> rongCloudUserIdVoListBeanList = new ArrayList<UnGroupBody.RongCloudUserIdVoListBean>();
        for (GroupMembersEntity groupMembersEntity : groupMembersEntityList) {
            UnGroupBody.RongCloudUserIdVoListBean rongCloudUserIdVoListBean = new UnGroupBody.RongCloudUserIdVoListBean();
            rongCloudUserIdVoListBean.setUserId(groupMembersEntity.getDoctorId());
            rongCloudUserIdVoListBean.setRongCloudId(groupMembersEntity.getRongCloudId());
            rongCloudUserIdVoListBeanList.add(rongCloudUserIdVoListBean);
        }
        unGroupBody.setRongCloudUserIdVoList(rongCloudUserIdVoListBeanList);
        this.mQuitGroupPrensent.reqQuitGroup(unGroupBody);
    }

    private List<GroupMembersEntity> filterSelectedMembers() {
        if (this.mGroupMembersEntities == null) {
            return null;
        }
        ArrayList<GroupMembersEntity> groupMembersEntityList = new ArrayList<GroupMembersEntity>();
        for (GroupMembersEntity groupMembersEntity : this.mGroupMembersEntities) {
            if (!groupMembersEntity.isSelected()) continue;
            groupMembersEntityList.add(groupMembersEntity);
        }
        return groupMembersEntityList;
    }

    private List<GroupMembersEntity> searchGroupMembers(String searchParam) {
        if (this.mGroupMembersEntities == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)searchParam)) {
            return this.mGroupMembersEntities;
        }
        ArrayList<GroupMembersEntity> groupMembersEntityList = new ArrayList<GroupMembersEntity>();
        if (this.mGroupMembersEntities != null) {
            for (GroupMembersEntity groupMembersEntity : this.mGroupMembersEntities) {
                if (!groupMembersEntity.getDisplayName().contains(searchParam)) continue;
                groupMembersEntityList.add(groupMembersEntity);
            }
        }
        return groupMembersEntityList;
    }

    public int getContentLayoutId() {
        return R.layout.im_groupchat_activity;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    @Override
    public void quitGroupOk() {
        this.showShortToast("\u5220\u9664\u6210\u529f");
        EventBus.getDefault().post((Object)new Event.ImFlushEvent());
        EventBus.getDefault().post((Object)new ByhCommEvent.DelMembersOk());
        this.finish();
    }

    public void onError(String msg) {
    }
}

